# This file has been autogenerated by the pywayland scanner

# Copyright 2016 The Chromium Authors.
# Copyright 2017 Intel Corporation
# Copyright 2018 Collabora, Ltd
# Copyright 2021 Simon Ser
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from .wp_linux_drm_syncobj_timeline_v1 import WpLinuxDrmSyncobjTimelineV1


class WpLinuxDrmSyncobjSurfaceV1(Interface):
    """Per-surface explicit synchronization

    This object is an add-on interface for
    :class:`~pywayland.protocol.wayland.WlSurface` to enable explicit
    synchronization.

    Each surface can be associated with only one object of this interface at
    any time.

    Explicit synchronization is guaranteed to be supported for buffers created
    with any version of the linux-dmabuf protocol. Compositors are free to
    support explicit synchronization for additional buffer types. If at surface
    commit time the attached buffer does not support explicit synchronization,
    an unsupported_buffer error is raised.

    As long as the :class:`WpLinuxDrmSyncobjSurfaceV1` object is alive, the
    compositor may ignore implicit synchronization for buffers attached and
    committed to the :class:`~pywayland.protocol.wayland.WlSurface`. The
    delivery of :func:`WlBuffer.release()
    <pywayland.protocol.wayland.WlBuffer.release>` events for buffers attached
    to the surface becomes undefined.

    Clients must set both acquire and release points if and only if a non-null
    buffer is attached in the same surface commit. See the no_buffer,
    no_acquire_point and no_release_point protocol errors.

    If at surface commit time the acquire and release DRM syncobj timelines are
    identical, the acquire point value must be strictly less than the release
    point value, or else the conflicting_points protocol error is raised.
    """

    name = "wp_linux_drm_syncobj_surface_v1"
    version = 1

    class error(enum.IntEnum):
        no_surface = 1
        unsupported_buffer = 2
        no_buffer = 3
        no_acquire_point = 4
        no_release_point = 5
        conflicting_points = 6


class WpLinuxDrmSyncobjSurfaceV1Proxy(Proxy[WpLinuxDrmSyncobjSurfaceV1]):
    interface = WpLinuxDrmSyncobjSurfaceV1

    @WpLinuxDrmSyncobjSurfaceV1.request()
    def destroy(self) -> None:
        """Destroy the surface synchronization object

        Destroy this surface synchronization object.

        Any timeline point set by this object with set_acquire_point or
        set_release_point since the last commit may be discarded by the
        compositor. Any timeline point set by this object before the last
        commit will not be affected.
        """
        self._marshal(0)
        self._destroy()

    @WpLinuxDrmSyncobjSurfaceV1.request(
        Argument(ArgumentType.Object, interface=WpLinuxDrmSyncobjTimelineV1),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
    )
    def set_acquire_point(self, timeline: WpLinuxDrmSyncobjTimelineV1, point_hi: int, point_lo: int) -> None:
        """Set the acquire timeline point

        Set the timeline point that must be signalled before the compositor may
        sample from the buffer attached with :func:`WlSurface.attach()
        <pywayland.protocol.wayland.WlSurface.attach>`.

        The 64-bit unsigned value combined from point_hi and point_lo is the
        point value.

        The acquire point is double-buffered state, and will be applied on the
        next :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>` request for the
        associated surface. Thus, it applies only to the buffer that is
        attached to the surface at commit time.

        If an acquire point has already been attached during the same commit
        cycle, the new point replaces the old one.

        If the associated :class:`~pywayland.protocol.wayland.WlSurface` was
        destroyed, a no_surface error is raised.

        If at surface commit time there is a pending acquire timeline point set
        but no pending buffer attached, a no_buffer error is raised. If at
        surface commit time there is a pending buffer attached but no pending
        acquire timeline point set, the no_acquire_point protocol error is
        raised.

        :param timeline:
        :type timeline:
            :class:`~pywayland.protocol.linux_drm_syncobj_v1.WpLinuxDrmSyncobjTimelineV1`
        :param point_hi:
            high 32 bits of the point value
        :type point_hi:
            `ArgumentType.Uint`
        :param point_lo:
            low 32 bits of the point value
        :type point_lo:
            `ArgumentType.Uint`
        """
        self._marshal(1, timeline, point_hi, point_lo)

    @WpLinuxDrmSyncobjSurfaceV1.request(
        Argument(ArgumentType.Object, interface=WpLinuxDrmSyncobjTimelineV1),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
    )
    def set_release_point(self, timeline: WpLinuxDrmSyncobjTimelineV1, point_hi: int, point_lo: int) -> None:
        """Set the release timeline point

        Set the timeline point that must be signalled by the compositor when it
        has finished its usage of the buffer attached with
        :func:`WlSurface.attach()
        <pywayland.protocol.wayland.WlSurface.attach>` for the relevant commit.

        Once the timeline point is signaled, and assuming the associated buffer
        is not pending release from other :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>` requests, no additional
        explicit or implicit synchronization with the compositor is required to
        safely re-use the buffer.

        Note that clients cannot rely on the release point being always
        signaled after the acquire point: compositors may release buffers
        without ever reading from them. In addition, the compositor may use
        different presentation paths for different commits, which may have
        different release behavior. As a result, the compositor may signal the
        release points in a different order than the client committed them.

        Because signaling a timeline point also signals every previous point,
        it is generally not safe to use the same timeline object for the
        release points of multiple buffers. The out-of-order signaling
        described above may lead to a release point being signaled before the
        compositor has finished reading. To avoid this, it is strongly
        recommended that each buffer should use a separate timeline for its
        release points.

        The 64-bit unsigned value combined from point_hi and point_lo is the
        point value.

        The release point is double-buffered state, and will be applied on the
        next :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>` request for the
        associated surface. Thus, it applies only to the buffer that is
        attached to the surface at commit time.

        If a release point has already been attached during the same commit
        cycle, the new point replaces the old one.

        If the associated :class:`~pywayland.protocol.wayland.WlSurface` was
        destroyed, a no_surface error is raised.

        If at surface commit time there is a pending release timeline point set
        but no pending buffer attached, a no_buffer error is raised. If at
        surface commit time there is a pending buffer attached but no pending
        release timeline point set, the no_release_point protocol error is
        raised.

        :param timeline:
        :type timeline:
            :class:`~pywayland.protocol.linux_drm_syncobj_v1.WpLinuxDrmSyncobjTimelineV1`
        :param point_hi:
            high 32 bits of the point value
        :type point_hi:
            `ArgumentType.Uint`
        :param point_lo:
            low 32 bits of the point value
        :type point_lo:
            `ArgumentType.Uint`
        """
        self._marshal(2, timeline, point_hi, point_lo)


class WpLinuxDrmSyncobjSurfaceV1Resource(Resource):
    interface = WpLinuxDrmSyncobjSurfaceV1


class WpLinuxDrmSyncobjSurfaceV1Global(Global):
    interface = WpLinuxDrmSyncobjSurfaceV1


WpLinuxDrmSyncobjSurfaceV1._gen_c()
WpLinuxDrmSyncobjSurfaceV1.proxy_class = WpLinuxDrmSyncobjSurfaceV1Proxy
WpLinuxDrmSyncobjSurfaceV1.resource_class = WpLinuxDrmSyncobjSurfaceV1Resource
WpLinuxDrmSyncobjSurfaceV1.global_class = WpLinuxDrmSyncobjSurfaceV1Global
