/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.dependency.fest_reflect.constructor;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import org.assertj.swing.dependency.fest_reflect.exception.ReflectionError;
import org.assertj.swing.dependency.fest_reflect.util.Accessibles;
import org.assertj.swing.dependency.fest_reflect.util.Throwables;
import org.assertj.swing.dependency.fest_util.Strings;

public final class Invoker<T> {
    private final Constructor<T> constructor;

    public static <T> Invoker<T> newInvoker(Class<T> target, Class<?> ... parameterTypes) {
        Constructor<T> constructor = Invoker.constructor(target, parameterTypes);
        return new Invoker<T>(constructor);
    }

    private static <T> Constructor<T> constructor(Class<T> target, Class<?> ... parameterTypes) {
        try {
            return target.getDeclaredConstructor(parameterTypes);
        }
        catch (Exception e) {
            throw new ReflectionError(Strings.concat("Unable to find constructor in type ", target.getName(), " with parameter types ", Arrays.toString(parameterTypes)), e);
        }
    }

    private Invoker(Constructor<T> constructor) {
        this.constructor = constructor;
    }

    public T newInstance(Object ... args) {
        boolean accessible = this.constructor.isAccessible();
        try {
            T newInstance;
            Accessibles.makeAccessible(this.constructor);
            T t = newInstance = this.constructor.newInstance(args);
            return t;
        }
        catch (Throwable t) {
            Throwable cause = Throwables.targetOf(t);
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new ReflectionError("Unable to create a new object from the enclosed constructor", cause);
        }
        finally {
            Accessibles.setAccessibleIgnoringExceptions(this.constructor, accessible);
        }
    }

    public Constructor<T> info() {
        return this.constructor;
    }
}

