/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import java.io.File;
import java.io.FilenameFilter;
import org.apache.uniffle.common.ShuffleDataResult;
import org.apache.uniffle.common.ShuffleIndexResult;
import org.apache.uniffle.common.exception.FileNotFoundException;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.netty.buffer.FileSegmentManagedBuffer;
import org.apache.uniffle.common.netty.buffer.ManagedBuffer;
import org.apache.uniffle.storage.handler.api.ServerReadHandler;
import org.apache.uniffle.storage.util.ShuffleStorageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileServerReadHandler
implements ServerReadHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LocalFileServerReadHandler.class);
    private String indexFileName = "";
    private String dataFileName = "";
    private String appId;
    private int shuffleId;
    private int partitionId;

    public LocalFileServerReadHandler(String appId, int shuffleId, int partitionId, int partitionNumPerRange, int partitionNum, String path) {
        this.appId = appId;
        this.shuffleId = shuffleId;
        this.partitionId = partitionId;
        this.init(appId, shuffleId, partitionId, partitionNumPerRange, partitionNum, path);
    }

    private void init(String appId, int shuffleId, int partitionId, int partitionNumPerRange, int partitionNum, String path) {
        long start = System.currentTimeMillis();
        this.prepareFilePath(appId, shuffleId, partitionId, partitionNumPerRange, partitionNum, path);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Prepare for appId[" + appId + "], shuffleId[" + shuffleId + "], partitionId[" + partitionId + "] cost " + (System.currentTimeMillis() - start) + " ms");
        }
    }

    private void prepareFilePath(String appId, int shuffleId, int partitionId, int partitionNumPerRange, int partitionNum, String storageBasePath) {
        File[] indexFiles;
        String fullShufflePath = ShuffleStorageUtils.getFullShuffleDataFolder(storageBasePath, ShuffleStorageUtils.getShuffleDataPathWithRange(appId, shuffleId, partitionId, partitionNumPerRange, partitionNum));
        File baseFolder = new File(fullShufflePath);
        if (!baseFolder.exists()) {
            throw new FileNotFoundException("Can't find folder " + fullShufflePath);
        }
        String failedGetIndexFileMsg = "No index file found in  " + storageBasePath;
        try {
            indexFiles = baseFolder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".index");
                }
            });
        }
        catch (Exception e) {
            throw new FileNotFoundException(failedGetIndexFileMsg, (Throwable)e);
        }
        if (indexFiles != null && indexFiles.length > 0) {
            if (indexFiles.length != 1) {
                throw new RssException("More index file than expected: " + indexFiles.length);
            }
            String fileNamePrefix = this.getFileNamePrefix(indexFiles[0].getName());
            this.indexFileName = fullShufflePath + "/" + ShuffleStorageUtils.generateIndexFileName(fileNamePrefix);
            this.dataFileName = fullShufflePath + "/" + ShuffleStorageUtils.generateDataFileName(fileNamePrefix);
        }
    }

    private String getFileNamePrefix(String fileName) {
        int point = fileName.lastIndexOf(".");
        return fileName.substring(0, point);
    }

    @Override
    public ShuffleDataResult getShuffleData(long offset, int length) {
        return new ShuffleDataResult((ManagedBuffer)new FileSegmentManagedBuffer(new File(this.dataFileName), offset, length));
    }

    @Override
    public ShuffleIndexResult getShuffleIndex() {
        int indexNum;
        int len;
        File indexFile = new File(this.indexFileName);
        long indexFileSize = indexFile.length();
        if (indexFileSize != (long)(len = (indexNum = (int)(indexFileSize / 40L)) * 40)) {
            LOG.warn("Maybe the index file: {} is being written due to the shuffle-buffer flushing.", (Object)this.indexFileName);
        }
        long dataFileSize = new File(this.dataFileName).length();
        return new ShuffleIndexResult((ManagedBuffer)new FileSegmentManagedBuffer(indexFile, 0L, len), dataFileSize);
    }
}

