/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.common;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.uniffle.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalStorageMeta {
    private static final Logger LOG = LoggerFactory.getLogger(LocalStorageMeta.class);
    private final AtomicLong size = new AtomicLong(0L);
    private final Map<String, ShuffleMeta> shuffleMetaMap = JavaUtils.newConcurrentMap();

    public void updateDiskSize(long delta) {
        this.size.addAndGet(delta);
    }

    public void updateShuffleSize(String shuffleId, long delta) {
        ShuffleMeta shuffleMeta = this.getShuffleMeta(shuffleId);
        if (shuffleMeta != null) {
            shuffleMeta.getSize().addAndGet(delta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShufflePartitionList(String shuffleKey, List<Integer> partitions) {
        ShuffleMeta shuffleMeta = this.getShuffleMeta(shuffleKey);
        if (shuffleMeta != null) {
            RoaringBitmap bitmap;
            RoaringBitmap roaringBitmap = bitmap = shuffleMeta.partitionBitmap;
            synchronized (roaringBitmap) {
                partitions.forEach(bitmap::add);
            }
        }
    }

    public void prepareStartRead(String shuffleId) {
        ShuffleMeta shuffleMeta = this.getShuffleMeta(shuffleId);
        if (shuffleMeta != null) {
            shuffleMeta.markStartRead();
        }
    }

    public void removeShuffle(String shuffleKey) {
        this.shuffleMetaMap.remove(shuffleKey);
    }

    public AtomicLong getDiskSize() {
        return this.size;
    }

    public long getShuffleSize(String shuffleKey) {
        ShuffleMeta shuffleMeta = this.getShuffleMeta(shuffleKey);
        return shuffleMeta == null ? 0L : shuffleMeta.getSize().get();
    }

    public Set<String> getShuffleMetaSet() {
        return this.shuffleMetaMap.keySet();
    }

    @VisibleForTesting
    public void setSize(long diskSize) {
        this.size.set(diskSize);
    }

    public void createMetadataIfNotExist(String shuffleKey) {
        ShuffleMeta meta = new ShuffleMeta();
        ShuffleMeta oldMeta = this.shuffleMetaMap.putIfAbsent(shuffleKey, meta);
        if (oldMeta == null) {
            LOG.info("Create metadata of shuffle {}.", (Object)shuffleKey);
        }
    }

    private ShuffleMeta getShuffleMeta(String shuffleKey) {
        ShuffleMeta shuffleMeta = this.shuffleMetaMap.get(shuffleKey);
        if (shuffleMeta == null && LOG.isDebugEnabled()) {
            LOG.debug("Shuffle {} metadata has been removed!", (Object)shuffleKey);
        }
        return shuffleMeta;
    }

    public void updateShuffleLastReadTs(String shuffleKey) {
        ShuffleMeta shuffleMeta = this.getShuffleMeta(shuffleKey);
        if (shuffleMeta != null) {
            shuffleMeta.updateLastReadTs();
        }
    }

    private static class ShuffleMeta {
        private final AtomicLong size = new AtomicLong(0L);
        private final RoaringBitmap partitionBitmap = RoaringBitmap.bitmapOf(new int[0]);
        private final AtomicBoolean isStartRead = new AtomicBoolean(false);
        private final AtomicLong lastReadTs = new AtomicLong(-1L);

        private ShuffleMeta() {
        }

        public AtomicLong getSize() {
            return this.size;
        }

        public void markStartRead() {
            this.isStartRead.set(true);
        }

        public void updateLastReadTs() {
            this.lastReadTs.set(System.currentTimeMillis());
        }
    }
}

