/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.example.extensions;

import java.util.List;
import org.antlr.runtime.RecognitionException;
import org.apache.uima.ruta.ide.core.extensions.IIDEStringFunctionExtension;
import org.apache.uima.ruta.ide.core.extensions.IRutaCheckerProblemFactory;
import org.apache.uima.ruta.ide.parser.ast.RutaFunction;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;

public class ExampleStringFunctionIDEExtension
implements IIDEStringFunctionExtension {
    private final String[] strings = new String[]{"ExampleStringFunction"};

    public String[] getKnownExtensions() {
        return this.strings;
    }

    public boolean checkSyntax(Expression element, IRutaCheckerProblemFactory problemFactory, IProblemReporter rep) throws RecognitionException {
        if (element instanceof RutaFunction) {
            ASTNode expr;
            RutaFunction f = (RutaFunction)element;
            String name = f.getName();
            if (!name.equals(this.strings[0])) {
                IProblem problem = problemFactory.createUnknownFunctionProblem(f);
                rep.reportProblem(problem);
                return false;
            }
            boolean ok = true;
            List childs = f.getChilds();
            if (childs.size() != 1) {
                IProblem problem = problemFactory.createWrongNumberOfArgumentsProblem(name, element, 1);
                rep.reportProblem(problem);
                ok = false;
            }
            if ((expr = (ASTNode)childs.get(0)) instanceof Expression && ((Expression)expr).getKind() != 0x800000) {
                IProblem problem = problemFactory.createWrongArgumentTypeProblem((Expression)expr, "TypeExpression");
                rep.reportProblem(problem);
                ok = false;
            }
            return ok;
        }
        return false;
    }
}

