<!--- Licensed to the Apache Software Foundation (ASF) under one -->
<!--- or more contributor license agreements.  See the NOTICE file -->
<!--- distributed with this work for additional information -->
<!--- regarding copyright ownership.  The ASF licenses this file -->
<!--- to you under the Apache License, Version 2.0 (the -->
<!--- "License"); you may not use this file except in compliance -->
<!--- with the License.  You may obtain a copy of the License at -->

<!---   http://www.apache.org/licenses/LICENSE-2.0 -->

<!--- Unless required by applicable law or agreed to in writing, -->
<!--- software distributed under the License is distributed on an -->
<!--- "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY -->
<!--- KIND, either express or implied.  See the License for the -->
<!--- specific language governing permissions and limitations -->
<!--- under the License. -->

# Contributing to TVM FFI

We welcome contributions of all kinds, including bug fixes, documentation
improvements, enhancements, and more.

- Fork the repository and create a new branch for your work.
- Push your changes to your fork and open a pull request to the main repository.
  - Please provide a clear description of your changes and link to the relevant issue if one exists.
  - Create necessary test cases and documentation.
- Work with the community by incorporating feedback from reviewers until the change is ready to be merged.

For significant changes, it's often a good idea to open a GitHub issue first
(with `[RFC] title`) to discuss your proposal. It is optional, but can be very
helpful as it allows the maintainers and the community to provide feedback and
helps ensure your work aligns with the project's goals.

The full developer manual is hosted at <https://tvm.apache.org/ffi/>. Key pages:

- [Build from Source](https://tvm.apache.org/ffi/dev/source_build.html) -- editable install, CMake flags, C++-only build
- [Build This Doc Site](https://tvm.apache.org/ffi/dev/doc_build.html) -- building the documentation locally
- [Reproduce CI/CD](https://tvm.apache.org/ffi/dev/ci_cd.html) -- linters, pre-commit, unit tests, wheel building
- [Release Process](https://tvm.apache.org/ffi/dev/release_process.html) -- versioning and release workflow
