/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr;

import jakarta.validation.ClockProvider;
import jakarta.validation.ConstraintValidatorFactory;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.ParameterNameProvider;
import jakarta.validation.TraversableResolver;
import jakarta.validation.Validation;
import jakarta.validation.ValidationException;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.spi.ConfigurationState;
import jakarta.validation.valueextraction.ValueExtractor;
import java.io.Closeable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.apache.bval.jsr.ApacheFactoryContext;
import org.apache.bval.jsr.ApacheValidationProvider;
import org.apache.bval.jsr.ApacheValidatorConfiguration;
import org.apache.bval.jsr.ConstraintCached;
import org.apache.bval.jsr.DefaultConstraintValidatorFactory;
import org.apache.bval.jsr.ParticipantFactory;
import org.apache.bval.jsr.descriptor.DescriptorManager;
import org.apache.bval.jsr.groups.GroupsComputer;
import org.apache.bval.jsr.metadata.MetadataBuilder;
import org.apache.bval.jsr.metadata.MetadataBuilders;
import org.apache.bval.jsr.metadata.MetadataSource;
import org.apache.bval.jsr.util.AnnotationsManager;
import org.apache.bval.jsr.valueextraction.ValueExtractors;
import org.apache.bval.util.CloseableAble;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.weaver.privilizer.Privilizing;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
public class ApacheValidatorFactory
implements ValidatorFactory,
Cloneable {
    private static volatile ApacheValidatorFactory DEFAULT_FACTORY;
    private final Map<String, String> properties;
    private final AnnotationsManager annotationsManager;
    private final DescriptorManager descriptorManager = new DescriptorManager(this);
    private final MetadataBuilders metadataBuilders = new MetadataBuilders();
    private final ConstraintCached constraintsCache = new ConstraintCached();
    private final Map<Class<?>, Class<?>> unwrappedClassCache = new ConcurrentHashMap();
    private final Collection<Closeable> toClose = new ArrayList<Closeable>();
    private final GroupsComputer groupsComputer = new GroupsComputer();
    private final ParticipantFactory participantFactory;
    private final ValueExtractors valueExtractors;
    private MessageInterpolator messageResolver;
    private TraversableResolver traversableResolver;
    private ConstraintValidatorFactory constraintValidatorFactory;
    private ParameterNameProvider parameterNameProvider;
    private ClockProvider clockProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApacheValidatorFactory getDefault() {
        if (DEFAULT_FACTORY != null) return DEFAULT_FACTORY;
        Class<ApacheValidatorFactory> clazz = ApacheValidatorFactory.class;
        synchronized (ApacheValidatorFactory.class) {
            if (DEFAULT_FACTORY != null) return DEFAULT_FACTORY;
            DEFAULT_FACTORY = (ApacheValidatorFactory)((ApacheValidatorConfiguration)Validation.byProvider(ApacheValidationProvider.class).configure()).buildValidatorFactory().unwrap(ApacheValidatorFactory.class);
            // ** MonitorExit[var0] (shouldn't be in output)
            return DEFAULT_FACTORY;
        }
    }

    public static void setDefault(ApacheValidatorFactory aDefaultFactory) {
        DEFAULT_FACTORY = aDefaultFactory;
    }

    private static ValueExtractors createBaseValueExtractors(ParticipantFactory participantFactory) {
        ValueExtractors result = new ValueExtractors(ValueExtractors.OnDuplicateContainerElementKey.OVERWRITE);
        participantFactory.loadServices(ValueExtractor.class).forEach(result::add);
        return result;
    }

    public ApacheValidatorFactory(ConfigurationState configuration) {
        this.properties = new HashMap<String, String>(configuration.getProperties());
        this.parameterNameProvider = configuration.getParameterNameProvider();
        this.messageResolver = configuration.getMessageInterpolator();
        this.traversableResolver = configuration.getTraversableResolver();
        this.constraintValidatorFactory = configuration.getConstraintValidatorFactory();
        this.clockProvider = configuration.getClockProvider();
        if (configuration instanceof CloseableAble) {
            this.toClose.add(((CloseableAble)configuration).getCloseable());
        }
        this.participantFactory = new ParticipantFactory(Thread.currentThread().getContextClassLoader(), ApacheValidatorFactory.class.getClassLoader());
        this.toClose.add(this.participantFactory);
        this.valueExtractors = ApacheValidatorFactory.createBaseValueExtractors(this.participantFactory).createChild();
        configuration.getValueExtractors().forEach(this.valueExtractors::add);
        this.annotationsManager = new AnnotationsManager(this);
        this.loadAndVerifyUserCustomizations(configuration);
    }

    public Map<Class<?>, Class<?>> getUnwrappedClassCache() {
        return this.unwrappedClassCache;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Validator getValidator() {
        return this.usingContext().getValidator();
    }

    public ApacheFactoryContext usingContext() {
        return new ApacheFactoryContext(this);
    }

    public synchronized ApacheValidatorFactory clone() {
        try {
            return (ApacheValidatorFactory)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public final void setMessageInterpolator(MessageInterpolator messageResolver) {
        if (messageResolver != null) {
            this.messageResolver = messageResolver;
        }
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.messageResolver;
    }

    public final void setTraversableResolver(TraversableResolver traversableResolver) {
        if (traversableResolver != null) {
            this.traversableResolver = traversableResolver;
        }
    }

    public void setParameterNameProvider(ParameterNameProvider parameterNameProvider) {
        if (parameterNameProvider != null) {
            this.parameterNameProvider = parameterNameProvider;
        }
    }

    public void setClockProvider(ClockProvider clockProvider) {
        if (clockProvider != null) {
            this.clockProvider = clockProvider;
        }
    }

    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }

    public final void setConstraintValidatorFactory(ConstraintValidatorFactory constraintValidatorFactory) {
        if (constraintValidatorFactory != null) {
            this.constraintValidatorFactory = constraintValidatorFactory;
            if (DefaultConstraintValidatorFactory.class.isInstance(constraintValidatorFactory)) {
                this.toClose.add((Closeable)Closeable.class.cast(constraintValidatorFactory));
            }
        }
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory;
    }

    public ParameterNameProvider getParameterNameProvider() {
        return this.parameterNameProvider;
    }

    public ClockProvider getClockProvider() {
        return this.clockProvider;
    }

    public void close() {
        try {
            for (Closeable c : this.toClose) {
                c.close();
            }
            this.toClose.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isInstance(this)) {
            ApacheValidatorFactory result = this;
            return (T)result;
        }
        if (!type.isInterface() && !Modifier.isAbstract(type.getModifiers())) {
            return this.newInstance(type);
        }
        try {
            Class<?> cls = Reflection.toClass(type.getName() + "Impl");
            if (type.isAssignableFrom(cls)) {
                Object result = this.newInstance(cls);
                return (T)result;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw new ValidationException("Type " + type + " not supported");
    }

    private <T> T newInstance(Class<T> cls) {
        try {
            return Reflection.newInstance(cls);
        }
        catch (RuntimeException e) {
            throw new ValidationException(e.getCause());
        }
    }

    public ConstraintCached getConstraintsCache() {
        return this.constraintsCache;
    }

    public AnnotationsManager getAnnotationsManager() {
        return this.annotationsManager;
    }

    public DescriptorManager getDescriptorManager() {
        return this.descriptorManager;
    }

    public ValueExtractors getValueExtractors() {
        return this.valueExtractors;
    }

    public MetadataBuilders getMetadataBuilders() {
        return this.metadataBuilders;
    }

    public GroupsComputer getGroupsComputer() {
        return this.groupsComputer;
    }

    private void loadAndVerifyUserCustomizations(ConfigurationState configuration) {
        BiConsumer<Class, MetadataBuilder.ForBean> addBuilder = (t, b) -> this.getMetadataBuilders().registerCustomBuilder(t, b);
        this.participantFactory.loadServices(MetadataSource.class).forEach(ms -> {
            ms.initialize(this);
            ms.process(configuration, this.getConstraintsCache()::add, addBuilder);
        });
    }
}

