/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.groups;

import jakarta.validation.GroupDefinitionException;
import jakarta.validation.groups.Default;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.bval.jsr.groups.GroupStrategy;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.ObjectWrapper;

public final class Group
implements GroupStrategy {
    public static final Group DEFAULT = new Group(Default.class);
    private final Class<?> group;

    public static final Group of(Class<?> group) {
        return new Group(group);
    }

    public static final Sequence sequence(Group ... groups) {
        return Group.sequence(Arrays.asList(groups));
    }

    public static final Sequence sequence(Collection<Group> groups) {
        return new Sequence(groups);
    }

    public Group(Class<?> group) {
        this.group = group;
    }

    public Class<?> getGroup() {
        return this.group;
    }

    public String toString() {
        return String.format("%s{group=%s}", Group.class.getSimpleName(), this.group);
    }

    public boolean isDefault() {
        return Default.class.equals(this.group);
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass().equals(o.getClass()) && Objects.equals(this.group, ((Group)o).group);
    }

    public int hashCode() {
        return this.group.hashCode();
    }

    @Override
    public Set<Group> getGroups() {
        return Collections.singleton(this);
    }

    @Override
    public boolean applyTo(Predicate<GroupStrategy> operation) {
        return operation.test(this);
    }

    @Override
    public GroupStrategy redefining(Map<Group, ? extends GroupStrategy> redefinitions) {
        GroupStrategy redefined = redefinitions.get(this);
        return redefined == null ? this : redefined;
    }

    public static final class Sequence
    extends GroupStrategy.Composite {
        private final Set<Group> groups;

        private static Set<Group> validGroups(Collection<Group> groups, Function<Group, ? extends GroupStrategy> mapper) {
            LinkedHashSet<Group> result = new LinkedHashSet<Group>();
            ObjectWrapper prev = new ObjectWrapper();
            groups.stream().map(g -> Optional.of(g).map(mapper).orElse(g)).map(GroupStrategy::getGroups).flatMap(Collection::stream).forEach(g -> {
                if (result.add((Group)g)) {
                    prev.accept(g);
                    return;
                }
                if (!g.equals(prev.get())) {
                    Exceptions.raise(GroupDefinitionException::new, "Invalid group sequence %s specified", groups);
                }
            });
            return result;
        }

        private Sequence(Collection<Group> groups) {
            super(groups, true);
            this.groups = Collections.unmodifiableSet(Sequence.validGroups(groups, Function.identity()));
        }

        @Override
        public Set<Group> getGroups() {
            return this.groups;
        }

        @Override
        public String toString() {
            return String.format("Group sequence: %s", this.groups);
        }

        @Override
        public GroupStrategy redefining(Map<Group, ? extends GroupStrategy> redefinitions) {
            Set<Group> mappedGroups;
            if (Collections.disjoint(redefinitions.keySet(), this.groups)) {
                return this;
            }
            LinkedHashSet components = new LinkedHashSet();
            try {
                mappedGroups = Sequence.validGroups(this.groups, g -> {
                    GroupStrategy result = Optional.of(g).map(redefinitions::get).orElse((GroupStrategy)g);
                    components.add(result);
                    return result;
                });
            }
            catch (GroupDefinitionException e) {
                throw Exceptions.create(GroupDefinitionException::new, "Could not expand %s using %s", this, redefinitions);
            }
            if (components.equals(mappedGroups)) {
                return new Sequence(mappedGroups);
            }
            return new GroupStrategy.Composite(components, this.ordered);
        }
    }
}

