/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mail.james.mime4j.codec;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;

public class Base64OutputStream
extends OutputStream {
    private static final int DEFAULT_LINE_LENGTH = 76;
    private static final byte[] CRLF_SEPARATOR = new byte[]{13, 10};
    static final byte[] BASE64_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private final OutputStream delegate;

    public Base64OutputStream(OutputStream out) {
        this(out, 76, CRLF_SEPARATOR);
    }

    public Base64OutputStream(OutputStream out, int lineLength) {
        this(out, lineLength, CRLF_SEPARATOR);
    }

    public Base64OutputStream(OutputStream out, int lineLength, byte[] lineSeparator) {
        ExtraCrlfOutputStream wrapped = new ExtraCrlfOutputStream(out, lineSeparator);
        this.delegate = Base64.getMimeEncoder(lineLength, lineSeparator).wrap(wrapped);
    }

    @Override
    public void write(int i) throws IOException {
        this.delegate.write(i);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.delegate.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.delegate.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    private static class ExtraCrlfOutputStream
    extends OutputStream {
        private final OutputStream delegate;
        private final byte[] lineSeparator;
        private boolean appendExtraCrlf;

        private ExtraCrlfOutputStream(OutputStream delegate, byte[] lineSeparator) {
            this.delegate = delegate;
            this.lineSeparator = lineSeparator;
            this.appendExtraCrlf = false;
        }

        @Override
        public void write(int i) throws IOException {
            this.delegate.write(i);
            this.appendExtraCrlf = true;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
            this.appendExtraCrlf |= b.length > 0;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
            this.appendExtraCrlf |= len > 0;
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            if (this.appendExtraCrlf) {
                this.delegate.write(this.lineSeparator);
            }
        }
    }
}

