/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentelemetry.implementation.config;

import io.smallrye.opentelemetry.api.OpenTelemetryConfig;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.config.Config;

@Singleton
public class OpenTelemetryConfigProducer {
    @Inject
    Config config;

    @Produces
    @Singleton
    public OpenTelemetryConfig produces() {
        return new OpenTelemetryConfig(){

            public Map<String, String> properties() {
                HashMap<String, String> properties = new HashMap<String, String>();
                for (String propertyName : OpenTelemetryConfigProducer.this.config.getPropertyNames()) {
                    if (!propertyName.startsWith("otel.") && !propertyName.startsWith("OTEL_")) continue;
                    OpenTelemetryConfigProducer.this.config.getOptionalValue(propertyName, String.class).ifPresent(value -> properties.put(propertyName, (String)value));
                }
                return properties;
            }
        };
    }
}

