/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.mdb;

import jakarta.resource.spi.ApplicationServerInternalException;
import jakarta.resource.spi.UnavailableException;
import java.lang.reflect.Method;
import javax.transaction.xa.XAResource;
import org.apache.openejb.BeanContext;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.mdb.AbstractEndpointHandler;
import org.apache.openejb.core.mdb.BaseMdbContainer;
import org.apache.openejb.core.mdb.Instance;
import org.apache.openejb.core.mdb.MdbInstanceFactory;
import org.apache.openejb.core.mdb.State;

public class EndpointHandler
extends AbstractEndpointHandler {
    private final BeanContext deployment;
    private final MdbInstanceFactory instanceFactory;
    private final XAResource xaResource;

    public EndpointHandler(BaseMdbContainer container, BeanContext deployment, MdbInstanceFactory instanceFactory, XAResource xaResource) throws UnavailableException {
        super(container);
        this.deployment = deployment;
        this.instanceFactory = instanceFactory;
        this.xaResource = xaResource;
        this.instance = instanceFactory.createInstance(false);
    }

    @Override
    public void beforeDelivery(Method method) throws ApplicationServerInternalException {
        switch (this.state) {
            case RELEASED: {
                throw new IllegalStateException("Message endpoint factory has been released");
            }
            case BEFORE_CALLED: {
                throw new IllegalStateException("beforeDelivery can not be called again until message is delivered and afterDelivery is called");
            }
            case METHOD_CALLED: 
            case SYSTEM_EXCEPTION: {
                throw new IllegalStateException("The last message delivery must be completed with an afterDeliver before beforeDeliver can be called again");
            }
        }
        try {
            this.container.beforeDelivery(this.deployment, this.instance, method, this.xaResource);
        }
        catch (SystemException se) {
            Throwable throwable = se.getRootCause() != null ? se.getRootCause() : se;
            throw new ApplicationServerInternalException(throwable);
        }
        this.state = State.BEFORE_CALLED;
    }

    @Override
    protected void recreateInstance(boolean exceptionAlreadyThrown) throws UnavailableException {
        block2: {
            try {
                this.instance = this.instanceFactory.recreateInstance(this.instance);
            }
            catch (UnavailableException e) {
                this.state = State.RELEASED;
                if (exceptionAlreadyThrown) break block2;
                throw e;
            }
        }
    }

    @Override
    public void release() {
        if (this.state == State.RELEASED) {
            return;
        }
        this.state = State.RELEASED;
        try {
            this.container.release(this.deployment, this.instance);
        }
        finally {
            this.instanceFactory.freeInstance((Instance)this.instance, false);
            this.instance = null;
        }
    }
}

