/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.time.Duration;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.ParseException;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.lib.util.TypedProperties;

public class Options
extends TypedProperties {
    private static final long serialVersionUID = 1L;
    public static Options EMPTY = new EmptyOptions();
    private static Object[][] _primWrappers = new Object[][]{{Boolean.TYPE, Boolean.class, Boolean.FALSE}, {Byte.TYPE, Byte.class, (byte)0}, {Character.TYPE, Character.class, Character.valueOf('\u0000')}, {Double.TYPE, Double.class, 0.0}, {Float.TYPE, Float.class, Float.valueOf(0.0f)}, {Integer.TYPE, Integer.class, 0}, {Long.TYPE, Long.class, 0L}, {Short.TYPE, Short.class, (short)0}};
    private static Localizer _loc = Localizer.forPackage(Options.class);

    public Options() {
    }

    public Options(Properties defaults) {
        super(defaults);
    }

    public String[] setFromCmdLine(String[] args) {
        if (args == null || args.length == 0) {
            return args;
        }
        String key = null;
        Object value = null;
        LinkedList<String> remainder = new LinkedList<String>();
        for (int i = 0; i < args.length + 1; ++i) {
            if (i == args.length || args[i].startsWith("-")) {
                if ((key = Options.trimQuote(key)) != null) {
                    if (!StringUtil.isEmpty(value)) {
                        this.setProperty(key, Options.trimQuote(value));
                    } else {
                        this.setProperty(key, "true");
                    }
                }
                if (i == args.length) break;
                key = args[i].substring(1);
                value = null;
                continue;
            }
            if (key != null) {
                this.setProperty(key, Options.trimQuote(args[i]));
                key = null;
                continue;
            }
            remainder.add(args[i]);
        }
        return remainder.toArray(new String[remainder.size()]);
    }

    public Options setInto(Object obj) {
        Map.Entry<Object, Object> entry = null;
        if (this.defaults != null) {
            for (Map.Entry<Object, Object> objectObjectEntry : this.defaults.entrySet()) {
                entry = objectObjectEntry;
                if (this.containsKey(entry.getKey())) continue;
                this.setInto(obj, entry);
            }
        }
        Options invalidEntries = null;
        for (Map.Entry<Object, Object> objectObjectEntry : this.entrySet()) {
            Map.Entry<Object, Object> e = objectObjectEntry;
            if (this.setInto(obj, e)) continue;
            if (invalidEntries == null) {
                invalidEntries = new Options();
            }
            invalidEntries.put(e.getKey(), e.getValue());
        }
        return invalidEntries == null ? EMPTY : invalidEntries;
    }

    private boolean setInto(Object obj, Map.Entry entry) {
        if (entry.getKey() == null) {
            return false;
        }
        try {
            int i;
            Object[] match = new Object[]{obj, null};
            if (!Options.matchOptionToMember(entry.getKey().toString(), match)) {
                return false;
            }
            Class<?>[] type = Options.getType(match[1]);
            Object[] values = new Object[type.length];
            String[] strValues = entry.getValue() == null ? new String[1] : (values.length == 1 ? new String[]{entry.getValue().toString()} : StringUtil.split(entry.getValue().toString(), ",", 0));
            for (i = 0; i < strValues.length; ++i) {
                values[i] = this.stringToObject(strValues[i].trim(), type[i]);
            }
            for (i = strValues.length; i < values.length; ++i) {
                values[i] = this.getDefaultValue(type[i]);
            }
            Options.invoke(match[0], match[1], values);
            return true;
        }
        catch (Throwable t) {
            throw new ParseException(String.valueOf(obj) + "." + String.valueOf(entry.getKey()) + " = " + String.valueOf(entry.getValue()), t);
        }
    }

    private static String trimQuote(String val) {
        if (val != null && val.startsWith("'") && val.endsWith("'")) {
            return val.substring(1, val.length() - 1);
        }
        return val;
    }

    public static Collection<String> findOptionsFor(Class<?> type) {
        Field[] fields;
        Method[] meths;
        TreeSet<String> names = new TreeSet<String>();
        for (Method meth : meths = type.getMethods()) {
            Class<?>[] params;
            if (!meth.getName().startsWith("set") || (params = meth.getParameterTypes()).length == 0 || params[0].isArray()) continue;
            names.add(StringUtil.capitalize(meth.getName().substring(3)));
        }
        for (Field field : fields = type.getFields()) {
            names.add(StringUtil.capitalize(field.getName()));
        }
        return names;
    }

    private static boolean matchOptionToMember(String key, Object[] match) throws Exception {
        if (StringUtil.isEmpty(key)) {
            return false;
        }
        String[] find = StringUtil.split(key, ".", 2);
        String base = StringUtil.capitalize(find[0]);
        String set = "set" + base;
        String get = "get" + base;
        Class<?> type = match[0].getClass();
        Method[] meths = type.getMethods();
        Method setMeth = null;
        Method getMeth = null;
        for (Method meth : meths) {
            if (meth.getName().equals(set)) {
                Class<?>[] params = meth.getParameterTypes();
                if (params.length == 0 || params[0].isArray()) continue;
                if (setMeth == null) {
                    setMeth = meth;
                    continue;
                }
                if (params.length < setMeth.getParameterTypes().length) {
                    setMeth = meth;
                    continue;
                }
                if (params.length != setMeth.getParameterTypes().length || params[0] != String.class) continue;
                setMeth = meth;
                continue;
            }
            if (!meth.getName().equals(get)) continue;
            getMeth = meth;
        }
        AccessibleObject setter = setMeth;
        AccessibleObject getter = getMeth;
        if (setter == null) {
            Field[] fields = type.getFields();
            String uncapBase = StringUtil.uncapitalize(find[0]);
            for (Field field : fields) {
                if (!field.getName().equals(base) && !field.getName().equals(uncapBase)) continue;
                setter = field;
                getter = field;
                break;
            }
        }
        if (setter == null && getter == null) {
            return false;
        }
        if (find.length > 1) {
            Object inner = null;
            if (getter != null) {
                inner = Options.invoke(match[0], getter, null);
            }
            if (inner == null && setter != null) {
                Class<?> innerType = Options.getType(setter)[0];
                try {
                    inner = AccessController.doPrivileged(J2DoPrivHelper.newInstanceAction(innerType));
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
                Options.invoke(match[0], setter, new Object[]{inner});
            }
            match[0] = inner;
            return Options.matchOptionToMember(find[1], match);
        }
        match[1] = setter;
        return match[1] != null;
    }

    private static Class<?>[] getType(Object member) {
        if (member instanceof Method) {
            return ((Method)member).getParameterTypes();
        }
        return new Class[]{((Field)member).getType()};
    }

    private static Object invoke(Object target, Object member, Object[] values) throws Exception {
        if (member instanceof Method) {
            return ((Method)member).invoke(target, values);
        }
        if (values == null || values.length == 0) {
            return ((Field)member).get(target);
        }
        ((Field)member).set(target, values[0]);
        return null;
    }

    private Object stringToObject(String str, Class<?> type) throws Exception {
        if (str == null || type == String.class) {
            return str;
        }
        if (type == Class.class) {
            return Class.forName(str, false, this.getClass().getClassLoader());
        }
        if ((type.isPrimitive() || Number.class.isAssignableFrom(type)) && str.length() > 2 && str.endsWith(".0")) {
            str = str.substring(0, str.length() - 2);
        }
        if (type.isPrimitive()) {
            for (Object[] primWrapper : _primWrappers) {
                if (type != primWrapper[0]) continue;
                return this.stringToObject(str, (Class)primWrapper[1]);
            }
        }
        if (type == Duration.class) {
            return Duration.ofMillis(Long.valueOf(str));
        }
        Exception err = null;
        try {
            Constructor<?> cons = type.getConstructor(String.class);
            if (type == Boolean.class && "t".equalsIgnoreCase(str)) {
                str = "true";
            }
            return cons.newInstance(str);
        }
        catch (Exception e) {
            err = new ParseException(_loc.get("conf-no-constructor", str, type), (Throwable)e);
            Class<?> subType = null;
            try {
                subType = Class.forName(str);
            }
            catch (Exception e2) {
                err = e2;
                throw new ParseException(_loc.get("conf-no-type", str, type), (Throwable)e2);
            }
            if (!type.isAssignableFrom(subType)) {
                throw err;
            }
            try {
                return AccessController.doPrivileged(J2DoPrivHelper.newInstanceAction(subType));
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
    }

    private Object getDefaultValue(Class<?> type) {
        for (Object[] primWrapper : _primWrappers) {
            if (primWrapper[0] != type) continue;
            return primWrapper[2];
        }
        return null;
    }

    public boolean getBooleanProperty(String key, String key2, boolean def) {
        String val = this.getProperty(key);
        if (val == null) {
            val = this.getProperty(key2);
        }
        if (val == null) {
            return def;
        }
        return "t".equalsIgnoreCase(val) || "true".equalsIgnoreCase(val);
    }

    public float getFloatProperty(String key, String key2, float def) {
        String val = this.getProperty(key);
        if (val == null) {
            val = this.getProperty(key2);
        }
        return val == null ? def : Float.parseFloat(val);
    }

    public double getDoubleProperty(String key, String key2, double def) {
        String val = this.getProperty(key);
        if (val == null) {
            val = this.getProperty(key2);
        }
        return val == null ? def : Double.parseDouble(val);
    }

    public long getLongProperty(String key, String key2, long def) {
        String val = this.getProperty(key);
        if (val == null) {
            val = this.getProperty(key2);
        }
        return val == null ? def : Long.parseLong(val);
    }

    public int getIntProperty(String key, String key2, int def) {
        String val = this.getProperty(key);
        if (val == null) {
            val = this.getProperty(key2);
        }
        return val == null ? def : Integer.parseInt(val);
    }

    public String getProperty(String key, String key2, String def) {
        String val = this.getProperty(key);
        return val == null ? this.getProperty(key2, def) : val;
    }

    public boolean removeBooleanProperty(String key, String key2, boolean def) {
        String val = this.removeProperty(key);
        if (val == null) {
            val = this.removeProperty(key2);
        } else {
            this.removeProperty(key2);
        }
        if (val == null) {
            return def;
        }
        return "t".equalsIgnoreCase(val) || "true".equalsIgnoreCase(val);
    }

    public float removeFloatProperty(String key, String key2, float def) {
        String val = this.removeProperty(key);
        if (val == null) {
            val = this.removeProperty(key2);
        } else {
            this.removeProperty(key2);
        }
        return val == null ? def : Float.parseFloat(val);
    }

    public double removeDoubleProperty(String key, String key2, double def) {
        String val = this.removeProperty(key);
        if (val == null) {
            val = this.removeProperty(key2);
        } else {
            this.removeProperty(key2);
        }
        return val == null ? def : Double.parseDouble(val);
    }

    public long removeLongProperty(String key, String key2, long def) {
        String val = this.removeProperty(key);
        if (val == null) {
            val = this.removeProperty(key2);
        } else {
            this.removeProperty(key2);
        }
        return val == null ? def : Long.parseLong(val);
    }

    public int removeIntProperty(String key, String key2, int def) {
        String val = this.removeProperty(key);
        if (val == null) {
            val = this.removeProperty(key2);
        } else {
            this.removeProperty(key2);
        }
        return val == null ? def : Integer.parseInt(val);
    }

    public String removeProperty(String key, String key2, String def) {
        String val = this.removeProperty(key);
        return val == null ? this.removeProperty(key2, def) : val;
    }

    private static class EmptyOptions
    extends Options {
        private static final long serialVersionUID = 1L;

        private EmptyOptions() {
        }

        @Override
        public Object setProperty(String key, String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }
    }
}

