/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicInputRenderer;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.UIOutput;
import jakarta.faces.component.html.HtmlInputFile;
import jakarta.faces.component.html.HtmlInputText;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class TextRenderer
extends HtmlBasicInputRenderer {
    private static final Attribute[] INPUTTEXT_ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.INPUTTEXT);
    private static final Attribute[] INPUTFILE_ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.INPUTFILE);
    private static final Attribute[] OUTPUT_ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.OUTPUTTEXT);
    private static final Map<String, String> RECOMMENDED_COMPONENTS_BY_DISCOMMENDED_TYPES = TextRenderer.mapRecommendedComponentsByDiscommendedTypes();

    private static Map<String, String> mapRecommendedComponentsByDiscommendedTypes() {
        HashMap<String, String> map = new HashMap<String, String>(9);
        map.put("hidden", "<h:inputHidden>");
        map.put("password", "<h:inputSecret>");
        map.put("checkbox", "<h:selectBooleanCheckbox> or <h:selectManyCheckbox>");
        map.put("radio", "<h:selectOneRadio>");
        map.put("file", "<h:inputFile>");
        map.put("submit", "<h:commandButton>");
        map.put("image", "<h:commandButton type=\"image\">");
        map.put("reset", "<h:commandButton type=\"reset\">");
        map.put("button", "<h:commandButton type=\"button\"> or <h:button>");
        return Collections.unmodifiableMap(map);
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
    }

    @Override
    protected void getEndTextToRender(FacesContext context, UIComponent component, String currentValue) throws IOException {
        boolean hasPassthroughAttributes;
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        boolean shouldWriteIdAttribute = false;
        boolean isOutput = false;
        String style = (String)component.getAttributes().get("style");
        String styleClass = (String)component.getAttributes().get("styleClass");
        String dir = (String)component.getAttributes().get("dir");
        String lang = (String)component.getAttributes().get("lang");
        String title = (String)component.getAttributes().get("title");
        Map<String, Object> passthroughAttributes = component.getPassThroughAttributes(false);
        boolean bl = hasPassthroughAttributes = null != passthroughAttributes && !passthroughAttributes.isEmpty();
        if (component instanceof UIInput) {
            writer.startElement("input", component);
            this.writeIdAttributeIfNecessary(context, writer, component);
            if (component instanceof HtmlInputFile) {
                writer.writeAttribute("type", "file", null);
                String accept = ((HtmlInputFile)component).getAccept();
                if (accept != null) {
                    writer.writeAttribute("accept", accept, "accept");
                }
            } else if (component instanceof HtmlInputText) {
                String recommendedComponent;
                String type = ((HtmlInputText)component).getType();
                if (context.isProjectStage(ProjectStage.Development) && (recommendedComponent = RECOMMENDED_COMPONENTS_BY_DISCOMMENDED_TYPES.get(type.trim().toLowerCase())) != null) {
                    String message = "<h:inputText type=\"" + type + "\"> is discommended, you should instead use " + recommendedComponent;
                    context.addMessage(component.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_WARN, message, message));
                }
                writer.writeAttribute("type", type, null);
            } else {
                writer.writeAttribute("type", "text", null);
            }
            writer.writeAttribute("name", component.getClientId(context), "clientId");
            if ("off".equals(component.getAttributes().get("autocomplete"))) {
                writer.writeAttribute("autocomplete", "off", "autocomplete");
            }
            if (currentValue != null) {
                writer.writeAttribute("value", currentValue, "value");
            }
            if (null != styleClass) {
                writer.writeAttribute("class", styleClass, "styleClass");
            }
            Attribute[] attributes = component instanceof HtmlInputFile ? INPUTFILE_ATTRIBUTES : INPUTTEXT_ATTRIBUTES;
            RenderKitUtils.renderPassThruAttributes(context, writer, component, attributes, TextRenderer.getNonOnChangeBehaviors(component));
            RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, component);
            RenderKitUtils.renderOnchange(context, component, false);
            writer.endElement("input");
        } else {
            isOutput = component instanceof UIOutput;
            if (isOutput) {
                if (styleClass != null || style != null || dir != null || lang != null || title != null || hasPassthroughAttributes || (shouldWriteIdAttribute = this.shouldWriteIdAttribute(component))) {
                    writer.startElement("span", component);
                    this.writeIdAttributeIfNecessary(context, writer, component);
                    if (null != styleClass) {
                        writer.writeAttribute("class", styleClass, "styleClass");
                    }
                    RenderKitUtils.renderPassThruAttributes(context, writer, component, OUTPUT_ATTRIBUTES);
                }
                if (currentValue != null) {
                    Object val = component.getAttributes().get("escape");
                    if (val != null && Boolean.valueOf(val.toString()).booleanValue()) {
                        writer.writeText(currentValue, component, "value");
                    } else {
                        writer.write(currentValue);
                    }
                }
            }
        }
        if (isOutput && (styleClass != null || style != null || dir != null || lang != null || title != null || hasPassthroughAttributes || shouldWriteIdAttribute)) {
            writer.endElement("span");
        }
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        boolean renderChildren = WebConfiguration.getInstance().isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.AllowTextChildren);
        if (!renderChildren) {
            return;
        }
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncodeChildren(component)) {
            return;
        }
        if (component.getChildCount() > 0) {
            for (UIComponent kid : component.getChildren()) {
                this.encodeRecursive(context, kid);
            }
        }
    }
}

