/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.HashMap;
import java.util.Map;
import org.apache.openejb.assembler.classic.DelegatePermissionCollection;

public class PolicyContext {
    private final PermissionCollection excludedPermissions = new DelegatePermissionCollection();
    private final PermissionCollection uncheckedPermissions = new DelegatePermissionCollection();
    private final Map<String, PermissionCollection> rolePermissions = new HashMap<String, PermissionCollection>();
    private final String contextId;

    public PolicyContext(String contextId) {
        this.contextId = contextId;
    }

    public PermissionCollection getExcludedPermissions() {
        return this.excludedPermissions;
    }

    public PermissionCollection getUncheckedPermissions() {
        return this.uncheckedPermissions;
    }

    public Map<String, PermissionCollection> getRolePermissions() {
        return this.rolePermissions;
    }

    public void addRole(String name, Permission permission) {
        this.rolePermissions.computeIfAbsent(name, k -> new DelegatePermissionCollection());
        this.rolePermissions.get(name).add(permission);
    }

    public String getContextID() {
        return this.contextId;
    }
}

