/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.request.AnyObjectCR;
import org.apache.syncope.common.lib.request.AnyObjectUR;
import org.apache.syncope.common.lib.search.SpecialAttr;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.rest.api.beans.AnyQuery;
import org.apache.syncope.common.rest.api.service.AnyObjectService;
import org.apache.syncope.core.logic.AbstractAnyLogic;
import org.apache.syncope.core.logic.AnyObjectLogic;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;
import org.apache.syncope.core.rest.cxf.service.AbstractAnyService;

public class AnyObjectServiceImpl
extends AbstractAnyService<AnyObjectTO, AnyObjectCR, AnyObjectUR>
implements AnyObjectService {
    protected final AnyObjectDAO anyObjectDAO;
    protected final AnyObjectLogic logic;

    public AnyObjectServiceImpl(SearchCondVisitor searchCondVisitor, AnyObjectDAO anyObjectDAO, AnyObjectLogic logic) {
        super(searchCondVisitor);
        this.anyObjectDAO = anyObjectDAO;
        this.logic = logic;
    }

    @Override
    protected AnyDAO<?> getAnyDAO() {
        return this.anyObjectDAO;
    }

    @Override
    protected AbstractAnyLogic<AnyObjectTO, AnyObjectCR, AnyObjectUR> getAnyLogic() {
        return this.logic;
    }

    @Override
    public AnyObjectTO read(String key) {
        return this.logic.read(key);
    }

    public AnyObjectTO read(String type, String name) {
        return this.logic.read(type, name);
    }

    @Override
    protected AnyObjectUR newUpdateReq(String key) {
        return (AnyObjectUR)new AnyObjectUR.Builder(key).build();
    }

    public Response create(AnyObjectCR createReq) {
        ProvisioningResult created = this.logic.create(createReq, this.isNullPriorityAsync());
        return this.createResponse(created);
    }

    public Response update(AnyObjectUR updateReq) {
        return this.doUpdate(updateReq);
    }

    @Override
    public PagedResult<AnyObjectTO> search(AnyQuery anyQuery) {
        if (StringUtils.isBlank((CharSequence)anyQuery.getFiql()) || -1 == anyQuery.getFiql().indexOf(SpecialAttr.TYPE.toString())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidSearchParameters);
            sce.getElements().add(String.valueOf(SpecialAttr.TYPE) + " is required in the FIQL string");
            throw sce;
        }
        return super.search(anyQuery);
    }
}

