/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.types;

import java.time.OffsetDateTime;
import java.util.stream.Stream;
import org.apache.commons.lang3.ClassUtils;

public enum AttrSchemaType {
    String(String.class),
    Long(Long.class),
    Double(Double.class),
    Boolean(Boolean.class),
    Date(OffsetDateTime.class),
    Enum(String.class),
    Dropdown(String.class),
    Binary(byte[].class),
    Encrypted(byte[].class);

    private final Class<?> type;

    private AttrSchemaType(Class<?> type) {
        this.type = type;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isConversionPatternNeeded() {
        return this == Date || this == Double || this == Long;
    }

    public boolean isStringClass() {
        return this.type == String.class;
    }

    public static AttrSchemaType getAttrSchemaTypeByClass(Class<?> type) {
        if (type == String.class) {
            return String;
        }
        if (Enum.class.isAssignableFrom(type)) {
            return Enum;
        }
        return Stream.of(AttrSchemaType.values()).filter(item -> type.isArray() ? ClassUtils.isAssignable(type.getComponentType(), item.getType().getComponentType(), (boolean)true) : ClassUtils.isAssignable((Class)type, item.getType(), (boolean)true)).findFirst().orElse(String);
    }
}

