/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.common.StateChangeFailedException;
import kafka.controller.ControlledShutdownPartitionLeaderElectionStrategy$;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.Election$;
import kafka.controller.ElectionResult;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflinePartitionLeaderElectionStrategy;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderElectionStrategy;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine;
import kafka.controller.PreferredReplicaPartitionLeaderElectionStrategy$;
import kafka.controller.ReassignPartitionLeaderElectionStrategy$;
import kafka.controller.ReplicaAssignment;
import kafka.controller.StateChangeLogger;
import kafka.server.KafkaConfig;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.GetDataResponse;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.zookeeper.KeeperException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001B\u000b\u0017\u0001mA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0005\tO\u0001\u0011\t\u0011)A\u0005Q!A1\u0006\u0001B\u0001B\u0003%A\u0006\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0011!1\u0004A!A!\u0002\u00139\u0004\"\u0002\u001e\u0001\t\u0003Y\u0004b\u0002\"\u0001\u0005\u0004%Ia\u0011\u0005\u0007\u0015\u0002\u0001\u000b\u0011\u0002#\t\u000f-\u0003!\u0019!C\u0005\u0019\"1\u0001\u000b\u0001Q\u0001\n5CQ!\u0015\u0001\u0005BICq!a\u0006\u0001\t\u0013\tI\u0002C\u0004\u0002 \u0001!I!!\t\t\u000f\u0005%\u0002\u0001\"\u0003\u0002,!9\u0011q\u0006\u0001\u0005\n\u0005E\u0002bBA\u001d\u0001\u0011%\u00111\b\u0005\b\u0003#\u0002A\u0011BA*\u0011\u001d\tY\u0007\u0001C\u0005\u0003[Bq!!\u001f\u0001\t\u0013\tY\bC\u0004\u0002z\u0001!I!a*\u0003/i[\u0007+\u0019:uSRLwN\\*uCR,W*Y2iS:,'BA\f\u0019\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u00023\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u001d!\tib$D\u0001\u0017\u0013\tybCA\u000bQCJ$\u0018\u000e^5p]N#\u0018\r^3NC\u000eD\u0017N\\3\u0002\r\r|gNZ5h!\t\u0011S%D\u0001$\u0015\t!\u0003$\u0001\u0004tKJ4XM]\u0005\u0003M\r\u00121bS1gW\u0006\u001cuN\u001c4jO\u0006\t2\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\u0011\u0005uI\u0013B\u0001\u0016\u0017\u0005E\u0019F/\u0019;f\u0007\"\fgnZ3M_\u001e<WM]\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$\bCA\u000f.\u0013\tqcCA\tD_:$(o\u001c7mKJ\u001cuN\u001c;fqR\f\u0001B_6DY&,g\u000e\u001e\t\u0003cQj\u0011A\r\u0006\u0003ga\t!A_6\n\u0005U\u0012$!D&bM.\f'l[\"mS\u0016tG/\u0001\u000fd_:$(o\u001c7mKJ\u0014%o\\6feJ+\u0017/^3ti\n\u000bGo\u00195\u0011\u0005uA\u0014BA\u001d\u0017\u0005q\u0019uN\u001c;s_2dWM\u001d\"s_.,'OU3rk\u0016\u001cHOQ1uG\"\fa\u0001P5oSRtDC\u0002\u001f>}}\u0002\u0015\t\u0005\u0002\u001e\u0001!)\u0001E\u0002a\u0001C!)qE\u0002a\u0001Q!)1F\u0002a\u0001Y!)qF\u0002a\u0001a!)aG\u0002a\u0001o\u0005I\u0012n\u001d'fC\u0012,'OU3d_Z,'/_*vaB|'\u000f^3e+\u0005!\u0005CA#I\u001b\u00051%\"A$\u0002\u000bM\u001c\u0017\r\\1\n\u0005%3%a\u0002\"p_2,\u0017M\\\u0001\u001bSNdU-\u00193feJ+7m\u001c<fef\u001cV\u000f\u001d9peR,G\rI\u0001\rG>tGO]8mY\u0016\u0014\u0018\nZ\u000b\u0002\u001bB\u0011QIT\u0005\u0003\u001f\u001a\u00131!\u00138u\u00035\u0019wN\u001c;s_2dWM]%eA\u0005\u0011\u0002.\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3t)\u0015\u0019\u0016P`A\u0004!\u0011!v+\u00173\u000e\u0003US!A\u0016$\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002Y+\n\u0019Q*\u00199\u0011\u0005i\u0013W\"A.\u000b\u0005qk\u0016AB2p[6|gN\u0003\u0002\u001a=*\u0011q\fY\u0001\u0007CB\f7\r[3\u000b\u0003\u0005\f1a\u001c:h\u0013\t\u00197L\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0015l\u0007o\u001d\b\u0003M.t!a\u001a6\u000e\u0003!T!!\u001b\u000e\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0015B\u00017G\u0003\u001d\u0001\u0018mY6bO\u0016L!A\\8\u0003\r\u0015KG\u000f[3s\u0015\tag\t\u0005\u0002fc&\u0011!o\u001c\u0002\n)\"\u0014xn^1cY\u0016\u0004\"\u0001^<\u000e\u0003UT!A\u001e\r\u0002\u0007\u0005\u0004\u0018.\u0003\u0002yk\naA*Z1eKJ\fe\u000eZ%te\")!p\u0003a\u0001w\u0006Q\u0001/\u0019:uSRLwN\\:\u0011\u0007Qc\u0018,\u0003\u0002~+\n\u00191+Z9\t\r}\\\u0001\u0019AA\u0001\u0003-!\u0018M]4fiN#\u0018\r^3\u0011\u0007u\t\u0019!C\u0002\u0002\u0006Y\u0011a\u0002U1si&$\u0018n\u001c8Ti\u0006$X\rC\u0004\u0002\n-\u0001\r!a\u0003\u0002EA\f'\u000f^5uS>tG*Z1eKJ,E.Z2uS>t7\u000b\u001e:bi\u0016<\u0017p\u00149u!\u0015)\u0015QBA\t\u0013\r\tyA\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007u\t\u0019\"C\u0002\u0002\u0016Y\u0011q\u0004U1si&$\u0018n\u001c8MK\u0006$WM]#mK\u000e$\u0018n\u001c8TiJ\fG/Z4z\u00039\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016$B!!\u0001\u0002\u001c!1\u0011Q\u0004\u0007A\u0002e\u000b\u0011\u0002]1si&$\u0018n\u001c8\u0002)\u0011|\u0007*\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3t)\u001d\u0019\u00161EA\u0013\u0003OAQA_\u0007A\u0002mDaa`\u0007A\u0002\u0005\u0005\u0001bBA\u0005\u001b\u0001\u0007\u00111B\u0001$S:LG/[1mSj,G*Z1eKJ\fe\u000eZ%te\u001a{'\u000fU1si&$\u0018n\u001c8t)\rY\u0018Q\u0006\u0005\u0006u:\u0001\ra_\u0001\u0019K2,7\r\u001e'fC\u0012,'OR8s!\u0006\u0014H/\u001b;j_:\u001cH#B*\u00024\u0005U\u0002\"\u0002>\u0010\u0001\u0004Y\bbBA\u001c\u001f\u0001\u0007\u0011\u0011C\u0001 a\u0006\u0014H/\u001b;j_:dU-\u00193fe\u0016cWm\u0019;j_:\u001cFO]1uK\u001eL\u0018A\u00073p\u000b2,7\r\u001e'fC\u0012,'OR8s!\u0006\u0014H/\u001b;j_:\u001cHCBA\u001f\u0003\u001b\ny\u0005\u0005\u0004F\u0003\u007f\t\u0019e_\u0005\u0004\u0003\u00032%A\u0002+va2,'\u0007E\u0003U/f\u000b)\u0005E\u0003f[\u0006\u001d3\u000fE\u0002f\u0003\u0013J1!a\u0013p\u0005%)\u0005pY3qi&|g\u000eC\u0003{!\u0001\u00071\u0010C\u0004\u00028A\u0001\r!!\u0005\u0002C\r|G\u000e\\3diVs7\r\\3b]2+\u0017\rZ3s\u000b2,7\r^5p]N#\u0018\r^3\u0015\r\u0005U\u0013qLA4!\u0011!F0a\u0016\u0011\u000f\u0015\u000bI&WA/\t&\u0019\u00111\f$\u0003\rQ+\b\u000f\\34!\u0011)\u0015QB:\t\u000f\u0005\u0005\u0014\u00031\u0001\u0002d\u0005iA.Z1eKJ\fe\u000eZ%teN\u0004B\u0001\u0016?\u0002fA)Q)a\u0010Zg\"1\u0011\u0011N\tA\u0002\u0011\u000bA\"\u00197m_^,fn\u00197fC:\fA\u0003\\8h\u0013:4\u0018\r\\5e)J\fgn]5uS>tGCBA8\u0003k\n9\bE\u0002F\u0003cJ1!a\u001dG\u0005\u0011)f.\u001b;\t\r\u0005u!\u00031\u0001Z\u0011\u0019y(\u00031\u0001\u0002\u0002\u0005!Bn\\4GC&dW\rZ*uCR,7\t[1oO\u0016$\"\"a\u001c\u0002~\u0005}\u00141QAC\u0011\u0019\tib\u0005a\u00013\"9\u0011\u0011Q\nA\u0002\u0005\u0005\u0011!C2veJ\u001cF/\u0019;f\u0011\u0019y8\u00031\u0001\u0002\u0002!9\u0011qQ\nA\u0002\u0005%\u0015\u0001B2pI\u0016\u0004B!a#\u0002\":!\u0011QRAN\u001d\u0011\ty)a&\u000f\t\u0005E\u0015Q\u0013\b\u0004O\u0006M\u0015\"A1\n\u0005}\u0003\u0017bAAM=\u0006I!p\\8lK\u0016\u0004XM]\u0005\u0005\u0003;\u000by*A\bLK\u0016\u0004XM]#yG\u0016\u0004H/[8o\u0015\r\tIJX\u0005\u0005\u0003G\u000b)K\u0001\u0003D_\u0012,'\u0002BAO\u0003?#\"\"a\u001c\u0002*\u0006-\u0016QVAX\u0011\u0019\ti\u0002\u0006a\u00013\"9\u0011\u0011\u0011\u000bA\u0002\u0005\u0005\u0001BB@\u0015\u0001\u0004\t\t\u0001\u0003\u0004\u00022R\u0001\r\u0001]\u0001\u0002i\u0002")
public class ZkPartitionStateMachine
extends PartitionStateMachine {
    private final KafkaConfig config;
    private final StateChangeLogger stateChangeLogger;
    private final ControllerContext controllerContext;
    private final KafkaZkClient zkClient;
    private final ControllerBrokerRequestBatch controllerBrokerRequestBatch;
    private final boolean isLeaderRecoverySupported;
    private final int controllerId;

    private boolean isLeaderRecoverySupported() {
        return this.isLeaderRecoverySupported;
    }

    private int controllerId() {
        return this.controllerId;
    }

    @Override
    public Map<TopicPartition, Either<Throwable, LeaderAndIsr>> handleStateChanges(Seq<TopicPartition> partitions, PartitionState targetState, Option<PartitionLeaderElectionStrategy> partitionLeaderElectionStrategyOpt) {
        if (partitions.nonEmpty()) {
            try {
                this.controllerBrokerRequestBatch.newBatch();
                Map<TopicPartition, Either<Throwable, LeaderAndIsr>> result = this.doHandleStateChanges(partitions, targetState, partitionLeaderElectionStrategyOpt);
                this.controllerBrokerRequestBatch.sendRequestsToBrokers(this.controllerContext.epoch());
                return result;
            }
            catch (ControllerMovedException e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(72).append("Controller moved to another broker when moving some partitions to ").append(targetState).append(" state").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                throw e;
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Error while moving some partitions to ").append(targetState).append(" state").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return partitions.iterator().map((Function1 & Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$1), (Object)new Left((Object)e))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
        }
        return (Map)scala.collection.Map$.MODULE$.empty();
    }

    private PartitionState partitionState(TopicPartition partition) {
        return this.controllerContext.partitionState(partition);
    }

    /*
     * WARNING - void declaration
     */
    private Map<TopicPartition, Either<Throwable, LeaderAndIsr>> doHandleStateChanges(Seq<TopicPartition> partitions, PartitionState targetState, Option<PartitionLeaderElectionStrategy> partitionLeaderElectionStrategyOpt) {
        void var7_7;
        void var8_8;
        StateChangeLogger stateChangeLog = this.stateChangeLogger.withControllerEpoch(this.controllerContext.epoch());
        boolean traceEnabled = stateChangeLog.isTraceEnabled();
        partitions.foreach((Function1 & Serializable)partition -> {
            this.controllerContext.putPartitionStateIfNotExists(partition, NonExistentPartition$.MODULE$);
            return BoxedUnit.UNIT;
        });
        Tuple2<Seq<TopicPartition>, Seq<TopicPartition>> tuple2 = this.controllerContext.checkValidPartitionStateChange(partitions, targetState);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq validPartitions = (Seq)tuple2._1();
        Seq invalidPartitions = (Seq)tuple2._2();
        var8_8.foreach((Function1 & Serializable)partition -> {
            this.logInvalidTransition(partition, targetState);
            return BoxedUnit.UNIT;
        });
        if (NewPartition$.MODULE$.equals(targetState)) {
            var7_7.foreach((Function1 & Serializable)partition -> {
                ZkPartitionStateMachine.$anonfun$doHandleStateChanges$3(this, stateChangeLog, targetState, partition);
                return BoxedUnit.UNIT;
            });
            return (Map)scala.collection.Map$.MODULE$.empty();
        }
        if (OnlinePartition$.MODULE$.equals(targetState)) {
            Seq uninitializedPartitions = (Seq)var7_7.filter((Function1 & Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$doHandleStateChanges$5(this, partition)));
            Seq partitionsToElectLeader = (Seq)var7_7.filter((Function1 & Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$doHandleStateChanges$6(this, partition)));
            if (uninitializedPartitions.nonEmpty()) {
                this.initializeLeaderAndIsrForPartitions((Seq<TopicPartition>)uninitializedPartitions).foreach((Function1 & Serializable)partition -> {
                    ZkPartitionStateMachine.$anonfun$doHandleStateChanges$7(this, stateChangeLog, targetState, partition);
                    return BoxedUnit.UNIT;
                });
            }
            if (partitionsToElectLeader.nonEmpty()) {
                Map<TopicPartition, Either<Throwable, LeaderAndIsr>> electionResults = this.electLeaderForPartitions((Seq<TopicPartition>)partitionsToElectLeader, (PartitionLeaderElectionStrategy)partitionLeaderElectionStrategyOpt.getOrElse((Function0 & Serializable)() -> {
                    throw new IllegalArgumentException("Election strategy is a required field when the target state is OnlinePartition");
                }));
                electionResults.foreach((Function1 & Serializable)x0$1 -> {
                    ZkPartitionStateMachine.$anonfun$doHandleStateChanges$10(this, stateChangeLog, targetState, x0$1);
                    return BoxedUnit.UNIT;
                });
                return electionResults;
            }
            return (Map)scala.collection.Map$.MODULE$.empty();
        }
        if (OfflinePartition$.MODULE$.equals(targetState) ? true : NonExistentPartition$.MODULE$.equals(targetState)) {
            var7_7.foreach((Function1 & Serializable)partition -> {
                ZkPartitionStateMachine.$anonfun$doHandleStateChanges$12(this, traceEnabled, stateChangeLog, targetState, partition);
                return BoxedUnit.UNIT;
            });
            return (Map)scala.collection.Map$.MODULE$.empty();
        }
        throw new MatchError((Object)targetState);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<TopicPartition> initializeLeaderAndIsrForPartitions(Seq<TopicPartition> partitions) {
        Seq seq;
        void var5_5;
        void var4_4;
        Buffer successfulInitializations = (Buffer)Buffer$.MODULE$.empty();
        Tuple2 tuple2 = ((Seq)((Seq)partitions.map((Function1 & Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), $this.controllerContext.partitionReplicaAssignment((TopicPartition)partition)))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition partition = (TopicPartition)x0$1._1();
                Seq liveReplicasForPartition = (Seq)((Seq)x0$1._2()).filter((Function1)(JFunction1.mcZI.sp & Serializable)replica -> $this.controllerContext.isReplicaOnline(replica, partition));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)liveReplicasForPartition);
            }
            throw new MatchError(null);
        })).partition((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$initializeLeaderAndIsrForPartitions$4(x0$2)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq partitionsWithoutLiveReplicas = (Seq)tuple2._1();
        Seq partitionsWithLiveReplicas = (Seq)tuple2._2();
        var4_4.foreach((Function1 & Serializable)x0$3 -> {
            ZkPartitionStateMachine.$anonfun$initializeLeaderAndIsrForPartitions$5(this, x0$3);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Map leaderIsrAndControllerEpochs = ((IterableOnceOps)var5_5.map((Function1 & Serializable)x0$4 -> {
            if (x0$4 != null) {
                TopicPartition partition = (TopicPartition)x0$4._1();
                Seq liveReplicas = (Seq)x0$4._2();
                LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)liveReplicas.head()), (List<Object>)liveReplicas.toList());
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, $this.controllerContext.epoch());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)leaderIsrAndControllerEpoch);
            }
            throw new MatchError(null);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        try {
            seq = this.zkClient.createTopicPartitionStatesRaw((Map<TopicPartition, LeaderIsrAndControllerEpoch>)leaderIsrAndControllerEpochs, this.controllerContext.epochZkVersion());
        }
        catch (ControllerMovedException e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Controller moved to another broker when trying to create the topic partition state znode", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            throw e;
        }
        catch (Exception e) {
            var5_5.foreach((Function1 & Serializable)x0$5 -> {
                ZkPartitionStateMachine.$anonfun$initializeLeaderAndIsrForPartitions$9(this, e, x0$5);
                return BoxedUnit.UNIT;
            });
            seq = (Seq)Seq$.MODULE$.empty();
        }
        seq.foreach((Function1 & Serializable)createResponse -> {
            KeeperException.Code code = createResponse.resultCode();
            TopicPartition partition = (TopicPartition)createResponse.ctx().get();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochs.apply((Object)partition);
            KeeperException.Code code2 = code;
            KeeperException.Code code3 = KeeperException.Code.OK;
            if (!(code2 != null ? !code2.equals(code3) : code3 != null)) {
                $this.controllerContext.putPartitionLeadershipInfo(partition, leaderIsrAndControllerEpoch);
                $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)leaderIsrAndControllerEpoch.leaderAndIsr().isr(), partition, leaderIsrAndControllerEpoch, $this.controllerContext.partitionFullReplicaAssignment(partition), true);
                return successfulInitializations.$plus$eq((Object)partition);
            }
            this.logFailedStateChange(partition, (PartitionState)NewPartition$.MODULE$, (PartitionState)OnlinePartition$.MODULE$, code);
            return BoxedUnit.UNIT;
        });
        return successfulInitializations;
    }

    /*
     * WARNING - void declaration
     */
    private Map<TopicPartition, Either<Throwable, LeaderAndIsr>> electLeaderForPartitions(Seq<TopicPartition> partitions, PartitionLeaderElectionStrategy partitionLeaderElectionStrategy) {
        Seq<TopicPartition> remaining = partitions;
        scala.collection.mutable.Map finishedElections = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        while (remaining.nonEmpty()) {
            void var6_6;
            void var7_7;
            Tuple2<Map<TopicPartition, Either<Exception, LeaderAndIsr>>, Seq<TopicPartition>> tuple2 = this.doElectLeaderForPartitions(remaining, partitionLeaderElectionStrategy);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Map finished = (Map)tuple2._1();
            Seq updatesToRetry = (Seq)tuple2._2();
            remaining = var7_7;
            var6_6.foreach((Function1 & Serializable)x0$1 -> {
                ZkPartitionStateMachine.$anonfun$electLeaderForPartitions$1(this, x0$1);
                return BoxedUnit.UNIT;
            });
            finishedElections.$plus$plus$eq((IterableOnce)var6_6);
            if (!remaining.nonEmpty() || !this.logger().underlying().isInfoEnabled()) continue;
            this.logger().underlying().info("Retrying leader election with strategy {} for partitions {}", new Object[]{partitionLeaderElectionStrategy, remaining});
        }
        return finishedElections.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<Map<TopicPartition, Either<Exception, LeaderAndIsr>>, Seq<TopicPartition>> doElectLeaderForPartitions(Seq<TopicPartition> partitions, PartitionLeaderElectionStrategy partitionLeaderElectionStrategy) {
        void var16_16;
        void var15_15;
        void var11_11;
        void var10_10;
        Tuple2 tuple2;
        Seq<GetDataResponse> seq;
        try {
            seq = this.zkClient.getTopicPartitionStatesRaw(partitions);
        }
        catch (Exception e) {
            return new Tuple2((Object)partitions.iterator().map((Function1 & Serializable)x$5 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$5), (Object)new Left((Object)e))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)Seq$.MODULE$.empty());
        }
        Seq<GetDataResponse> getDataResponses = seq;
        scala.collection.mutable.Map failedElections = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Buffer validLeaderAndIsrs = (Buffer)Buffer$.MODULE$.empty();
        getDataResponses.foreach((Function1 & Serializable)getDataResponse -> {
            TopicPartition partition = (TopicPartition)getDataResponse.ctx().get();
            PartitionState currState = this.partitionState(partition);
            KeeperException.Code code = getDataResponse.resultCode();
            KeeperException.Code code2 = KeeperException.Code.OK;
            if (!(code != null ? !code.equals(code2) : code2 != null)) {
                Option<LeaderIsrAndControllerEpoch> option = TopicPartitionStateZNode$.MODULE$.decode(getDataResponse.data(), getDataResponse.stat());
                if (option instanceof Some) {
                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)((Some)option).value();
                    if (leaderIsrAndControllerEpoch.controllerEpoch() > $this.controllerContext.epoch()) {
                        String failMsg = new StringBuilder(234).append("Aborted leader election for partition ").append(partition).append(" since the LeaderAndIsr path was ").append("already written by another controller. This probably means that the current controller ").append(this.controllerId()).append(" went through ").append("a soft failure and another controller was elected with epoch ").append(leaderIsrAndControllerEpoch.controllerEpoch()).append(".").toString();
                        return failedElections.put((Object)partition, (Object)new Left((Object)new StateChangeFailedException(failMsg)));
                    }
                    return validLeaderAndIsrs.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)leaderIsrAndControllerEpoch.leaderAndIsr()));
                }
                if (None$.MODULE$.equals(option)) {
                    StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(63).append("LeaderAndIsr information doesn't exist for partition ").append(partition).append(" in ").append(currState).append(" state").toString());
                    return failedElections.put((Object)partition, (Object)new Left((Object)exception));
                }
                throw new MatchError(option);
            }
            KeeperException.Code code3 = getDataResponse.resultCode();
            KeeperException.Code code4 = KeeperException.Code.NONODE;
            if (!(code3 != null ? !code3.equals(code4) : code4 != null)) {
                StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(63).append("LeaderAndIsr information doesn't exist for partition ").append(partition).append(" in ").append(currState).append(" state").toString());
                return failedElections.put((Object)partition, (Object)new Left((Object)exception));
            }
            return failedElections.put((Object)partition, (Object)new Left(getDataResponse.resultException().get()));
        });
        if (validLeaderAndIsrs.isEmpty()) {
            return new Tuple2((Object)failedElections.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)Seq$.MODULE$.empty());
        }
        if (partitionLeaderElectionStrategy instanceof OfflinePartitionLeaderElectionStrategy) {
            boolean allowUnclean = ((OfflinePartitionLeaderElectionStrategy)partitionLeaderElectionStrategy).allowUnclean();
            Seq<Tuple3<TopicPartition, Option<LeaderAndIsr>, Object>> partitionsWithUncleanLeaderElectionState = this.collectUncleanLeaderElectionState((Seq<Tuple2<TopicPartition, LeaderAndIsr>>)validLeaderAndIsrs, allowUnclean);
            tuple2 = Election$.MODULE$.leaderForOffline(this.controllerContext, this.isLeaderRecoverySupported(), partitionsWithUncleanLeaderElectionState).partition((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$doElectLeaderForPartitions$3(x$6)));
        } else if (ReassignPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy)) {
            tuple2 = Election$.MODULE$.leaderForReassign(this.controllerContext, (Seq<Tuple2<TopicPartition, LeaderAndIsr>>)validLeaderAndIsrs).partition((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$doElectLeaderForPartitions$4(x$7)));
        } else if (PreferredReplicaPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy)) {
            tuple2 = Election$.MODULE$.leaderForPreferredReplica(this.controllerContext, (Seq<Tuple2<TopicPartition, LeaderAndIsr>>)validLeaderAndIsrs).partition((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$doElectLeaderForPartitions$5(x$8)));
        } else if (ControlledShutdownPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy)) {
            tuple2 = Election$.MODULE$.leaderForControlledShutdown(this.controllerContext, (Seq<Tuple2<TopicPartition, LeaderAndIsr>>)validLeaderAndIsrs).partition((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$doElectLeaderForPartitions$6(x$9)));
        } else {
            throw new MatchError((Object)partitionLeaderElectionStrategy);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Seq partitionsWithoutLeaders = (Seq)tuple22._1();
        Seq partitionsWithLeaders = (Seq)tuple22._2();
        var10_10.foreach((Function1 & Serializable)electionResult -> {
            TopicPartition partition = electionResult.topicPartition();
            String failMsg = new StringBuilder(53).append("Failed to elect leader for partition ").append(partition).append(" under strategy ").append(partitionLeaderElectionStrategy).toString();
            return failedElections.put((Object)partition, (Object)new Left((Object)new StateChangeFailedException(failMsg)));
        });
        scala.collection.immutable.Map recipientsPerPartition = ((IterableOnceOps)var11_11.map((Function1 & Serializable)result -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)result.topicPartition()), result.liveReplicas()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map adjustedLeaderAndIsrs = ((IterableOnceOps)var11_11.map((Function1 & Serializable)result -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)result.topicPartition()), result.leaderAndIsr().get()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        KafkaZkClient.UpdateLeaderAndIsrResult updateLeaderAndIsrResult = this.zkClient.updateLeaderAndIsr((Map<TopicPartition, LeaderAndIsr>)adjustedLeaderAndIsrs, this.controllerContext.epoch(), this.controllerContext.epochZkVersion());
        if (updateLeaderAndIsrResult == null) {
            throw new MatchError(null);
        }
        Map<TopicPartition, Either<Exception, LeaderAndIsr>> finishedUpdates = updateLeaderAndIsrResult.finishedPartitions();
        Seq<TopicPartition> updatesToRetry = updateLeaderAndIsrResult.partitionsToRetry();
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(partition, result) -> {
            result.foreach((Function1 & Serializable)leaderAndIsr -> {
                ZkPartitionStateMachine.$anonfun$doElectLeaderForPartitions$11($this, partition, recipientsPerPartition$1, leaderAndIsr);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        };
        var15_15.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
        Object var17_17 = null;
        if (this.isDebugEnabled()) {
            var16_16.foreach((Function1 & Serializable)partition -> {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(130).append("Controller failed to elect leader for partition ").append(partition).append(". ").append("Attempted to write state ").append(adjustedLeaderAndIsrs$1.apply((Object)partition)).append(", but failed with bad ZK version. This will be retried.").toString());
                return BoxedUnit.UNIT;
            });
        }
        return new Tuple2((Object)var15_15.$plus$plus((IterableOnce)failedElections), (Object)var16_16);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Tuple3<TopicPartition, Option<LeaderAndIsr>, Object>> collectUncleanLeaderElectionState(Seq<Tuple2<TopicPartition, LeaderAndIsr>> leaderAndIsrs, boolean allowUnclean) {
        void var5_5;
        Seq seq;
        void var4_4;
        Tuple2 tuple2 = leaderAndIsrs.partition((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$collectUncleanLeaderElectionState$1(this, x0$1)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq partitionsWithNoLiveInSyncReplicas = (Seq)tuple2._1();
        Seq partitionsWithLiveInSyncReplicas = (Seq)tuple2._2();
        if (allowUnclean) {
            seq = (Seq)var4_4.map((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    TopicPartition partition = (TopicPartition)x0$2._1();
                    LeaderAndIsr leaderAndIsr = (LeaderAndIsr)x0$2._2();
                    return new Tuple3((Object)partition, (Object)Option$.MODULE$.apply((Object)leaderAndIsr), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                }
                throw new MatchError(null);
            });
        } else {
            void var7_7;
            void var8_8;
            Tuple2<Map<String, LogConfig>, Map<String, Exception>> tuple22 = this.zkClient.getLogConfigs((Set<String>)var4_4.iterator().map((Function1 & Serializable)x0$3 -> {
                if (x0$3 != null) {
                    return ((TopicPartition)x0$3._1()).topic();
                }
                throw new MatchError(null);
            }).toSet(), this.config.originals());
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            Map logConfigs = (Map)tuple22._1();
            Map failed = (Map)tuple22._2();
            seq = (Seq)var4_4.map(arg_0 -> ZkPartitionStateMachine.$anonfun$collectUncleanLeaderElectionState$5(this, (Map)var8_8, (Map)var7_7, arg_0));
        }
        return (Seq)seq.$plus$plus((IterableOnce)var5_5.map((Function1 & Serializable)x0$5 -> {
            if (x0$5 != null) {
                TopicPartition partition = (TopicPartition)x0$5._1();
                LeaderAndIsr leaderAndIsr = (LeaderAndIsr)x0$5._2();
                return new Tuple3((Object)partition, (Object)Option$.MODULE$.apply((Object)leaderAndIsr), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            throw new MatchError(null);
        }));
    }

    private void logInvalidTransition(TopicPartition partition, PartitionState targetState) {
        PartitionState currState = this.partitionState(partition);
        IllegalStateException e = new IllegalStateException(new StringBuilder(87).append("Partition ").append(partition).append(" should be in one of ").append(targetState.validPreviousStates().mkString(",")).append(" states before moving to ").append(targetState).append(" state. Instead it is in ").append(currState).append(" state").toString());
        this.logFailedStateChange(partition, currState, targetState, e);
    }

    private void logFailedStateChange(TopicPartition partition, PartitionState currState, PartitionState targetState, KeeperException.Code code) {
        this.logFailedStateChange(partition, currState, targetState, (Throwable)KeeperException.create((KeeperException.Code)code));
    }

    private void logFailedStateChange(TopicPartition partition, PartitionState currState, PartitionState targetState, Throwable t) {
        this.stateChangeLogger.withControllerEpoch(this.controllerContext.epoch()).error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(66).append("Controller ").append(this.controllerId()).append(" epoch ").append($this.controllerContext.epoch()).append(" failed to change state for partition ").append(partition).append(" ").append("from ").append(currState).append(" to ").append(targetState).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$3(ZkPartitionStateMachine $this, StateChangeLogger stateChangeLog$1, PartitionState targetState$2, TopicPartition partition) {
        stateChangeLog$1.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Changed partition ").append(partition).append(" state from ").append($this.partitionState(partition)).append(" to ").append(targetState$2).append(" with ").append("assigned replicas ").append($this.controllerContext.partitionReplicaAssignment(partition).mkString(",")).toString());
        $this.controllerContext.putPartitionState(partition, NewPartition$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$doHandleStateChanges$5(ZkPartitionStateMachine $this, TopicPartition partition) {
        PartitionState partitionState = $this.partitionState(partition);
        NewPartition$ newPartition$ = NewPartition$.MODULE$;
        return partitionState != null && partitionState.equals(newPartition$);
    }

    public static final /* synthetic */ boolean $anonfun$doHandleStateChanges$6(ZkPartitionStateMachine $this, TopicPartition partition) {
        block3: {
            block2: {
                PartitionState partitionState = $this.partitionState(partition);
                OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
                if (partitionState != null && partitionState.equals(offlinePartition$)) break block2;
                PartitionState partitionState2 = $this.partitionState(partition);
                OnlinePartition$ onlinePartition$ = OnlinePartition$.MODULE$;
                if (partitionState2 == null || !partitionState2.equals(onlinePartition$)) break block3;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$7(ZkPartitionStateMachine $this, StateChangeLogger stateChangeLog$1, PartitionState targetState$2, TopicPartition partition) {
        stateChangeLog$1.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Changed partition ").append(partition).append(" from ").append($this.partitionState(partition)).append(" to ").append(targetState$2).append(" with state ").append(((LeaderIsrAndControllerEpoch)$this.controllerContext.partitionLeadershipInfo(partition).get()).leaderAndIsr()).toString());
        $this.controllerContext.putPartitionState(partition, OnlinePartition$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$10(ZkPartitionStateMachine $this, StateChangeLogger stateChangeLog$1, PartitionState targetState$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition partition = (TopicPartition)x0$1._1();
            Either either = (Either)x0$1._2();
            if (either instanceof Right) {
                LeaderAndIsr leaderAndIsr = (LeaderAndIsr)((Right)either).value();
                stateChangeLog$1.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Changed partition ").append(partition).append(" from ").append($this.partitionState(partition)).append(" to ").append(targetState$2).append(" with state ").append(leaderAndIsr).toString());
                $this.controllerContext.putPartitionState(partition, OnlinePartition$.MODULE$);
                return;
            }
        }
        if (x0$1 != null && (Either)x0$1._2() instanceof Left) {
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$12(ZkPartitionStateMachine $this, boolean traceEnabled$1, StateChangeLogger stateChangeLog$1, PartitionState targetState$2, TopicPartition partition) {
        if (traceEnabled$1) {
            stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Changed partition ").append(partition).append(" state from ").append($this.partitionState(partition)).append(" to ").append(targetState$2).toString());
        }
        $this.controllerContext.putPartitionState(partition, targetState$2);
    }

    public static final /* synthetic */ boolean $anonfun$initializeLeaderAndIsrForPartitions$4(Tuple2 x0$2) {
        if (x0$2 != null) {
            return ((Seq)x0$2._2()).isEmpty();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$initializeLeaderAndIsrForPartitions$5(ZkPartitionStateMachine $this, Tuple2 x0$3) {
        if (x0$3 != null) {
            TopicPartition partition = (TopicPartition)x0$3._1();
            String failMsg = new StringBuilder(167).append("Controller ").append($this.controllerId()).append(" epoch ").append($this.controllerContext.epoch()).append(" encountered error during state change of ").append("partition ").append(partition).append(" from New to Online, assigned replicas are ").append("[").append($this.controllerContext.partitionReplicaAssignment(partition).mkString(",")).append("], live brokers are [").append($this.controllerContext.liveBrokerIds()).append("]. No assigned ").append("replica is alive.").toString();
            $this.logFailedStateChange(partition, (PartitionState)NewPartition$.MODULE$, (PartitionState)OnlinePartition$.MODULE$, new StateChangeFailedException(failMsg));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$initializeLeaderAndIsrForPartitions$9(ZkPartitionStateMachine $this, Exception e$4, Tuple2 x0$5) {
        if (x0$5 != null) {
            TopicPartition partition = (TopicPartition)x0$5._1();
            $this.logFailedStateChange(partition, $this.partitionState(partition), (PartitionState)NewPartition$.MODULE$, e$4);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$electLeaderForPartitions$1(ZkPartitionStateMachine $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition partition = (TopicPartition)x0$1._1();
            Either either = (Either)x0$1._2();
            if (either instanceof Left) {
                Exception e = (Exception)((Left)either).value();
                $this.logFailedStateChange(partition, $this.partitionState(partition), (PartitionState)OnlinePartition$.MODULE$, e);
                return;
            }
        }
        if (x0$1 != null && (Either)x0$1._2() instanceof Right) {
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$3(ElectionResult x$6) {
        return x$6.leaderAndIsr().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$4(ElectionResult x$7) {
        return x$7.leaderAndIsr().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$5(ElectionResult x$8) {
        return x$8.leaderAndIsr().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$6(ElectionResult x$9) {
        return x$9.leaderAndIsr().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$doElectLeaderForPartitions$11(ZkPartitionStateMachine $this, TopicPartition partition$6, scala.collection.immutable.Map recipientsPerPartition$1, LeaderAndIsr leaderAndIsr) {
        ReplicaAssignment replicaAssignment = $this.controllerContext.partitionFullReplicaAssignment(partition$6);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, $this.controllerContext.epoch());
        $this.controllerContext.putPartitionLeadershipInfo(partition$6, leaderIsrAndControllerEpoch);
        $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)((Seq)recipientsPerPartition$1.apply((Object)partition$6)), partition$6, leaderIsrAndControllerEpoch, replicaAssignment, false);
    }

    public static final /* synthetic */ boolean $anonfun$collectUncleanLeaderElectionState$1(ZkPartitionStateMachine $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition partition = (TopicPartition)x0$1._1();
            return ((LeaderAndIsr)x0$1._2()).isr().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$12 -> $this.controllerContext.isReplicaOnline(x$12, partition)).isEmpty();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Tuple3 $anonfun$collectUncleanLeaderElectionState$5(ZkPartitionStateMachine $this, Map failed$1, Map logConfigs$1, Tuple2 x0$4) {
        if (x0$4 != null) {
            TopicPartition partition = (TopicPartition)x0$4._1();
            LeaderAndIsr leaderAndIsr = (LeaderAndIsr)x0$4._2();
            if (failed$1.contains((Object)partition.topic())) {
                $this.logFailedStateChange(partition, $this.partitionState(partition), (PartitionState)OnlinePartition$.MODULE$, (Throwable)failed$1.apply((Object)partition.topic()));
                return new Tuple3((Object)partition, (Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            return new Tuple3((Object)partition, (Object)Option$.MODULE$.apply((Object)leaderAndIsr), (Object)BoxesRunTime.boxToBoolean((boolean)((LogConfig)logConfigs$1.apply((Object)partition.topic())).uncleanLeaderElectionEnable));
        }
        throw new MatchError(null);
    }

    public ZkPartitionStateMachine(KafkaConfig config, StateChangeLogger stateChangeLogger, ControllerContext controllerContext, KafkaZkClient zkClient, ControllerBrokerRequestBatch controllerBrokerRequestBatch) {
        this.config = config;
        this.stateChangeLogger = stateChangeLogger;
        this.controllerContext = controllerContext;
        this.zkClient = zkClient;
        this.controllerBrokerRequestBatch = controllerBrokerRequestBatch;
        super(controllerContext);
        this.isLeaderRecoverySupported = config.interBrokerProtocolVersion().isAtLeast(MetadataVersion.IBP_3_2_IV0);
        this.controllerId = config.brokerId();
        this.logIdent_$eq(new StringBuilder(38).append("[PartitionStateMachine controllerId=").append(this.controllerId()).append("] ").toString());
    }
}

