/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.ScriptTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.scripting.ScriptEngineRequest;
import org.flowable.common.engine.impl.scripting.ScriptingEngines;
import org.flowable.common.engine.impl.variable.MapDelegateVariableContainer;
import org.flowable.engine.delegate.BpmnError;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.ErrorPropagation;
import org.flowable.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.BpmnOverrideContext;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.IOParameterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptTaskActivityBehavior
extends TaskActivityBehavior {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptTaskActivityBehavior.class);
    protected String scriptTaskId;
    protected String script;
    protected String language;
    protected String resultVariable;
    protected String skipExpression;
    protected boolean storeScriptVariables;

    public ScriptTaskActivityBehavior(String script, String language, String resultVariable) {
        this.script = script;
        this.language = language;
        this.resultVariable = resultVariable;
    }

    public ScriptTaskActivityBehavior(String scriptTaskId, String script, String language, String resultVariable, String skipExpression, boolean storeScriptVariables) {
        this(script, language, resultVariable);
        this.scriptTaskId = scriptTaskId;
        this.skipExpression = skipExpression;
        this.storeScriptVariables = storeScriptVariables;
    }

    @Override
    public void execute(DelegateExecution execution) {
        String overrideScript;
        ObjectNode taskElementProperties;
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        boolean isSkipExpressionEnabled = SkipExpressionUtil.isSkipExpressionEnabled(this.skipExpression, this.scriptTaskId, execution, commandContext);
        if (isSkipExpressionEnabled && SkipExpressionUtil.shouldSkipFlowElement(this.skipExpression, this.scriptTaskId, execution, commandContext)) {
            this.leave(execution);
            return;
        }
        if (CommandContextUtil.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache() && (taskElementProperties = BpmnOverrideContext.getBpmnOverrideElementProperties(this.scriptTaskId, execution.getProcessDefinitionId())) != null && taskElementProperties.has("scriptTaskScript") && StringUtils.isNotEmpty((CharSequence)(overrideScript = taskElementProperties.get("scriptTaskScript").asText())) && !overrideScript.equals(this.script)) {
            this.script = overrideScript;
        }
        this.safelyExecuteScript(execution);
    }

    protected void safelyExecuteScript(DelegateExecution execution) {
        boolean noErrors = true;
        try {
            this.executeScript(execution);
        }
        catch (FlowableException e) {
            LOGGER.warn("Exception while executing {} : {}", (Object)execution, (Object)e.getMessage());
            noErrors = false;
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof BpmnError) {
                ErrorPropagation.propagateError((BpmnError)((Object)rootCause), execution);
            }
            if (rootCause instanceof FlowableException) {
                throw (FlowableException)rootCause;
            }
            throw e;
        }
        if (noErrors) {
            this.leave(execution);
        }
    }

    protected void executeScript(DelegateExecution execution) {
        ScriptEngineRequest request;
        Object result;
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        ScriptingEngines scriptingEngines = processEngineConfiguration.getScriptingEngines();
        ScriptEngineRequest.Builder builder = ScriptEngineRequest.builder().script(this.script).traceEnhancer(trace -> trace.addTraceTag("type", "scriptTask")).language(this.language).scopeContainer((VariableContainer)execution);
        builder = this.storeScriptVariables ? builder.storeScriptVariables() : builder;
        FlowElement flowElement = execution.getCurrentFlowElement();
        if (flowElement instanceof ScriptTask) {
            ScriptTask scriptTask = (ScriptTask)flowElement;
            List inParameters = scriptTask.getInParameters();
            if (inParameters != null && !inParameters.isEmpty()) {
                MapDelegateVariableContainer inputVariableContainer = new MapDelegateVariableContainer();
                IOParameterUtil.processInParameters(inParameters, (VariableContainer)execution, (VariableContainer)inputVariableContainer, processEngineConfiguration.getExpressionManager());
                builder.inputVariableContainer((VariableContainer)inputVariableContainer);
            } else if (scriptTask.isDoNotIncludeVariables()) {
                builder.inputVariableContainer(VariableContainer.empty());
            }
        }
        if (null != (result = scriptingEngines.evaluate(request = builder.build()).getResult()) && "juel".equalsIgnoreCase(this.language) && result instanceof String && this.script.equals(result.toString())) {
            throw new FlowableException("Error evaluating juel script: \"" + this.script + "\" for " + String.valueOf(execution));
        }
        if (this.resultVariable != null) {
            execution.setVariable(this.resultVariable, result);
        }
    }
}

