/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import java.util.Optional;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.multitenancy.TenantDefinition;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.web.BaseCasRestActuatorEndpoint;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.Access;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

@Endpoint(id="multitenancy", defaultAccess=Access.NONE)
public class MultitenancyEndpoint
extends BaseCasRestActuatorEndpoint {
    private final ObjectProvider<TenantExtractor> tenantExtractor;

    public MultitenancyEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, ObjectProvider<TenantExtractor> tenantExtractor) {
        super(casProperties, applicationContext);
        this.tenantExtractor = tenantExtractor;
    }

    @GetMapping(path={"/tenants"}, produces={"application/json", "application/vnd.spring-boot.actuator.v2+json", "application/vnd.spring-boot.actuator.v3+json", "application/x-www-form-urlencoded", "application/vnd.cas.services+yaml"})
    @Operation(summary="Report registered tenant definitions")
    public List<TenantDefinition> allTenantDefinitions() {
        return ((TenantExtractor)this.tenantExtractor.getObject()).getTenantsManager().findTenants();
    }

    @GetMapping(path={"/tenants/{tenantId}"}, produces={"application/json", "application/vnd.spring-boot.actuator.v2+json", "application/vnd.spring-boot.actuator.v3+json", "application/x-www-form-urlencoded", "application/vnd.cas.services+yaml"})
    @Operation(summary="Report registered tenant definition by its id")
    public ResponseEntity<TenantDefinition> tenantDefinition(@PathVariable String tenantId) {
        return ResponseEntity.of((Optional)((TenantExtractor)this.tenantExtractor.getObject()).getTenantsManager().findTenant(tenantId));
    }
}

