/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote.commands;

import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MutableBucketEntry;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.remote.RemoteVerboseResult;
import io.github.bucket4j.distributed.remote.commands.TryConsumeCommand;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.Scope;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class VerboseCommand<T>
implements RemoteCommand<RemoteVerboseResult<T>>,
ComparableByContent<VerboseCommand<?>> {
    public static final VerboseCommand<Boolean> TRY_CONSUME_ONE_VERBOSE = new VerboseCommand<Boolean>(TryConsumeCommand.TRY_CONSUME_ONE);
    private final RemoteCommand<T> targetCommand;
    public static final SerializationHandle<VerboseCommand<?>> SERIALIZATION_HANDLE = new SerializationHandle<VerboseCommand<?>>(){

        @Override
        public <I> VerboseCommand<?> deserialize(DeserializationAdapter<I> adapter, I input) throws IOException {
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            RemoteCommand<?> targetCommand = RemoteCommand.deserialize(adapter, input);
            return VerboseCommand.from(targetCommand);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, VerboseCommand<?> command, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            adapter.writeInt(output, Versions.v_7_0_0.getNumber());
            RemoteCommand.serialize(adapter, output, command.targetCommand, backwardCompatibilityVersion, scope);
        }

        @Override
        public int getTypeId() {
            return 35;
        }

        @Override
        public Class<VerboseCommand<?>> getSerializedType() {
            return VerboseCommand.class;
        }

        @Override
        public VerboseCommand<?> fromJsonCompatibleSnapshot(Map<String, Object> snapshot) throws IOException {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            RemoteCommand<?> targetCommand = RemoteCommand.fromJsonCompatibleSnapshot((Map)snapshot.get("targetCommand"));
            return VerboseCommand.from(targetCommand);
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(VerboseCommand<?> command, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("version", Versions.v_7_0_0.getNumber());
            result.put("targetCommand", RemoteCommand.toJsonCompatibleSnapshot(command.targetCommand, backwardCompatibilityVersion, scope));
            return result;
        }

        @Override
        public String getTypeName() {
            return "VerboseCommand";
        }
    };

    private VerboseCommand(RemoteCommand<T> targetCommand) {
        this.targetCommand = targetCommand;
    }

    public static <T> VerboseCommand<T> from(RemoteCommand<T> targetCommand) {
        if (targetCommand == TryConsumeCommand.TRY_CONSUME_ONE) {
            return TRY_CONSUME_ONE_VERBOSE;
        }
        return new VerboseCommand<T>(targetCommand);
    }

    public RemoteCommand<T> getTargetCommand() {
        return this.targetCommand;
    }

    @Override
    public boolean canBeMerged(RemoteCommand<?> another) {
        return this == TRY_CONSUME_ONE_VERBOSE && another == TRY_CONSUME_ONE_VERBOSE;
    }

    @Override
    public RemoteCommand<?> toMergedCommand() {
        return new VerboseCommand(this.targetCommand.toMergedCommand());
    }

    @Override
    public void mergeInto(RemoteCommand<?> mergedCommand) {
        this.targetCommand.mergeInto(((VerboseCommand)mergedCommand).targetCommand);
    }

    @Override
    public int getMergedCommandsCount() {
        return this.targetCommand.getMergedCommandsCount();
    }

    @Override
    public CommandResult<?> unwrapOneResult(RemoteVerboseResult<T> mergedVerboseResult, int indice) {
        CommandResult<?> unwrappedTargetResult = this.targetCommand.unwrapOneResult(mergedVerboseResult.getValue(), indice);
        RemoteVerboseResult unwrappedVerboseResult = new RemoteVerboseResult(mergedVerboseResult.getOperationTimeNanos(), unwrappedTargetResult.getResultTypeId(), unwrappedTargetResult.getData(), mergedVerboseResult.getState());
        return CommandResult.success(unwrappedVerboseResult, RemoteVerboseResult.SERIALIZATION_HANDLE);
    }

    @Override
    public boolean isMerged() {
        return this.targetCommand.isMerged();
    }

    @Override
    public CommandResult<RemoteVerboseResult<T>> execute(MutableBucketEntry mutableEntry, long currentTimeNanos) {
        if (!mutableEntry.exists()) {
            return CommandResult.bucketNotFound();
        }
        CommandResult<T> result = this.targetCommand.execute(mutableEntry, currentTimeNanos);
        RemoteVerboseResult<T> verboseResult = new RemoteVerboseResult<T>(currentTimeNanos, result.getResultTypeId(), result.getData(), mutableEntry.get());
        return CommandResult.success(verboseResult, RemoteVerboseResult.SERIALIZATION_HANDLE);
    }

    @Override
    public SerializationHandle<RemoteCommand<?>> getSerializationHandle() {
        return SERIALIZATION_HANDLE;
    }

    @Override
    public boolean equalsByContent(VerboseCommand<?> other) {
        return ComparableByContent.equals(this.targetCommand, other.targetCommand);
    }

    @Override
    public boolean isImmediateSyncRequired(long unsynchronizedTokens, long nanosSinceLastSync) {
        return this.targetCommand.isImmediateSyncRequired(unsynchronizedTokens, nanosSinceLastSync);
    }

    @Override
    public long estimateTokensToConsume() {
        return this.targetCommand.estimateTokensToConsume();
    }

    @Override
    public long getConsumedTokens(RemoteVerboseResult<T> result) {
        return this.targetCommand.getConsumedTokens(result.getValue());
    }

    @Override
    public Version getRequiredVersion() {
        return Versions.max(Versions.v_7_0_0, this.targetCommand.getRequiredVersion());
    }
}

