/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.MembershipTO;

@JsonPropertyOrder(value={"_class", "name"})
@Schema(allOf={AnyCR.class})
public class AnyObjectCR
extends AnyCR
implements GroupableRelatableTO {
    private static final long serialVersionUID = 5460996992553869226L;
    private String type;
    private String name;
    private final List<MembershipTO> memberships = new ArrayList<MembershipTO>();

    @Override
    @JacksonXmlProperty(localName="_class", isAttribute=true)
    @JsonProperty(value="_class")
    @Schema(name="_class", requiredMode=Schema.RequiredMode.REQUIRED, example="org.apache.syncope.common.lib.request.AnyObjectCR")
    public String getDiscriminator() {
        return this.getClass().getName();
    }

    @JsonProperty(required=true)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    @JsonIgnore
    public Optional<MembershipTO> getMembership(String groupKey) {
        return this.memberships.stream().filter(membership -> groupKey.equals(membership.getGroupKey())).findFirst();
    }

    @Override
    @JacksonXmlElementWrapper(localName="memberships")
    @JacksonXmlProperty(localName="membership")
    public List<MembershipTO> getMemberships() {
        return this.memberships;
    }

    @Override
    @JsonIgnore
    public List<MembershipTO> getDynMemberships() {
        return List.of();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.name).append(this.memberships).build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnyObjectCR other = (AnyObjectCR)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.name, (Object)other.name).append(this.memberships, other.memberships).build();
    }

    public static class Builder
    extends AnyCR.Builder<AnyObjectCR, Builder> {
        @Override
        protected AnyObjectCR newInstance() {
            return new AnyObjectCR();
        }

        public Builder(String realm, String type, String name) {
            super(realm);
            ((AnyObjectCR)this.getInstance()).setType(type);
            ((AnyObjectCR)this.getInstance()).setName(name);
        }

        public Builder membership(MembershipTO membership) {
            ((AnyObjectCR)this.getInstance()).getMemberships().add(membership);
            return this;
        }

        public Builder memberships(MembershipTO ... memberships) {
            ((AnyObjectCR)this.getInstance()).getMemberships().addAll(List.of(memberships));
            return this;
        }

        public Builder memberships(Collection<MembershipTO> memberships) {
            ((AnyObjectCR)this.getInstance()).getMemberships().addAll(memberships);
            return this;
        }
    }
}

