/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.referral;

import java.util.HashMap;
import java.util.Map;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.PooledConnectionFactory;
import org.ldaptive.referral.ReferralConnectionFactory;

public class PooledReferralConnectionFactory
implements ReferralConnectionFactory {
    private final Map<String, PooledConnectionFactory> factories = new HashMap<String, PooledConnectionFactory>();
    private final PooledConnectionFactory factory;
    private boolean closed;

    public PooledReferralConnectionFactory(PooledConnectionFactory cf) {
        this.factory = this.copy(cf, null);
    }

    private PooledConnectionFactory copy(PooledConnectionFactory cf, String url) {
        PooledConnectionFactory.Builder builder = cf.getTransport() != null ? PooledConnectionFactory.builder(cf.getTransport()) : PooledConnectionFactory.builder();
        ConnectionConfig cc = ConnectionConfig.copy(cf.getConnectionConfig());
        cc.setLdapUrl(url);
        return builder.config(cc).connectOnCreate(cf.getConnectOnCreate()).activator(cf.getActivator()).passivator(cf.getPassivator()).pruneStrategy(cf.getPruneStrategy()).validator(cf.getValidator()).validationExceptionHandler(cf.getValidationExceptionHandler()).validateOnCheckIn(cf.isValidateOnCheckIn()).validateOnCheckOut(cf.isValidateOnCheckOut()).validatePeriodically(cf.isValidatePeriodically()).blockWaitTime(cf.getBlockWaitTime()).failFastInitialize(cf.getFailFastInitialize()).min(cf.getMinPoolSize()).max(cf.getMaxPoolSize()).name(cf.getName()).freeze().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionFactory getConnectionFactory(String url) {
        Map<String, PooledConnectionFactory> map = this.factories;
        synchronized (map) {
            if (this.closed) {
                throw new IllegalStateException("Connection factory is closed");
            }
            PooledConnectionFactory cf = this.factories.get(url);
            if (cf == null) {
                cf = this.copy(this.factory, url);
                cf.initialize();
                this.factories.put(url, cf);
            }
            return cf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map<String, PooledConnectionFactory> map = this.factories;
        synchronized (map) {
            for (PooledConnectionFactory cf : this.factories.values()) {
                cf.close();
            }
            this.closed = true;
        }
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.hashCode() + "::factories=" + this.factories + ", factory=" + this.factory + ", closed=" + this.closed;
    }
}

