/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.authentication;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public interface CasWebflowExceptionCatalog {
    public static final String UNKNOWN = "UNKNOWN";
    public static final String BEAN_NAME = "casWebflowExceptionCatalog";
    public static final Logger LOGGER = LoggerFactory.getLogger(CasWebflowExceptionCatalog.class);

    public void registerException(Class<? extends Throwable> var1);

    public void registerExceptions(Collection<Class<? extends Throwable>> var1);

    public Set<Class<? extends Throwable>> getRegisteredExceptions();

    default public String translateException(RequestContext requestContext, Exception exception) {
        if (exception instanceof AuthenticationException) {
            AuthenticationException authenticationException = (AuthenticationException)exception;
            List<Class> values = authenticationException.getHandlerErrors().values().stream().map(Object::getClass).toList();
            String handlerErrorName = this.getRegisteredExceptions().stream().filter(values::contains).map(Class::getSimpleName).findFirst().orElseGet(() -> {
                LOGGER.debug("Unable to translate handler errors of the authentication exception [{}]. Returning [{}]", (Object)exception, (Object)UNKNOWN);
                return UNKNOWN;
            });
            String messageCode = "authenticationFailure." + handlerErrorName;
            WebUtils.addErrorMessageToContext((RequestContext)requestContext, (String)messageCode, (String)"", (Object[])authenticationException.getArgs().toArray());
            return handlerErrorName;
        }
        if (exception instanceof AbstractTicketException) {
            AbstractTicketException e = (AbstractTicketException)exception;
            Optional<String> match = this.getRegisteredExceptions().stream().filter(ex -> ex.isInstance(e)).map(Class::getSimpleName).findFirst();
            WebUtils.addErrorMessageToContext((RequestContext)requestContext, (String)e.getCode(), (String)"", (Object[])e.getArgs().toArray());
            return match.orElse(UNKNOWN);
        }
        return UNKNOWN;
    }
}

