/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.credential.BasicIdentifiableCredential;
import org.apereo.cas.authentication.principal.NullPrincipal;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.email.EmailProperties;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.configuration.model.support.sms.SmsProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.notifications.mail.EmailCommunicationResult;
import org.apereo.cas.notifications.mail.EmailMessageBodyBuilder;
import org.apereo.cas.notifications.mail.EmailMessageRequest;
import org.apereo.cas.notifications.sms.SmsBodyBuilder;
import org.apereo.cas.notifications.sms.SmsRequest;
import org.apereo.cas.pm.PasswordManagementQuery;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.PasswordResetUrlBuilder;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SendPasswordResetInstructionsAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SendPasswordResetInstructionsAction.class);
    public static final String REQUEST_PARAMETER_USERNAME = "username";
    protected final CasConfigurationProperties casProperties;
    protected final CommunicationsManager communicationsManager;
    protected final PasswordManagementService passwordManagementService;
    protected final TicketRegistry ticketRegistry;
    protected final TicketFactory ticketFactory;
    protected final PrincipalResolver principalResolver;
    protected final PasswordResetUrlBuilder passwordResetUrlBuilder;
    protected final MultifactorAuthenticationProviderSelector multifactorAuthenticationProviderSelector;
    protected final AuthenticationSystemSupport authenticationSystemSupport;
    protected final ServicesManager servicesManager;

    @Audit(action="REQUEST_CHANGE_PASSWORD", principalResolverName="REQUEST_CHANGE_PASSWORD_PRINCIPAL_RESOLVER", actionResolverName="REQUEST_CHANGE_PASSWORD_ACTION_RESOLVER", resourceResolverName="REQUEST_CHANGE_PASSWORD_RESOURCE_RESOLVER")
    protected Event doExecuteInternal(RequestContext requestContext) throws Throwable {
        this.communicationsManager.validate();
        if (!this.communicationsManager.isMailSenderDefined() && !this.communicationsManager.isSmsSenderDefined()) {
            return this.getErrorEvent("contact.failed", "Unable to send email as no mail sender is defined", requestContext);
        }
        PasswordManagementQuery query = this.buildPasswordManagementQuery(requestContext);
        if (StringUtils.isBlank((CharSequence)query.getUsername())) {
            return this.getErrorEvent("username.required", "No username is provided", requestContext);
        }
        String email = this.passwordManagementService.findEmail(query);
        String phone = this.passwordManagementService.findPhone(query);
        if (StringUtils.isBlank((CharSequence)email) && StringUtils.isBlank((CharSequence)phone)) {
            LOGGER.warn("No recipient is provided with a valid email/phone");
            return this.getInvalidContactEvent(requestContext);
        }
        WebUtils.putPasswordManagementQuery((RequestContext)requestContext, (Serializable)query);
        if (this.doesPasswordResetRequireMultifactorAuthentication(requestContext) && !this.hasPrincipalRegisteredMultifactorAuthenticationDevice(requestContext)) {
            LOGGER.warn("No registered devices for multifactor authentication could be found for [{}]", (Object)query.getUsername());
            WebUtils.addErrorMessageToContext((RequestContext)requestContext, (String)"screen.mfaDenied.message");
            return new EventFactorySupport().event((Object)this, "deny");
        }
        WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
        URL url = this.buildPasswordResetUrl(query.getUsername(), service);
        if (url != null) {
            PasswordManagementProperties pm = this.casProperties.getAuthn().getPm();
            Duration duration = Beans.newDuration((String)pm.getReset().getExpiration());
            LOGGER.debug("Generated password reset URL [{}]; Link is only active for the next [{}] minute(s)", (Object)url, (Object)duration);
            EmailCommunicationResult sendEmail = this.sendPasswordResetEmailToAccount(query.getUsername(), email, url, requestContext);
            boolean sendSms = this.sendPasswordResetSmsToAccount(phone, url);
            if (sendEmail.isSuccess() || sendSms) {
                return this.success(url);
            }
        } else {
            LOGGER.error("No password reset URL could be built and sent to [{}]", (Object)email);
        }
        LOGGER.error("Failed to notify account [{}]", (Object)email);
        return this.getErrorEvent("contact.failed", "Failed to send the password reset link via email address or phone", requestContext);
    }

    protected boolean doesPasswordResetRequireMultifactorAuthentication(RequestContext requestContext) throws Throwable {
        boolean mfaRequired;
        ApplicationContext applicationContext = requestContext.getActiveFlow().getApplicationContext();
        Map providers = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)applicationContext);
        String providerId = MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationProvider((RequestContext)requestContext);
        boolean bl = mfaRequired = this.casProperties.getAuthn().getPm().getReset().isMultifactorAuthenticationEnabled() && !providers.isEmpty() && StringUtils.isBlank((CharSequence)providerId);
        if (mfaRequired) {
            PasswordManagementQuery query = (PasswordManagementQuery)WebUtils.getPasswordManagementQuery((RequestContext)requestContext, PasswordManagementQuery.class);
            Principal principal = this.resolvedPrincipal(query.getUsername());
            MultifactorAuthenticationProvider provider = this.selectMultifactorAuthenticationProvider(requestContext, principal);
            WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
            RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
            Authentication authentication = new DefaultAuthenticationBuilder(principal).addCredential((Credential)new BasicIdentifiableCredential(query.getUsername())).build();
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
            MultifactorAuthenticationProviderBypassEvaluator bypassEvaluator = provider.getBypassEvaluator();
            mfaRequired = bypassEvaluator == null || bypassEvaluator.shouldMultifactorAuthenticationProviderExecute(authentication, registeredService, provider, request, (Service)service);
        }
        return mfaRequired;
    }

    protected boolean hasPrincipalRegisteredMultifactorAuthenticationDevice(RequestContext requestContext) throws Throwable {
        PasswordManagementQuery query = (PasswordManagementQuery)WebUtils.getPasswordManagementQuery((RequestContext)requestContext, PasswordManagementQuery.class);
        Principal principal = this.resolvedPrincipal(query.getUsername());
        MultifactorAuthenticationProvider provider = this.selectMultifactorAuthenticationProvider(requestContext, principal);
        LOGGER.debug("Selected multifactor authentication provider [{}]", (Object)provider.getId());
        return provider.getDeviceManager() == null || provider.getDeviceManager().hasRegisteredDevices(principal);
    }

    protected Principal resolvedPrincipal(String username) throws Throwable {
        Principal resolvedPrincipal = this.principalResolver.resolve((Credential)new BasicIdentifiableCredential(username));
        return resolvedPrincipal instanceof NullPrincipal ? this.authenticationSystemSupport.getPrincipalFactory().createPrincipal(username) : resolvedPrincipal;
    }

    protected MultifactorAuthenticationProvider selectMultifactorAuthenticationProvider(RequestContext requestContext, Principal principal) throws Throwable {
        ApplicationContext applicationContext = requestContext.getActiveFlow().getApplicationContext();
        Map providers = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)applicationContext);
        RegisteredService registeredService = WebUtils.getRegisteredService((RequestContext)requestContext);
        return this.multifactorAuthenticationProviderSelector.resolve(providers.values(), registeredService, principal);
    }

    protected PasswordManagementQuery buildPasswordManagementQuery(RequestContext requestContext) {
        PasswordManagementQuery existingQuery = (PasswordManagementQuery)WebUtils.getPasswordManagementQuery((RequestContext)requestContext, PasswordManagementQuery.class);
        return Optional.ofNullable(existingQuery).orElseGet(() -> {
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
            String username = request.getParameter(REQUEST_PARAMETER_USERNAME);
            PasswordManagementQuery.PasswordManagementQueryBuilder builder = PasswordManagementQuery.builder();
            if (StringUtils.isBlank((CharSequence)username)) {
                LOGGER.warn("No username parameter is provided");
            }
            return builder.username(username).build();
        });
    }

    protected Event getInvalidContactEvent(RequestContext requestContext) {
        return this.getErrorEvent("contact.invalid", "Provided email address or phone number is invalid", requestContext);
    }

    protected boolean sendPasswordResetSmsToAccount(String to, URL url) throws Throwable {
        if (StringUtils.isNotBlank((CharSequence)to)) {
            LOGGER.debug("Sending password reset URL [{}] via SMS to [{}]", (Object)url.toExternalForm(), (Object)to);
            SmsProperties reset = this.casProperties.getAuthn().getPm().getReset().getSms();
            String message = SmsBodyBuilder.builder().properties(reset).parameters(Map.of("url", url.toExternalForm())).build().get();
            SmsRequest smsRequest = SmsRequest.builder().from(reset.getFrom()).to(List.of(to)).text(message).build();
            return this.communicationsManager.sms(smsRequest);
        }
        return false;
    }

    protected EmailCommunicationResult sendPasswordResetEmailToAccount(String username, String to, URL url, RequestContext requestContext) throws Throwable {
        EmailProperties reset = this.casProperties.getAuthn().getPm().getReset().getMail();
        Map parameters = CollectionUtils.wrap((String)"url", (Object)url.toExternalForm());
        if (StringUtils.isNotBlank((CharSequence)to)) {
            Principal person = this.resolvedPrincipal(username);
            FunctionUtils.doIfNotNull((Object)person, principal -> parameters.put("principal", principal));
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
            Optional<Locale> locale = Optional.ofNullable(RequestContextUtils.getLocaleResolver((HttpServletRequest)request)).map(resolver -> resolver.resolveLocale(request));
            String text = EmailMessageBodyBuilder.builder().properties(reset).parameters(parameters).locale(locale).build().get();
            LOGGER.debug("Sending password reset URL [{}] via email to [{}] for username [{}]", new Object[]{url, to, username});
            EmailMessageRequest emailRequest = EmailMessageRequest.builder().emailProperties(reset).principal(person).to(List.of(to)).locale(locale.orElseGet(Locale::getDefault)).body(text).build();
            return this.communicationsManager.email(emailRequest);
        }
        return EmailCommunicationResult.builder().success(false).to(List.of(to)).build();
    }

    protected Event getErrorEvent(String code, String defaultMessage, RequestContext requestContext) {
        WebUtils.addErrorMessageToContext((RequestContext)requestContext, (String)("screen.pm.reset." + code), (String)defaultMessage);
        LOGGER.error(defaultMessage);
        return new EventFactorySupport().event((Object)this, "error");
    }

    protected URL buildPasswordResetUrl(String username, WebApplicationService service) throws Throwable {
        return this.passwordResetUrlBuilder.build(username, service);
    }

    @Generated
    public SendPasswordResetInstructionsAction(CasConfigurationProperties casProperties, CommunicationsManager communicationsManager, PasswordManagementService passwordManagementService, TicketRegistry ticketRegistry, TicketFactory ticketFactory, PrincipalResolver principalResolver, PasswordResetUrlBuilder passwordResetUrlBuilder, MultifactorAuthenticationProviderSelector multifactorAuthenticationProviderSelector, AuthenticationSystemSupport authenticationSystemSupport, ServicesManager servicesManager) {
        this.casProperties = casProperties;
        this.communicationsManager = communicationsManager;
        this.passwordManagementService = passwordManagementService;
        this.ticketRegistry = ticketRegistry;
        this.ticketFactory = ticketFactory;
        this.principalResolver = principalResolver;
        this.passwordResetUrlBuilder = passwordResetUrlBuilder;
        this.multifactorAuthenticationProviderSelector = multifactorAuthenticationProviderSelector;
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.servicesManager = servicesManager;
    }
}

