/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.scim.v2.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collections;
import java.util.Set;
import net.tirasa.connid.bundles.scim.common.SCIMConnectorConfiguration;
import net.tirasa.connid.bundles.scim.common.dto.BaseResourceReference;
import net.tirasa.connid.bundles.scim.common.dto.PagedResults;
import net.tirasa.connid.bundles.scim.common.service.AbstractSCIMService;
import net.tirasa.connid.bundles.scim.common.utils.SCIMUtils;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2Attribute;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2EntitlementResource;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2Group;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2Patch;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2PatchImpl;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2PatchOperation;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2User;
import org.identityconnectors.framework.common.objects.Attribute;

public class SCIMv2Client
extends AbstractSCIMService<SCIMv2User, SCIMv2Group, SCIMv2EntitlementResource, SCIMv2Patch> {
    public SCIMv2Client(SCIMConnectorConfiguration config) {
        super(config);
    }

    @Override
    public SCIMv2User getUser(String userId) {
        return this.doGetUser(this.getWebclient("Users", null).path((Object)userId), SCIMv2User.class, SCIMv2Attribute.class);
    }

    @Override
    public SCIMv2User createUser(SCIMv2User user) {
        return this.doCreateUser(user);
    }

    public SCIMv2User updateUser(SCIMv2User user, Set<Attribute> replaceAttributes) {
        return this.doUpdateUser(user, replaceAttributes, SCIMv2User.class);
    }

    @Override
    public SCIMv2User updateUser(SCIMv2User user) {
        return this.doUpdateUser(user, Collections.emptySet(), SCIMv2User.class);
    }

    @Override
    public SCIMv2User updateUser(String userId, SCIMv2Patch userPatch) {
        return this.doUpdateUser(userId, userPatch, SCIMv2User.class);
    }

    @Override
    public SCIMv2Group getGroup(String groupId) {
        return this.doGetGroup(this.getWebclient("Groups", null).path((Object)groupId), SCIMv2Group.class);
    }

    @Override
    public SCIMv2EntitlementResource getEntitlement(String entitlementId) {
        return this.doGetEntitlement(this.getWebclient("Entitlements", null).path((Object)entitlementId), SCIMv2EntitlementResource.class);
    }

    @Override
    public SCIMv2Group updateGroup(String groupId, SCIMv2Patch groupPatch) {
        return this.doUpdateGroup(new SCIMv2Group.Builder().id(groupId).build(), Collections.emptySet(), groupPatch, SCIMv2Group.class);
    }

    @Override
    public SCIMv2Group updateGroup(SCIMv2Group group) {
        return this.doUpdateGroup(group, Collections.emptySet(), null, SCIMv2Group.class);
    }

    public SCIMv2Group updateGroup(SCIMv2Group group, Set<Attribute> replaceAttributes) {
        return this.doUpdateGroup(group, replaceAttributes, null, SCIMv2Group.class);
    }

    @Override
    public void deleteGroup(String groupId) {
        this.doDeleteGroup(groupId, this.getWebclient("Groups", null).path((Object)groupId));
    }

    @Override
    protected PagedResults<SCIMv2User> deserializeUserPagedResults(String node) throws JsonProcessingException {
        return (PagedResults)SCIMUtils.MAPPER.readValue(node, (TypeReference)new TypeReference<PagedResults<SCIMv2User>>(){});
    }

    @Override
    protected PagedResults<SCIMv2Group> deserializeGroupPagedResults(String node) throws JsonProcessingException {
        return (PagedResults)SCIMUtils.MAPPER.readValue(node, (TypeReference)new TypeReference<PagedResults<SCIMv2Group>>(){});
    }

    @Override
    protected SCIMv2Patch buildPatchFromAttrs(Set<Attribute> replaceAttributes) {
        SCIMv2PatchImpl patch = new SCIMv2PatchImpl();
        replaceAttributes.stream().filter(attr -> !attr.getValue().isEmpty()).map(attr -> new SCIMv2PatchOperation.Builder().op("replace").path(attr.getName()).value(new BaseResourceReference.Builder().value(attr.getValue().get(0).toString()).build()).build()).forEach(op -> patch.getOperations().add((SCIMv2PatchOperation)op));
        return patch;
    }
}

