/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.page;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.page.PartialPageUpdate;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.string.Strings;

public class XmlPartialPageUpdate
extends PartialPageUpdate {
    public static final String START_ROOT_ELEMENT = "<ajax-response>";
    public static final String END_ROOT_ELEMENT = "</ajax-response>";

    public XmlPartialPageUpdate(Page page) {
        super(page);
    }

    @Override
    public void setContentType(WebResponse response, String encoding) {
        response.setContentType("text/xml; charset=" + encoding);
    }

    @Override
    protected void writeHeader(Response response, String encoding) {
        response.write((CharSequence)"<?xml version=\"1.0\" encoding=\"");
        response.write((CharSequence)encoding);
        response.write((CharSequence)"\"?>");
        response.write((CharSequence)START_ROOT_ELEMENT);
    }

    @Override
    protected void writeComponent(Response response, String markupId, Component component, String encoding) {
        super.writeComponent(response, markupId, component, encoding);
    }

    @Override
    protected void writeComponent(Response response, String markupId, CharSequence contents) {
        response.write((CharSequence)"<component id=\"");
        response.write((CharSequence)markupId);
        response.write((CharSequence)"\" ><![CDATA[");
        response.write(this.encode(contents));
        response.write((CharSequence)"]]></component>");
    }

    @Override
    protected void writeFooter(Response response, String encoding) {
        response.write((CharSequence)END_ROOT_ELEMENT);
    }

    @Override
    protected void writePriorityEvaluation(Response response, CharSequence contents) {
        this.writeHeaderContribution(response, "priority-evaluate", contents);
    }

    @Override
    protected void writeHeaderContribution(Response response, CharSequence contents) {
        this.writeHeaderContribution(response, "header-contribution", contents);
    }

    @Override
    protected void writeEvaluation(Response response, CharSequence contents) {
        this.writeHeaderContribution(response, "evaluate", contents);
    }

    private void writeHeaderContribution(Response response, String elementName, CharSequence contents) {
        if (!Strings.isEmpty((CharSequence)contents)) {
            response.write((CharSequence)("<" + elementName + ">"));
            response.write((CharSequence)"<![CDATA[<head xmlns:wicket=\"http://wicket.apache.org\">");
            response.write(this.encode(contents));
            response.write((CharSequence)"</head>]]>");
            response.write((CharSequence)("</" + elementName + ">"));
        }
    }

    protected CharSequence encode(CharSequence str) {
        return Strings.replaceAll((CharSequence)str, (CharSequence)"]]>", (CharSequence)"]]]]><![CDATA[>");
    }
}

