/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.concurrent;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class TCConcurrentStore<K, V> {
    static final int MAX_SEGMENTS = 65536;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_INITIAL_CAPACITY = 256;
    static final int DEFAULT_SEGMENTS = 16;
    private final int segmentShift;
    private final int segmentMask;
    private final Segment<K, V>[] segments;

    public TCConcurrentStore() {
        this(256, 0.75f, 16);
    }

    public TCConcurrentStore(int initialCapacity) {
        this(initialCapacity, 0.75f, 16);
    }

    public TCConcurrentStore(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 16);
    }

    public TCConcurrentStore(int initialCapacity, float loadFactor, int concurrencyLevel) {
        int cap;
        int c;
        int ssize;
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrencyLevel <= 0) {
            throw new IllegalArgumentException();
        }
        if (concurrencyLevel > 65536) {
            concurrencyLevel = 65536;
        }
        int sshift = 0;
        for (ssize = 1; ssize < concurrencyLevel; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = this.initSegments(ssize);
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if ((c = initialCapacity / ssize) * ssize < initialCapacity) {
            ++c;
        }
        for (cap = 1; cap < c; cap <<= 1) {
        }
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment(cap, loadFactor);
        }
    }

    private Segment<K, V>[] initSegments(int ssize) {
        return new Segment[ssize];
    }

    private static int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    final Segment<K, V> segmentFor(Object key) {
        int hash = TCConcurrentStore.hash(key.hashCode());
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    public V get(K key) {
        return this.segmentFor(key).get(key);
    }

    public V put(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return this.segmentFor(key).put(key, value);
    }

    public V putIfAbsent(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return this.segmentFor(key).putIfAbsent(key, value);
    }

    public V remove(K key) {
        return this.segmentFor(key).remove(key);
    }

    public Object executeUnderReadLock(K key, Object param, TCConcurrentStoreCallback<K, V> callback) {
        return this.segmentFor(key).executeUnderReadLock(key, param, callback);
    }

    public Object executeUnderWriteLock(K key, Object param, TCConcurrentStoreCallback<K, V> callback) {
        return this.segmentFor(key).executeUnderWriteLock(key, param, callback);
    }

    public Set<K> addAllKeysTo(Set<K> keySet) {
        for (Segment<K, V> seg : this.segments) {
            seg.addAllKeysTo(keySet);
        }
        return keySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.fullyReadLock();
        try {
            int size = 0;
            for (Segment<K, V> seg : this.segments) {
                size += seg.size();
            }
            int n = size;
            return n;
        }
        finally {
            this.fullyReadUnlock();
        }
    }

    private void fullyReadLock() {
        for (Segment<K, V> seg : this.segments) {
            seg.readLock().lock();
        }
    }

    private void fullyReadUnlock() {
        for (Segment<K, V> seg : this.segments) {
            seg.readLock().unlock();
        }
    }

    private static final class Segment<K, V>
    extends ReentrantReadWriteLock {
        private final HashMap<K, V> map;

        public Segment(int initialCapacity, float loadFactor) {
            this.map = new HashMap(initialCapacity, loadFactor);
        }

        public int size() {
            return this.map.size();
        }

        public Set<K> addAllKeysTo(Set<K> keySet) {
            this.readLock().lock();
            try {
                keySet.addAll(this.map.keySet());
                Set<K> set = keySet;
                return set;
            }
            finally {
                this.readLock().unlock();
            }
        }

        public V get(K key) {
            this.readLock().lock();
            try {
                V v = this.map.get(key);
                return v;
            }
            finally {
                this.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V put(K key, V value) {
            this.writeLock().lock();
            try {
                V v = this.map.put(key, value);
                return v;
            }
            finally {
                this.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V putIfAbsent(K key, V value) {
            this.writeLock().lock();
            try {
                if (!this.map.containsKey(key)) {
                    V v = this.map.put(key, value);
                    return v;
                }
                V v = this.map.get(key);
                return v;
            }
            finally {
                this.writeLock().unlock();
            }
        }

        public V remove(K key) {
            this.writeLock().lock();
            try {
                V v = this.map.remove(key);
                return v;
            }
            finally {
                this.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object executeUnderReadLock(K key, Object param, TCConcurrentStoreCallback<K, V> callback) {
            this.readLock().lock();
            try {
                Object object = callback.callback(key, param, this.map);
                return object;
            }
            finally {
                this.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object executeUnderWriteLock(K key, Object param, TCConcurrentStoreCallback<K, V> callback) {
            this.writeLock().lock();
            try {
                Object object = callback.callback(key, param, this.map);
                return object;
            }
            finally {
                this.writeLock().unlock();
            }
        }
    }

    public static interface TCConcurrentStoreCallback<K, V> {
        public Object callback(K var1, Object var2, Map<K, V> var3);
    }
}

