/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.net.core.TCConnection;
import com.tc.net.core.TCConnectionManager;
import com.tc.net.protocol.transport.ClientMessageTransport;
import com.tc.net.protocol.transport.ConnectionHealthChecker;
import com.tc.net.protocol.transport.MessageTransportFactory;
import com.tc.net.protocol.transport.MessageTransportListener;
import com.tc.net.protocol.transport.ReconnectionRejectedHandler;
import com.tc.net.protocol.transport.ServerMessageTransport;
import com.tc.net.protocol.transport.TransportHandshakeErrorHandler;
import com.tc.net.protocol.transport.TransportHandshakeMessageFactory;
import com.tc.net.protocol.transport.WireProtocolAdaptorFactory;
import com.tc.net.protocol.transport.WireProtocolAdaptorFactoryImpl;
import java.util.List;

public class MessageTransportFactoryImpl
implements MessageTransportFactory {
    private final TransportHandshakeMessageFactory transportMessageFactory;
    private final ConnectionHealthChecker connectionHealthChecker;
    private final TCConnectionManager connectionMgr;
    private final int timeout;
    private final int callbackport;
    private final TransportHandshakeErrorHandler defaultHandshakeErrorHandler;
    private final ReconnectionRejectedHandler reconnectionRejectedHandler;

    public MessageTransportFactoryImpl(TransportHandshakeMessageFactory transportMessageFactory, ConnectionHealthChecker connectionHealthChecker, TCConnectionManager connectionManager, int timeout, int callbackPort, TransportHandshakeErrorHandler defaultHandshakeErrorHandler, ReconnectionRejectedHandler reconnectionRejectedBehaviour) {
        this.transportMessageFactory = transportMessageFactory;
        this.connectionHealthChecker = connectionHealthChecker;
        this.connectionMgr = connectionManager;
        this.timeout = timeout;
        this.callbackport = callbackPort;
        this.defaultHandshakeErrorHandler = defaultHandshakeErrorHandler;
        this.reconnectionRejectedHandler = reconnectionRejectedBehaviour;
    }

    @Override
    public ClientMessageTransport createNewTransport() {
        ClientMessageTransport cmt = this.createClientMessageTransport(this.defaultHandshakeErrorHandler, this.transportMessageFactory, new WireProtocolAdaptorFactoryImpl(), this.callbackport);
        cmt.addTransportListener(this.connectionHealthChecker);
        return cmt;
    }

    protected ClientMessageTransport createClientMessageTransport(TransportHandshakeErrorHandler handshakeErrorHandler, TransportHandshakeMessageFactory messageFactory, WireProtocolAdaptorFactory wireProtocolAdaptorFactory, int callbackPortNum) {
        return new ClientMessageTransport(this.connectionMgr, handshakeErrorHandler, this.transportMessageFactory, wireProtocolAdaptorFactory, callbackPortNum, this.timeout, this.reconnectionRejectedHandler);
    }

    @Override
    public ServerMessageTransport createNewTransport(TransportHandshakeErrorHandler handler, TransportHandshakeMessageFactory handshakeMessageFactory, List<MessageTransportListener> transportListeners) {
        throw new AssertionError();
    }

    @Override
    public ServerMessageTransport createNewTransport(TCConnection connection, TransportHandshakeErrorHandler handler, TransportHandshakeMessageFactory handshakeMessageFactory, List<MessageTransportListener> transportListeners) {
        throw new AssertionError();
    }
}

