/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.auth;

import java.io.Serializable;
import java.util.Map;
import org.apache.syncope.common.lib.AbstractLDAPConf;
import org.apache.syncope.common.lib.auth.AuthModuleConf;
import org.apache.syncope.common.lib.auth.LDAPDependantAuthModuleConf;
import org.apache.syncope.common.lib.auth.MFAAuthModuleConf;
import org.apache.syncope.common.lib.to.AuthModuleTO;
import org.apache.syncope.common.lib.types.OIDCTokenEncryptionEncoding;

public class GoogleMfaAuthModuleConf
implements MFAAuthModuleConf,
LDAPDependantAuthModuleConf {
    private static final long serialVersionUID = -7883257599139312426L;
    private String issuer = "Syncope";
    private String label = "Syncope";
    private int codeDigits = 6;
    private long timeStepSize = 30L;
    private int windowSize = 3;
    private boolean enableCrypto = true;
    private OIDCTokenEncryptionEncoding cryptoAlgorithm = OIDCTokenEncryptionEncoding.A256CBC_HS512;
    private CryptoStrategy cryptoStrategy = CryptoStrategy.ENCRYPT_AND_SIGN;
    private int signingKeySize = 512;
    private String signingKey = "";
    private int encryptionKeySize = 512;
    private String encryptionKey = "";
    private LDAP ldap;

    @Override
    public AbstractLDAPConf ldapInstance() {
        return new LDAP();
    }

    @Override
    public String getFriendlyName() {
        return "Google Authenticator";
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int getCodeDigits() {
        return this.codeDigits;
    }

    public void setCodeDigits(int codeDigits) {
        this.codeDigits = codeDigits;
    }

    public long getTimeStepSize() {
        return this.timeStepSize;
    }

    public void setTimeStepSize(long timeStepSize) {
        this.timeStepSize = timeStepSize;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }

    public boolean isEnableCrypto() {
        return this.enableCrypto;
    }

    public void setEnableCrypto(boolean enableCrypto) {
        this.enableCrypto = enableCrypto;
    }

    public OIDCTokenEncryptionEncoding getCryptoAlgorithm() {
        return this.cryptoAlgorithm;
    }

    public void setCryptoAlgorithm(OIDCTokenEncryptionEncoding cryptoAlgorithm) {
        this.cryptoAlgorithm = cryptoAlgorithm;
    }

    public CryptoStrategy getCryptoStrategy() {
        return this.cryptoStrategy;
    }

    public void setCryptoStrategy(CryptoStrategy cryptoStrategy) {
        this.cryptoStrategy = cryptoStrategy;
    }

    public int getSigningKeySize() {
        return this.signingKeySize;
    }

    public void setSigningKeySize(int signingKeySize) {
        this.signingKeySize = signingKeySize;
    }

    public String getSigningKey() {
        return this.signingKey;
    }

    public void setSigningKey(String signingKey) {
        this.signingKey = signingKey;
    }

    public int getEncryptionKeySize() {
        return this.encryptionKeySize;
    }

    public void setEncryptionKeySize(int encryptionKeySize) {
        this.encryptionKeySize = encryptionKeySize;
    }

    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public void setEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public LDAP getLdap() {
        return this.ldap;
    }

    public void setLdap(LDAP ldap) {
        this.ldap = ldap;
    }

    @Override
    public Map<String, Object> map(AuthModuleTO authModule, AuthModuleConf.Mapper mapper) {
        return mapper.map(authModule, this);
    }

    public static class LDAP
    extends AbstractLDAPConf
    implements Serializable {
        private static final long serialVersionUID = -7274446267090678730L;
        private String accountAttributeName = "casGAuthRecord";

        public String getAccountAttributeName() {
            return this.accountAttributeName;
        }

        public void setAccountAttributeName(String accountAttributeName) {
            this.accountAttributeName = accountAttributeName;
        }
    }

    public static enum CryptoStrategy {
        ENCRYPT_AND_SIGN,
        SIGN_AND_ENCRYPT;

    }
}

