/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.syncope.client.ui.commons.rest.ResponseHolder;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.IFixedLocationResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;

public class HttpResourceStream
extends AbstractResourceStream
implements IFixedLocationResourceStream {
    private static final long serialVersionUID = 5811207817876330189L;
    private final ResponseHolder responseHolder;

    public HttpResourceStream(ResponseHolder responseHolder) {
        this.responseHolder = responseHolder;
    }

    public InputStream getInputStream() throws ResourceStreamNotFoundException {
        return this.responseHolder.getInputStream() == null ? new ByteArrayInputStream(new byte[0]) : this.responseHolder.getInputStream();
    }

    public Bytes length() {
        return this.responseHolder.getInputStream() == null ? Bytes.bytes((long)0L) : null;
    }

    public void close() throws IOException {
    }

    public String locationAsString() {
        return this.responseHolder.getLocation();
    }

    public String getContentType() {
        return Optional.ofNullable(this.responseHolder.getContentType()).orElse("application/octet-stream");
    }

    public String getFilename() {
        return this.responseHolder.getFilename();
    }
}

