/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.spring.kafka;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.flowable.eventregistry.api.OutboundEvent;
import org.flowable.eventregistry.spring.kafka.KafkaPartitionProvider;

public class RoundRobinKafkaPartitionProvider
implements KafkaPartitionProvider {
    protected final List<Integer> partitions;
    protected final AtomicInteger counter;

    public RoundRobinKafkaPartitionProvider(List<Integer> partitions) {
        this.partitions = partitions;
        this.counter = new AtomicInteger(0);
    }

    @Override
    public Integer determinePartition(OutboundEvent<?> outboundEvent) {
        int nextValue = this.counter.getAndIncrement();
        int availablePartitions = this.partitions.size();
        return this.partitions.get(Math.abs(nextValue) % availablePartitions);
    }
}

