/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.core.definition.pattern;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.tiles.api.Definition;
import org.apache.tiles.core.definition.pattern.AbstractPatternDefinitionResolver;
import org.apache.tiles.core.definition.pattern.DefinitionPatternMatcher;
import org.apache.tiles.core.definition.pattern.DefinitionPatternMatcherFactory;
import org.apache.tiles.core.definition.pattern.PatternRecognizer;
import org.apache.tiles.core.definition.pattern.PatternUtil;

public class BasicPatternDefinitionResolver<T>
extends AbstractPatternDefinitionResolver<T> {
    private final DefinitionPatternMatcherFactory definitionPatternMatcherFactory;
    private final PatternRecognizer patternRecognizer;

    public BasicPatternDefinitionResolver(DefinitionPatternMatcherFactory definitionPatternMatcherFactory, PatternRecognizer patternRecognizer) {
        this.definitionPatternMatcherFactory = definitionPatternMatcherFactory;
        this.patternRecognizer = patternRecognizer;
    }

    @Override
    protected Map<String, Definition> addDefinitionsAsPatternMatchers(List<DefinitionPatternMatcher> matchers, Map<String, Definition> defsMap) {
        LinkedHashSet<String> excludedKeys = new LinkedHashSet<String>();
        for (Map.Entry<String, Definition> de : defsMap.entrySet()) {
            String key = de.getKey();
            if (this.patternRecognizer.isPatternRecognized(key)) {
                matchers.add(this.definitionPatternMatcherFactory.createDefinitionPatternMatcher(key, de.getValue()));
                continue;
            }
            excludedKeys.add(key);
        }
        return PatternUtil.createExtractedMap(defsMap, excludedKeys);
    }
}

