/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.BlockingQueueBroker;
import org.apache.flink.streaming.runtime.io.RecordWriterOutput;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.OneInputStreamTask;
import org.apache.flink.streaming.runtime.tasks.mailbox.MailboxDefaultAction;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class StreamIterationHead<OUT>
extends OneInputStreamTask<OUT, OUT> {
    private static final Logger LOG = LoggerFactory.getLogger(StreamIterationHead.class);
    private RecordWriterOutput<OUT>[] streamOutputs;
    private final BlockingQueue<StreamRecord<OUT>> dataChannel;
    private final String brokerID;
    private final long iterationWaitTime;
    private final boolean shouldWait;

    public StreamIterationHead(Environment env) throws Exception {
        super(env);
        String iterationId = this.getConfiguration().getIterationId();
        if (iterationId == null || iterationId.length() == 0) {
            throw new FlinkRuntimeException("Missing iteration ID in the task configuration");
        }
        this.dataChannel = new ArrayBlockingQueue<StreamRecord<OUT>>(1);
        this.brokerID = StreamIterationHead.createBrokerIdString(this.getEnvironment().getJobID(), iterationId, this.getEnvironment().getTaskInfo().getIndexOfThisSubtask());
        this.iterationWaitTime = this.getConfiguration().getIterationWaitTime();
        this.shouldWait = this.iterationWaitTime > 0L;
    }

    @Override
    protected void processInput(MailboxDefaultAction.Controller controller) throws Exception {
        StreamRecord<OUT> nextRecord;
        StreamRecord<OUT> streamRecord = nextRecord = this.shouldWait ? this.dataChannel.poll(this.iterationWaitTime, TimeUnit.MILLISECONDS) : this.dataChannel.take();
        if (nextRecord != null) {
            for (RecordWriterOutput<OUT> output : this.streamOutputs) {
                output.collect(nextRecord);
            }
        } else {
            controller.suspendDefaultAction();
            this.mailboxProcessor.suspend();
        }
    }

    @Override
    public void init() {
        BlockingQueueBroker.INSTANCE.handIn(this.brokerID, this.dataChannel);
        LOG.info("Iteration head {} added feedback queue under {}", (Object)this.getName(), (Object)this.brokerID);
        this.streamOutputs = this.getStreamOutputs();
        if (this.isSerializingTimestamps()) {
            for (RecordWriterOutput<OUT> output : this.streamOutputs) {
                output.emitWatermark(new Watermark(Long.MAX_VALUE));
            }
        }
    }

    @Override
    protected void cleanUpInternal() {
        BlockingQueueBroker.INSTANCE.remove(this.brokerID);
        LOG.info("Iteration head {} removed feedback queue under {}", (Object)this.getName(), (Object)this.brokerID);
    }

    public static String createBrokerIdString(JobID jid, String iterationID, int subtaskIndex) {
        return jid + "-" + iterationID + "-" + subtaskIndex;
    }
}

