/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

public class WindowedTimeThrottler {
    long windowMillis;
    int maxAmt;
    long windowStartTime;
    int windowEvents = 0;

    public WindowedTimeThrottler(Number windowMillis, Number maxAmt) {
        this.windowMillis = windowMillis.longValue();
        this.maxAmt = maxAmt.intValue();
        this.windowStartTime = System.currentTimeMillis();
    }

    public boolean isThrottled() {
        this.resetIfNecessary();
        return this.windowEvents >= this.maxAmt;
    }

    public void markEvent() {
        this.resetIfNecessary();
        ++this.windowEvents;
    }

    private void resetIfNecessary() {
        long now = System.currentTimeMillis();
        if (now - this.windowStartTime > this.windowMillis) {
            this.windowStartTime = now;
            this.windowEvents = 0;
        }
    }
}

