/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler;

import java.util.Arrays;
import java.util.List;

public class WorkerSlot {
    private final String nodeId;
    private final int port;

    public WorkerSlot(String nodeId, Number port) {
        if (port == null) {
            throw new NullPointerException("port cannot be null");
        }
        if (nodeId == null) {
            throw new NullPointerException("node id cannot be null");
        }
        this.nodeId = nodeId;
        this.port = port.intValue();
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public int getPort() {
        return this.port;
    }

    public String getId() {
        return this.getNodeId() + ":" + this.getPort();
    }

    public List<Object> toList() {
        return Arrays.asList(this.nodeId, this.port);
    }

    public int hashCode() {
        return this.nodeId.hashCode() + 13 * Integer.valueOf(this.port).hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof WorkerSlot)) {
            return false;
        }
        WorkerSlot other = (WorkerSlot)o;
        return this.port == other.port && this.nodeId.equals(other.nodeId);
    }

    public String toString() {
        return this.getId();
    }
}

