/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.worker;

import com.codahale.metrics.Gauge;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.storm.messaging.netty.BackPressureStatus;
import org.apache.storm.metrics2.StormMetricRegistry;
import org.apache.storm.shade.org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.storm.shade.org.apache.commons.lang.builder.ToStringStyle;
import org.apache.storm.utils.JCQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackPressureTracker {
    static final Logger LOG = LoggerFactory.getLogger(BackPressureTracker.class);
    private final Map<Integer, BackpressureState> tasks;
    private final String workerId;

    public BackPressureTracker(String workerId, Map<Integer, JCQueue> localTasksToQueues, StormMetricRegistry metricRegistry, Map<Integer, String> taskToComponent) {
        this.workerId = workerId;
        this.tasks = localTasksToQueues.entrySet().stream().collect(Collectors.toMap(entry -> (Integer)entry.getKey(), entry -> new BackpressureState((JCQueue)entry.getValue(), (Integer)entry.getKey(), (String)taskToComponent.get(entry.getKey()), metricRegistry)));
    }

    public BackpressureState getBackpressureState(Integer taskId) {
        return this.tasks.get(taskId);
    }

    private void recordNoBackPressure(BackpressureState state) {
        state.backpressure.set(false);
    }

    public boolean recordBackPressure(BackpressureState state) {
        return !state.backpressure.getAndSet(true);
    }

    public boolean refreshBpTaskList() {
        boolean changed = false;
        LOG.debug("Running Back Pressure status change check");
        for (Map.Entry<Integer, BackpressureState> entry : this.tasks.entrySet()) {
            BackpressureState state = entry.getValue();
            if (!state.backpressure.get() || !state.queue.isEmptyOverflow()) continue;
            this.recordNoBackPressure(state);
            changed = true;
        }
        return changed;
    }

    public BackPressureStatus getCurrStatus() {
        ArrayList<Integer> bpTasks = new ArrayList<Integer>(this.tasks.size());
        ArrayList<Integer> nonBpTasks = new ArrayList<Integer>(this.tasks.size());
        for (Map.Entry<Integer, BackpressureState> entry : this.tasks.entrySet()) {
            if (entry.getKey() < 0) continue;
            boolean backpressure = entry.getValue().backpressure.get();
            if (backpressure) {
                bpTasks.add(entry.getKey());
                continue;
            }
            nonBpTasks.add(entry.getKey());
        }
        return new BackPressureStatus(this.workerId, bpTasks, nonBpTasks);
    }

    public int getLastOverflowCount(BackpressureState state) {
        return state.lastOverflowCount;
    }

    public void setLastOverflowCount(BackpressureState state, int value) {
        state.lastOverflowCount = value;
    }

    public static class BackpressureState {
        private final JCQueue queue;
        private final AtomicBoolean backpressure = new AtomicBoolean(false);
        private int lastOverflowCount = 0;

        BackpressureState(JCQueue queue, Integer taskId, String componentId, StormMetricRegistry metricRegistry) {
            this.queue = queue;
            if (taskId >= 0) {
                if (componentId == null) {
                    throw new RuntimeException("Missing componentId for task " + taskId);
                }
                Gauge<Integer> bpOverflowCount = new Gauge<Integer>(){

                    public Integer getValue() {
                        if (backpressure.get()) {
                            return Math.max(1, lastOverflowCount);
                        }
                        return 0;
                    }
                };
                metricRegistry.gauge("__backpressure-last-overflow-count", bpOverflowCount, componentId, taskId);
            }
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.queue).append((Object)this.backpressure).toString();
        }
    }
}

