/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.blobstore;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.TreeSet;
import org.apache.storm.blobstore.BlobStoreUtils;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.nimbus.NimbusInfo;
import org.apache.storm.shade.org.apache.curator.framework.CuratorFramework;
import org.apache.storm.shade.org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.storm.shade.org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.storm.shade.org.apache.zookeeper.CreateMode;
import org.apache.storm.shade.org.apache.zookeeper.KeeperException;
import org.apache.storm.shade.org.apache.zookeeper.ZooDefs;
import org.apache.storm.utils.WrappedKeyNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeySequenceNumber {
    private static final Logger LOG = LoggerFactory.getLogger(KeySequenceNumber.class);
    private static final String BLOBSTORE_MAX_KEY_SEQUENCE_SUBTREE = "/blobstoremaxkeysequencenumber";
    private final String key;
    private final NimbusInfo nimbusInfo;
    private static final int INT_CAPACITY = 4;
    private static final int INITIAL_SEQUENCE_NUMBER = 1;

    public KeySequenceNumber(String key, NimbusInfo nimbusInfo) {
        this.key = key;
        this.nimbusInfo = nimbusInfo;
    }

    public synchronized int getKeySequenceNumber(CuratorFramework zkClient) throws KeyNotFoundException {
        TreeSet<Integer> sequenceNumbers = new TreeSet<Integer>();
        try {
            if (zkClient.checkExists().forPath(BlobStoreUtils.getBlobStoreSubtree() + "/" + this.key) == null) {
                ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)zkClient.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).withACL((List)ZooDefs.Ids.OPEN_ACL_UNSAFE)).forPath("/blobstoremaxkeysequencenumber/" + this.key);
                zkClient.setData().forPath("/blobstoremaxkeysequencenumber/" + this.key, ByteBuffer.allocate(4).putInt(1).array());
                return 1;
            }
            List stateInfoList = (List)zkClient.getChildren().forPath(BlobStoreUtils.getBlobStoreSubtree() + "/" + this.key);
            LOG.debug("stateInfoList-size {} stateInfoList-data {}", (Object)stateInfoList.size(), (Object)stateInfoList);
            if (stateInfoList.isEmpty()) {
                return this.getMaxSequenceNumber(zkClient);
            }
            LOG.debug("stateInfoSize {}", (Object)stateInfoList.size());
            for (String stateInfo : stateInfoList) {
                sequenceNumbers.add(Integer.parseInt(BlobStoreUtils.normalizeNimbusHostPortSequenceNumberInfo(stateInfo).getSequenceNumber()));
            }
            int currentSeqNumber = this.getMaxSequenceNumber(zkClient);
            if (!this.checkIfStateContainsCurrentNimbusHost(stateInfoList, this.nimbusInfo) && !this.nimbusInfo.isLeader()) {
                if ((Integer)sequenceNumbers.last() < currentSeqNumber) {
                    return currentSeqNumber;
                }
                return 0;
            }
            if (!this.checkIfStateContainsCurrentNimbusHost(stateInfoList, this.nimbusInfo) && this.nimbusInfo.isLeader()) {
                this.incrementMaxSequenceNumber(zkClient, currentSeqNumber);
                return currentSeqNumber + 1;
            }
            if (sequenceNumbers.size() == 1) {
                if ((Integer)sequenceNumbers.first() < currentSeqNumber) {
                    this.incrementMaxSequenceNumber(zkClient, currentSeqNumber);
                    return currentSeqNumber + 1;
                }
                this.incrementMaxSequenceNumber(zkClient, currentSeqNumber);
                return (Integer)sequenceNumbers.first() + 1;
            }
            return (Integer)sequenceNumbers.last();
        }
        catch (KeeperException.NoNodeException e) {
            throw new WrappedKeyNotFoundException(this.key);
        }
        catch (Exception e) {
            LOG.error("Exception {}", (Throwable)e);
            return 0;
        }
    }

    private boolean checkIfStateContainsCurrentNimbusHost(List<String> stateInfoList, NimbusInfo nimbusInfo) {
        boolean containsNimbusHost = false;
        for (String stateInfo : stateInfoList) {
            if (!stateInfo.contains(nimbusInfo.getHost())) continue;
            containsNimbusHost = true;
            break;
        }
        return containsNimbusHost;
    }

    private void incrementMaxSequenceNumber(CuratorFramework zkClient, int count) throws Exception {
        zkClient.setData().forPath("/blobstoremaxkeysequencenumber/" + this.key, ByteBuffer.allocate(4).putInt(count + 1).array());
    }

    private int getMaxSequenceNumber(CuratorFramework zkClient) throws Exception {
        return ByteBuffer.wrap((byte[])zkClient.getData().forPath("/blobstoremaxkeysequencenumber/" + this.key)).getInt();
    }
}

