/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.ui;

import java.util.concurrent.TimeUnit;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

public final class UIUtils$ {
    public static final UIUtils$ MODULE$ = new UIUtils$();

    public String shortTimeUnitString(TimeUnit unit) {
        TimeUnit timeUnit = unit;
        if (((Object)((Object)TimeUnit.NANOSECONDS)).equals((Object)timeUnit)) {
            return "ns";
        }
        if (((Object)((Object)TimeUnit.MICROSECONDS)).equals((Object)timeUnit)) {
            return "us";
        }
        if (((Object)((Object)TimeUnit.MILLISECONDS)).equals((Object)timeUnit)) {
            return "ms";
        }
        if (((Object)((Object)TimeUnit.SECONDS)).equals((Object)timeUnit)) {
            return "sec";
        }
        if (((Object)((Object)TimeUnit.MINUTES)).equals((Object)timeUnit)) {
            return "min";
        }
        if (((Object)((Object)TimeUnit.HOURS)).equals((Object)timeUnit)) {
            return "hrs";
        }
        if (((Object)((Object)TimeUnit.DAYS)).equals((Object)timeUnit)) {
            return "days";
        }
        throw new MatchError((Object)timeUnit);
    }

    public Tuple2<Object, TimeUnit> normalizeDuration(long milliseconds) {
        if (milliseconds < 1000L) {
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)milliseconds), (Object)TimeUnit.MILLISECONDS);
        }
        double seconds = (double)milliseconds / (double)1000;
        if (seconds < (double)60) {
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)seconds), (Object)TimeUnit.SECONDS);
        }
        double minutes = seconds / (double)60;
        if (minutes < (double)60) {
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)minutes), (Object)TimeUnit.MINUTES);
        }
        double hours = minutes / (double)60;
        if (hours < (double)24) {
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)hours), (Object)TimeUnit.HOURS);
        }
        double days = hours / (double)24;
        return new Tuple2((Object)BoxesRunTime.boxToDouble((double)days), (Object)TimeUnit.DAYS);
    }

    public double convertToTimeUnit(long milliseconds, TimeUnit unit) {
        TimeUnit timeUnit = unit;
        if (((Object)((Object)TimeUnit.NANOSECONDS)).equals((Object)timeUnit)) {
            return (double)milliseconds * (double)1000 * (double)1000;
        }
        if (((Object)((Object)TimeUnit.MICROSECONDS)).equals((Object)timeUnit)) {
            return (double)milliseconds * (double)1000;
        }
        if (((Object)((Object)TimeUnit.MILLISECONDS)).equals((Object)timeUnit)) {
            return milliseconds;
        }
        if (((Object)((Object)TimeUnit.SECONDS)).equals((Object)timeUnit)) {
            return (double)milliseconds / 1000.0;
        }
        if (((Object)((Object)TimeUnit.MINUTES)).equals((Object)timeUnit)) {
            return (double)milliseconds / 1000.0 / 60.0;
        }
        if (((Object)((Object)TimeUnit.HOURS)).equals((Object)timeUnit)) {
            return (double)milliseconds / 1000.0 / 60.0 / 60.0;
        }
        if (((Object)((Object)TimeUnit.DAYS)).equals((Object)timeUnit)) {
            return (double)milliseconds / 1000.0 / 60.0 / 60.0 / 24.0;
        }
        throw new MatchError((Object)timeUnit);
    }

    public String createOutputOperationFailureForUI(String failure) {
        if (failure.startsWith("org.apache.spark.Spark")) {
            return "Failed due to Spark job error\n" + failure;
        }
        int nextLineIndex = failure.indexOf("\n");
        if (nextLineIndex < 0) {
            nextLineIndex = failure.length();
        }
        String firstLine = failure.substring(0, nextLineIndex);
        return "Failed due to error: " + firstLine + "\n" + failure;
    }

    public scala.collection.immutable.Seq<Node> failureReasonCell(String failureReason, int rowspan, boolean includeFirstLineInExpandDetails) {
        Tuple2 tuple2 = org.apache.spark.ui.UIUtils$.MODULE$.errorSummary(failureReason);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String failureReasonSummary = (String)tuple2._1();
        boolean isMultiline = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)failureReasonSummary, (Object)BoxesRunTime.boxToBoolean((boolean)isMultiline));
        String failureReasonSummary2 = (String)tuple22._1();
        boolean isMultiline2 = tuple22._2$mcZ$sp();
        String failureDetails = isMultiline2 && !includeFirstLineInExpandDetails ? failureReason.substring(failureReason.indexOf(10) + 1) : failureReason;
        scala.collection.immutable.Seq details = org.apache.spark.ui.UIUtils$.MODULE$.detailsUINode(isMultiline2, failureDetails);
        if (rowspan == 1) {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("style", (Seq)new Text("max-width: 300px"), (MetaData)$md);
            $md = new UnprefixedAttribute("valign", (Seq)new Text("middle"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)failureReasonSummary2);
            $buf.$amp$plus((Object)details);
            return new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
        }
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("rowspan", Integer.toString(rowspan), (MetaData)$md);
        $md = new UnprefixedAttribute("style", (Seq)new Text("max-width: 300px"), (MetaData)$md);
        $md = new UnprefixedAttribute("valign", (Seq)new Text("middle"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus((Object)failureReasonSummary2);
        $buf.$amp$plus((Object)details);
        $buf.$amp$plus((Object)new Text("\n      "));
        return new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
    }

    public int failureReasonCell$default$2() {
        return 1;
    }

    public boolean failureReasonCell$default$3() {
        return true;
    }

    private UIUtils$() {
    }
}

