/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1alpha3;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.resource.v1alpha3.DeviceSelector;
import io.fabric8.kubernetes.api.model.resource.v1alpha3.DeviceSelectorBuilder;
import io.fabric8.kubernetes.api.model.resource.v1alpha3.DeviceSelectorFluent;
import io.fabric8.kubernetes.api.model.resource.v1alpha3.DeviceTaintSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DeviceTaintSelectorFluent<A extends DeviceTaintSelectorFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String device;
    private String deviceClassName;
    private String driver;
    private String pool;
    private ArrayList<DeviceSelectorBuilder> selectors = new ArrayList();

    public DeviceTaintSelectorFluent() {
    }

    public DeviceTaintSelectorFluent(DeviceTaintSelector instance) {
        this.copyInstance(instance);
    }

    public A addAllToSelectors(Collection<DeviceSelector> items) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        for (DeviceSelector item : items) {
            DeviceSelectorBuilder builder = new DeviceSelectorBuilder(item);
            this._visitables.get((Object)"selectors").add(builder);
            this.selectors.add(builder);
        }
        return (A)((Object)this);
    }

    public SelectorsNested<A> addNewSelector() {
        return new SelectorsNested(-1, null);
    }

    public SelectorsNested<A> addNewSelectorLike(DeviceSelector item) {
        return new SelectorsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToSelectors(DeviceSelector ... items) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        for (DeviceSelector item : items) {
            DeviceSelectorBuilder builder = new DeviceSelectorBuilder(item);
            this._visitables.get((Object)"selectors").add(builder);
            this.selectors.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToSelectors(int index, DeviceSelector item) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        DeviceSelectorBuilder builder = new DeviceSelectorBuilder(item);
        if (index < 0 || index >= this.selectors.size()) {
            this._visitables.get((Object)"selectors").add(builder);
            this.selectors.add(builder);
        } else {
            this._visitables.get((Object)"selectors").add(builder);
            this.selectors.add(index, builder);
        }
        return (A)((Object)this);
    }

    public DeviceSelector buildFirstSelector() {
        return this.selectors.get(0).build();
    }

    public DeviceSelector buildLastSelector() {
        return this.selectors.get(this.selectors.size() - 1).build();
    }

    public DeviceSelector buildMatchingSelector(Predicate<DeviceSelectorBuilder> predicate) {
        for (DeviceSelectorBuilder item : this.selectors) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public DeviceSelector buildSelector(int index) {
        return this.selectors.get(index).build();
    }

    public List<DeviceSelector> buildSelectors() {
        return this.selectors != null ? DeviceTaintSelectorFluent.build(this.selectors) : null;
    }

    protected void copyInstance(DeviceTaintSelector instance) {
        DeviceTaintSelector deviceTaintSelector = instance = instance != null ? instance : new DeviceTaintSelector();
        if (instance != null) {
            this.withDevice(instance.getDevice());
            this.withDeviceClassName(instance.getDeviceClassName());
            this.withDriver(instance.getDriver());
            this.withPool(instance.getPool());
            this.withSelectors(instance.getSelectors());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public SelectorsNested<A> editFirstSelector() {
        if (this.selectors.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "selectors"));
        }
        return this.setNewSelectorLike(0, this.buildSelector(0));
    }

    public SelectorsNested<A> editLastSelector() {
        int index = this.selectors.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "selectors"));
        }
        return this.setNewSelectorLike(index, this.buildSelector(index));
    }

    public SelectorsNested<A> editMatchingSelector(Predicate<DeviceSelectorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.selectors.size(); ++i) {
            if (!predicate.test(this.selectors.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "selectors"));
        }
        return this.setNewSelectorLike(index, this.buildSelector(index));
    }

    public SelectorsNested<A> editSelector(int index) {
        if (this.selectors.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "selectors"));
        }
        return this.setNewSelectorLike(index, this.buildSelector(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeviceTaintSelectorFluent that = (DeviceTaintSelectorFluent)((Object)o);
        if (!Objects.equals(this.device, that.device)) {
            return false;
        }
        if (!Objects.equals(this.deviceClassName, that.deviceClassName)) {
            return false;
        }
        if (!Objects.equals(this.driver, that.driver)) {
            return false;
        }
        if (!Objects.equals(this.pool, that.pool)) {
            return false;
        }
        if (!Objects.equals(this.selectors, that.selectors)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getDevice() {
        return this.device;
    }

    public String getDeviceClassName() {
        return this.deviceClassName;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getPool() {
        return this.pool;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasDevice() {
        return this.device != null;
    }

    public boolean hasDeviceClassName() {
        return this.deviceClassName != null;
    }

    public boolean hasDriver() {
        return this.driver != null;
    }

    public boolean hasMatchingSelector(Predicate<DeviceSelectorBuilder> predicate) {
        for (DeviceSelectorBuilder item : this.selectors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPool() {
        return this.pool != null;
    }

    public boolean hasSelectors() {
        return this.selectors != null && !this.selectors.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.device, this.deviceClassName, this.driver, this.pool, this.selectors, this.additionalProperties);
    }

    public A removeAllFromSelectors(Collection<DeviceSelector> items) {
        if (this.selectors == null) {
            return (A)((Object)this);
        }
        for (DeviceSelector item : items) {
            DeviceSelectorBuilder builder = new DeviceSelectorBuilder(item);
            this._visitables.get((Object)"selectors").remove((Object)builder);
            this.selectors.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromSelectors(DeviceSelector ... items) {
        if (this.selectors == null) {
            return (A)((Object)this);
        }
        for (DeviceSelector item : items) {
            DeviceSelectorBuilder builder = new DeviceSelectorBuilder(item);
            this._visitables.get((Object)"selectors").remove((Object)builder);
            this.selectors.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSelectors(Predicate<DeviceSelectorBuilder> predicate) {
        if (this.selectors == null) {
            return (A)((Object)this);
        }
        Iterator<DeviceSelectorBuilder> each = this.selectors.iterator();
        List visitables = this._visitables.get((Object)"selectors");
        while (each.hasNext()) {
            DeviceSelectorBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public SelectorsNested<A> setNewSelectorLike(int index, DeviceSelector item) {
        return new SelectorsNested(index, item);
    }

    public A setToSelectors(int index, DeviceSelector item) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        DeviceSelectorBuilder builder = new DeviceSelectorBuilder(item);
        if (index < 0 || index >= this.selectors.size()) {
            this._visitables.get((Object)"selectors").add(builder);
            this.selectors.add(builder);
        } else {
            this._visitables.get((Object)"selectors").add(builder);
            this.selectors.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.device != null) {
            sb.append("device:");
            sb.append(this.device);
            sb.append(",");
        }
        if (this.deviceClassName != null) {
            sb.append("deviceClassName:");
            sb.append(this.deviceClassName);
            sb.append(",");
        }
        if (this.driver != null) {
            sb.append("driver:");
            sb.append(this.driver);
            sb.append(",");
        }
        if (this.pool != null) {
            sb.append("pool:");
            sb.append(this.pool);
            sb.append(",");
        }
        if (this.selectors != null && !this.selectors.isEmpty()) {
            sb.append("selectors:");
            sb.append(this.selectors);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withDevice(String device) {
        this.device = device;
        return (A)((Object)this);
    }

    public A withDeviceClassName(String deviceClassName) {
        this.deviceClassName = deviceClassName;
        return (A)((Object)this);
    }

    public A withDriver(String driver) {
        this.driver = driver;
        return (A)((Object)this);
    }

    public A withPool(String pool) {
        this.pool = pool;
        return (A)((Object)this);
    }

    public A withSelectors(List<DeviceSelector> selectors) {
        if (this.selectors != null) {
            this._visitables.get((Object)"selectors").clear();
        }
        if (selectors != null) {
            this.selectors = new ArrayList();
            for (DeviceSelector item : selectors) {
                this.addToSelectors(item);
            }
        } else {
            this.selectors = null;
        }
        return (A)((Object)this);
    }

    public A withSelectors(DeviceSelector ... selectors) {
        if (this.selectors != null) {
            this.selectors.clear();
            this._visitables.remove((Object)"selectors");
        }
        if (selectors != null) {
            for (DeviceSelector item : selectors) {
                this.addToSelectors(item);
            }
        }
        return (A)((Object)this);
    }

    public class SelectorsNested<N>
    extends DeviceSelectorFluent<SelectorsNested<N>>
    implements Nested<N> {
        DeviceSelectorBuilder builder;
        int index;

        SelectorsNested(int index, DeviceSelector item) {
            this.index = index;
            this.builder = new DeviceSelectorBuilder(this, item);
        }

        public N and() {
            return (N)DeviceTaintSelectorFluent.this.setToSelectors(this.index, this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }
}

