/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import java.io.Serializable;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.SparkRuntimeException$;
import org.apache.spark.annotation.Unstable;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.EdgeInterpolationAlgorithm;
import org.apache.spark.sql.types.EdgeInterpolationAlgorithm$SPHERICAL$;
import org.apache.spark.sql.types.GeographyType$;
import org.json4s.JString;
import org.json4s.JValue;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@Unstable
@ScalaSignature(bytes="\u0006\u0005\u0005mg\u0001B\u0015+\u0001UB\u0001\u0002\u0013\u0001\u0003\u0006\u0004%\t!\u0013\u0005\t%\u0002\u0011\t\u0011)A\u0005\u0015\"A1\u000b\u0001BC\u0002\u0013\u0005A\u000b\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003V\u0011\u0015I\u0006\u0001\"\u0003[\u0011\u001dq\u0006A1A\u0005\u0002}Ca\u0001\u001a\u0001!\u0002\u0013\u0001\u0007\"B3\u0001\t\u0003z\u0006\"\u00024\u0001\t\u00039\u0007\"B6\u0001\t\u0003J\u0005\"\u00027\u0001\t\u0003j\u0007\"\u00028\u0001\t\u0003z\u0007BB?\u0001\t\u0003rc\u0010\u0003\u0004\u0000\u0001\u0011\u0005\u0013\u0011\u0001\u0005\b\u0003\u001b\u0001A\u0011IA\b\u0011!\t\t\u0002\u0001C!Y\u0005M\u0001bBA\u0010\u0001\u0011\u0005\u0011\u0011\u0005\u0005\t\u0003O\u0001A\u0011\u0001\u0017\u0002*\u001d9\u00111\t\u0016\t\u0002\u0005\u0015cAB\u0015+\u0011\u0003\t9\u0005\u0003\u0004Z)\u0011\u0005\u00111\r\u0005\n\u0003K\"\"\u0019!C\u0003\u0003OB\u0001\"!\u001c\u0015A\u00035\u0011\u0011\u000e\u0005\n\u0003_\"\"\u0019!C\u0003\u0003cB\u0001\"!\u001f\u0015A\u00035\u00111\u000f\u0005\n\u0003w\"\"\u0019!C\u0003\u0003{B\u0001\"!$\u0015A\u00035\u0011q\u0010\u0005\n\u0003\u001f#\"\u0019!C\u0003\u0003#C\u0001\"!(\u0015A\u00035\u00111\u0013\u0005\n\u0003?#\u0002R1A\u0005\u000eyDq!!)\u0015\t\u0003\t\u0019\u000bC\u0004\u0002(R!\t!!+\t\u000f\u0005\u001dF\u0003\"\u0001\u0002.\"9\u0011q\u0015\u000b\u0005\u0002\u0005E\u0006bBAT)\u0011\u0005\u0011q\u0017\u0005\t\u0003{#B\u0011\t\u0017\u0002@\"A\u0011\u0011\u0003\u000b\u0005B1\n\t\rC\u0004\u0002FR!\t\u0005L%\t\u0011\u0005\u001dG\u0003\"\u0001+\u0003\u0013D\u0011\"!4\u0015\u0003\u0003%I!a4\u0003\u001b\u001d+wn\u001a:ba\"LH+\u001f9f\u0015\tYC&A\u0003usB,7O\u0003\u0002.]\u0005\u00191/\u001d7\u000b\u0005=\u0002\u0014!B:qCJ\\'BA\u00193\u0003\u0019\t\u0007/Y2iK*\t1'A\u0002pe\u001e\u001c\u0001aE\u0002\u0001mi\u0002\"a\u000e\u001d\u000e\u0003)J!!\u000f\u0016\u0003\u0015\u0005#x.\\5d)f\u0004X\r\u0005\u0002<\u000b:\u0011AH\u0011\b\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007fQ\na\u0001\u0010:p_Rt\u0014\"A!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r#\u0015a\u00029bG.\fw-\u001a\u0006\u0002\u0003&\u0011ai\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u0007\u0012\u000b1a\u0019:t+\u0005Q\u0005CA&P\u001d\taU\n\u0005\u0002>\t&\u0011a\nR\u0001\u0007!J,G-\u001a4\n\u0005A\u000b&AB*ue&twM\u0003\u0002O\t\u0006!1M]:!\u0003%\tGnZ8sSRDW.F\u0001V!\t9d+\u0003\u0002XU\tQR\tZ4f\u0013:$XM\u001d9pY\u0006$\u0018n\u001c8BY\u001e|'/\u001b;i[\u0006Q\u0011\r\\4pe&$\b.\u001c\u0011\u0002\rqJg.\u001b;?)\rYF,\u0018\t\u0003o\u0001AQ\u0001S\u0003A\u0002)CQaU\u0003A\u0002U\u000bAa\u001d:jIV\t\u0001\r\u0005\u0002bE6\tA)\u0003\u0002d\t\n\u0019\u0011J\u001c;\u0002\u000bM\u0014\u0018\u000e\u001a\u0011\u0002\u0017\u0011,g-Y;miNK'0Z\u0001\fSNl\u0015\u000e_3e'JLG-F\u0001i!\t\t\u0017.\u0003\u0002k\t\n9!i\\8mK\u0006t\u0017\u0001\u0003;za\u0016t\u0015-\\3\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012AS\u0001\nUN|gNV1mk\u0016,\u0012\u0001\u001d\t\u0003cjt!A]<\u000f\u0005M,hBA\u001fu\u0013\u0005\u0019\u0014B\u0001<3\u0003\u0019Q7o\u001c85g&\u0011\u00010_\u0001\b\u0015N|g.Q*U\u0015\t1('\u0003\u0002|y\n1!JV1mk\u0016T!\u0001_=\u0002\u0015\u0005\u001ch*\u001e7mC\ndW-F\u0001\\\u0003\u0019)\u0017/^1mgR\u0019\u0001.a\u0001\t\u000f\u0005\u0015a\u00021\u0001\u0002\b\u0005\u0019qN\u00196\u0011\u0007\u0005\fI!C\u0002\u0002\f\u0011\u00131!\u00118z\u0003!A\u0017m\u001d5D_\u0012,G#\u00011\u0002\u0017\u0005\u001c7-\u001a9ugRK\b/\u001a\u000b\u0004Q\u0006U\u0001bBA\f!\u0001\u0007\u0011\u0011D\u0001\u0006_RDWM\u001d\t\u0004o\u0005m\u0011bAA\u000fU\tAA)\u0019;b)f\u0004X-\u0001\u000bbG\u000e,\u0007\u000f^:HK><'/\u00199isRK\b/\u001a\u000b\u0004Q\u0006\r\u0002BBA\u0013#\u0001\u00071,\u0001\u0002hi\u0006A\u0012m]:feR\u001c&/\u001b3BY2|w/\u001a3G_J$\u0016\u0010]3\u0015\t\u0005-\u0012\u0011\u0007\t\u0004C\u00065\u0012bAA\u0018\t\n!QK\\5u\u0011\u0019\t\u0019D\u0005a\u0001A\u0006Iq\u000e\u001e5feN\u0013\u0018\u000e\u001a\u0015\u0004\u0001\u0005]\u0002\u0003BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\u0005ub&\u0001\u0006b]:|G/\u0019;j_:LA!!\u0011\u0002<\tAQK\\:uC\ndW-A\u0007HK><'/\u00199isRK\b/\u001a\t\u0003oQ\u0019r\u0001FA%\u0003\u001f\n)\u0006E\u00028\u0003\u0017J1!!\u0014+\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X\rE\u00028\u0003#J1!a\u0015+\u0005-\u0019\u0006/\u0019;jC2$\u0016\u0010]3\u0011\t\u0005]\u0013\u0011M\u0007\u0003\u00033RA!a\u0017\u0002^\u0005\u0011\u0011n\u001c\u0006\u0003\u0003?\nAA[1wC&\u0019a)!\u0017\u0015\u0005\u0005\u0015\u0013AF$F\u001f\u001e\u0013\u0016\t\u0015%Z?\u0012+e)Q+M)~\u001b&+\u0013#\u0016\u0005\u0005%tBAA6;\t\u0001b=A\fH\u000b>;%+\u0011)I3~#UIR!V\u0019R{6KU%EA\u0005)r)R(H%\u0006\u0003\u0006*W0E\u000b\u001a\u000bU\u000b\u0014+`\u0007J\u001bVCAA:\u001f\t\t)(\t\u0002\u0002x\u0005IqjR\";\u0007J\u001b\u0006\bN\u0001\u0017\u000f\u0016{uIU!Q\u0011f{F)\u0012$B+2#vl\u0011*TA\u0005Yr)R(H%\u0006\u0003\u0006*W0E\u000b\u001a\u000bU\u000b\u0014+`\u00032;uJU%U\u00116+\"!a \u000f\t\u0005\u0005\u0015q\u0011\b\u0004o\u0005\r\u0015bAACU\u0005QR\tZ4f\u0013:$XM\u001d9pY\u0006$\u0018n\u001c8BY\u001e|'/\u001b;i[&!\u0011\u0011RAF\u0003%\u0019\u0006\u000bS#S\u0013\u000e\u000bEJC\u0002\u0002\u0006*\nAdR#P\u000fJ\u000b\u0005\u000bS-`\t\u00163\u0015)\u0016'U?\u0006cui\u0014*J)\"k\u0005%\u0001\u000eH\u000b>;%+\u0011)I3~#UIR!V\u0019R{V\tU*H?\u000e\u00136+\u0006\u0002\u0002\u0014B!\u0011QSAN\u001b\t\t9J\u0003\u0003\u0002\u001a\u0006u\u0013\u0001\u00027b]\u001eL1\u0001UAL\u0003m9UiT$S\u0003BC\u0015l\u0018#F\r\u0006+F\nV0F!N;ul\u0011*TA\u0005!r)R(H%\u0006\u0003\u0006*W0N\u0013b+Ei\u0018+Z!\u0016\u000bq\"[:Te&$7+\u001e9q_J$X\r\u001a\u000b\u0004Q\u0006\u0015\u0006\"\u00020 \u0001\u0004\u0001\u0017!B1qa2LHcA.\u0002,\")a\f\ta\u0001AR\u00191,a,\t\u000b!\u000b\u0003\u0019\u0001&\u0015\u000bm\u000b\u0019,!.\t\u000b!\u0013\u0003\u0019\u0001&\t\u000bM\u0013\u0003\u0019\u0001&\u0015\u000bm\u000bI,a/\t\u000b!\u001b\u0003\u0019\u0001&\t\u000bM\u001b\u0003\u0019A+\u0002'\u0011,g-Y;mi\u000e{gn\u0019:fi\u0016$\u0016\u0010]3\u0016\u0005\u0005eAc\u00015\u0002D\"9\u0011qC\u0013A\u0002\u0005e\u0011\u0001D:j[BdWm\u0015;sS:<\u0017A\u0002;p'JLG\rF\u0002a\u0003\u0017DQ\u0001S\u0014A\u0002)\u000bAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!!5\u0011\t\u0005U\u00151[\u0005\u0005\u0003+\f9J\u0001\u0004PE*,7\r\u001e\u0015\u0004)\u0005]\u0002fA\n\u00028\u0001")
public class GeographyType
extends AtomicType
implements Serializable {
    private final String crs;
    private final EdgeInterpolationAlgorithm algorithm;
    private final int srid;

    public static GeographyType apply(String crs, EdgeInterpolationAlgorithm algorithm) {
        return GeographyType$.MODULE$.apply(crs, algorithm);
    }

    public static GeographyType apply(String crs, String algorithm) {
        return GeographyType$.MODULE$.apply(crs, algorithm);
    }

    public static GeographyType apply(String crs) {
        return GeographyType$.MODULE$.apply(crs);
    }

    public static GeographyType apply(int srid) {
        return GeographyType$.MODULE$.apply(srid);
    }

    public static boolean isSridSupported(int srid) {
        return GeographyType$.MODULE$.isSridSupported(srid);
    }

    public static String GEOGRAPHY_DEFAULT_EPSG_CRS() {
        return GeographyType$.MODULE$.GEOGRAPHY_DEFAULT_EPSG_CRS();
    }

    public static EdgeInterpolationAlgorithm$SPHERICAL$ GEOGRAPHY_DEFAULT_ALGORITHM() {
        return GeographyType$.MODULE$.GEOGRAPHY_DEFAULT_ALGORITHM();
    }

    public static String GEOGRAPHY_DEFAULT_CRS() {
        return GeographyType$.MODULE$.GEOGRAPHY_DEFAULT_CRS();
    }

    public static int GEOGRAPHY_DEFAULT_SRID() {
        return GeographyType$.MODULE$.GEOGRAPHY_DEFAULT_SRID();
    }

    public static String MIXED_CRS() {
        return GeographyType$.MODULE$.MIXED_CRS();
    }

    public static int MIXED_SRID() {
        return GeographyType$.MODULE$.MIXED_SRID();
    }

    public String crs() {
        return this.crs;
    }

    public EdgeInterpolationAlgorithm algorithm() {
        return this.algorithm;
    }

    public int srid() {
        return this.srid;
    }

    @Override
    public int defaultSize() {
        return 2048;
    }

    public boolean isMixedSrid() {
        return this.srid() == GeographyType$.MODULE$.MIXED_SRID();
    }

    @Override
    public String typeName() {
        if (this.isMixedSrid()) {
            return "geography(any)";
        }
        return "geography(" + this.srid() + ")";
    }

    public String toString() {
        if (this.isMixedSrid()) {
            return "GeographyType(ANY)";
        }
        return "GeographyType(" + this.srid() + ")";
    }

    @Override
    public JValue jsonValue() {
        return new JString("geography(" + this.crs() + ", " + this.algorithm() + ")");
    }

    @Override
    public GeographyType asNullable() {
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof GeographyType)) return false;
        GeographyType geographyType = (GeographyType)object;
        if (geographyType.srid() != this.srid()) return false;
        EdgeInterpolationAlgorithm edgeInterpolationAlgorithm = geographyType.algorithm();
        EdgeInterpolationAlgorithm edgeInterpolationAlgorithm2 = this.algorithm();
        if (edgeInterpolationAlgorithm != null) {
            if (!edgeInterpolationAlgorithm.equals(edgeInterpolationAlgorithm2)) return false;
            return true;
        }
        if (edgeInterpolationAlgorithm2 == null) return true;
        return false;
    }

    public int hashCode() {
        return Integer.hashCode(this.srid());
    }

    @Override
    public boolean acceptsType(DataType other) {
        DataType dataType = other;
        if (dataType instanceof GeographyType) {
            GeographyType geographyType = (GeographyType)dataType;
            return this.acceptsGeographyType(geographyType);
        }
        return false;
    }

    public boolean acceptsGeographyType(GeographyType gt) {
        return this.isMixedSrid() || gt.srid() == this.srid();
    }

    public void assertSridAllowedForType(int otherSrid) {
        if (!this.isMixedSrid() && otherSrid != this.srid()) {
            throw new SparkRuntimeException("GEO_ENCODER_SRID_MISMATCH_ERROR", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"GEOGRAPHY"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueSrid"), (Object)Integer.toString(otherSrid)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typeSrid"), (Object)Integer.toString(this.srid()))})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
        }
        if (this.isMixedSrid()) {
            if (!GeographyType$.MODULE$.isSridSupported(otherSrid)) {
                throw new SparkIllegalArgumentException("ST_INVALID_SRID_VALUE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srid"), (Object)Integer.toString(otherSrid))})));
            }
            return;
        }
    }

    public GeographyType(String crs, EdgeInterpolationAlgorithm algorithm) {
        this.crs = crs;
        this.algorithm = algorithm;
        this.srid = GeographyType$.MODULE$.toSrid(crs);
    }
}

