/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.state.ArrayIndexRange;
import org.apache.spark.sql.execution.streaming.state.KeyValueChecksum$;
import org.apache.spark.sql.execution.streaming.state.KeyValueChecksumVerifier$;
import org.apache.spark.sql.execution.streaming.state.KeyValueIntegrityVerifier;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.execution.streaming.state.StateStoreRowWithChecksum;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowWrapper;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005c\u0001B\u000b\u0017\u0001\u0015B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\")a\t\u0001C\u0001\u000f\"91\n\u0001a\u0001\n\u0013a\u0005bB'\u0001\u0001\u0004%IA\u0014\u0005\u0007)\u0002\u0001\u000b\u0015B\"\t\u000fe\u0003\u0001\u0019!C\u0005\u0019\"9!\f\u0001a\u0001\n\u0013Y\u0006BB/\u0001A\u0003&1\tC\u0003`\u0001\u0011\u0005A\nC\u0003a\u0001\u0011\u0005A\nC\u0003b\u0001\u0011%!\rC\u0003g\u0001\u0011\u0005s\rC\u0003g\u0001\u0011\u0005s\u000f\u0003\u0004g\u0001\u0011\u0005\u0013Q\u0003\u0005\b\u0003K\u0001A\u0011BA\u0014\u000f\u001d\t\tD\u0006E\u0001\u0003g1a!\u0006\f\t\u0002\u0005U\u0002B\u0002$\u0013\t\u0003\t9\u0004C\u0004\u0002:I!\t!a\u000f\u00031-+\u0017PV1mk\u0016\u001c\u0005.Z2lgVlg+\u001a:jM&,'O\u0003\u0002\u00181\u0005)1\u000f^1uK*\u0011\u0011DG\u0001\ngR\u0014X-Y7j]\u001eT!a\u0007\u000f\u0002\u0013\u0015DXmY;uS>t'BA\u000f\u001f\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003?\u0001\nQa\u001d9be.T!!\t\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0013aA8sO\u000e\u00011\u0003\u0002\u0001'YA\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012a!\u00118z%\u00164\u0007CA\u0017/\u001b\u00051\u0012BA\u0018\u0017\u0005eYU-\u001f,bYV,\u0017J\u001c;fOJLG/\u001f,fe&4\u0017.\u001a:\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005Mr\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005U\u0012$a\u0002'pO\u001eLgnZ\u0001\bgR|'/Z%e!\tAtH\u0004\u0002:{A\u0011!\bK\u0007\u0002w)\u0011A\bJ\u0001\u0007yI|w\u000e\u001e \n\u0005yB\u0013A\u0002)sK\u0012,g-\u0003\u0002A\u0003\n11\u000b\u001e:j]\u001eT!A\u0010\u0015\u0002#Y,'/\u001b4jG\u0006$\u0018n\u001c8SCRLw\u000e\u0005\u0002(\t&\u0011Q\t\u000b\u0002\u0005\u0019>tw-\u0001\u0004=S:LGO\u0010\u000b\u0004\u0011&S\u0005CA\u0017\u0001\u0011\u001514\u00011\u00018\u0011\u0015\u00115\u00011\u0001D\u0003-qW/\u001c*fcV,7\u000f^:\u0016\u0003\r\u000bqB\\;n%\u0016\fX/Z:ug~#S-\u001d\u000b\u0003\u001fJ\u0003\"a\n)\n\u0005EC#\u0001B+oSRDqaU\u0003\u0002\u0002\u0003\u00071)A\u0002yIE\nAB\\;n%\u0016\fX/Z:ug\u0002B#A\u0002,\u0011\u0005\u001d:\u0016B\u0001-)\u0005!1x\u000e\\1uS2,\u0017a\u00038v[Z+'/\u001b4jK\u0012\fqB\\;n-\u0016\u0014\u0018NZ5fI~#S-\u001d\u000b\u0003\u001frCqa\u0015\u0005\u0002\u0002\u0003\u00071)\u0001\u0007ok64VM]5gS\u0016$\u0007\u0005\u000b\u0002\n-\u0006qq-\u001a;Ok6\u0014V-];fgR\u001c\u0018AD4fi:+XNV3sS\u001aLW\rZ\u0001\rg\"|W\u000f\u001c3WKJLg-\u001f\u000b\u0002GB\u0011q\u0005Z\u0005\u0003K\"\u0012qAQ8pY\u0016\fg.\u0001\u0004wKJLg-\u001f\u000b\u0004\u001f\"\u0014\b\"B5\u000e\u0001\u0004Q\u0017aA6fsB\u00111\u000e]\u0007\u0002Y*\u0011QN\\\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002p9\u0005A1-\u0019;bYf\u001cH/\u0003\u0002rY\nIQK\\:bM\u0016\u0014vn\u001e\u0005\u0006g6\u0001\r\u0001^\u0001\u0006m\u0006dW/\u001a\t\u0003[UL!A\u001e\f\u0003!Us7/\u00194f%><xK]1qa\u0016\u0014HCB(y\u0003\u0003\tY\u0001C\u0003z\u001d\u0001\u0007!0\u0001\u0005lKf\u0014\u0015\u0010^3t!\r930`\u0005\u0003y\"\u0012Q!\u0011:sCf\u0004\"a\n@\n\u0005}D#\u0001\u0002\"zi\u0016Dq!a\u0001\u000f\u0001\u0004\t)!\u0001\u0006wC2,XMQ=uKN\u0004BaJA\u0004u&\u0019\u0011\u0011\u0002\u0015\u0003\r=\u0003H/[8o\u0011\u001d\tiA\u0004a\u0001\u0003\u001f\t\u0001#\u001a=qK\u000e$X\rZ\"iK\u000e\\7/^7\u0011\u0007\u001d\n\t\"C\u0002\u0002\u0014!\u00121!\u00138u)\u001dy\u0015qCA\u0010\u0003GAa!_\bA\u0002\u0005e\u0001\u0003B\u0017\u0002\u001cuL1!!\b\u0017\u0005=\t%O]1z\u0013:$W\r\u001f*b]\u001e,\u0007bBA\u0002\u001f\u0001\u0007\u0011\u0011\u0005\t\u0006O\u0005\u001d\u0011\u0011\u0004\u0005\b\u0003\u001by\u0001\u0019AA\b\u000391XM]5gs\u000eCWmY6tk6$RaTA\u0015\u0003[Aq!a\u000b\u0011\u0001\u0004\ty!\u0001\u0005fqB,7\r^3e\u0011\u001d\ty\u0003\u0005a\u0001\u0003\u001f\t\u0001bY8naV$X\rZ\u0001\u0019\u0017\u0016Lh+\u00197vK\u000eCWmY6tk64VM]5gS\u0016\u0014\bCA\u0017\u0013'\t\u0011b\u0005\u0006\u0002\u00024\u0005)\u0011\r\u001d9msR)\u0001*!\u0010\u0002@!)a\u0007\u0006a\u0001o!)!\t\u0006a\u0001\u0007\u0002")
public class KeyValueChecksumVerifier
implements KeyValueIntegrityVerifier,
Logging {
    private final String storeId;
    private final long verificationRatio;
    private volatile long numRequests;
    private volatile long numVerified;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static KeyValueChecksumVerifier apply(String storeId, long verificationRatio) {
        return KeyValueChecksumVerifier$.MODULE$.apply(storeId, verificationRatio);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private long numRequests() {
        return this.numRequests;
    }

    private void numRequests_$eq(long x$1) {
        this.numRequests = x$1;
    }

    private long numVerified() {
        return this.numVerified;
    }

    private void numVerified_$eq(long x$1) {
        this.numVerified = x$1;
    }

    public long getNumRequests() {
        return this.numRequests();
    }

    public long getNumVerified() {
        return this.numVerified();
    }

    private boolean shouldVerify() {
        this.numRequests_$eq(this.numRequests() + 1L);
        if (this.numRequests() % this.verificationRatio == 0L) {
            this.numVerified_$eq(this.numVerified() + 1L);
            return true;
        }
        return false;
    }

    @Override
    public void verify(UnsafeRow key, UnsafeRowWrapper value) {
        Predef$.MODULE$.assert(value instanceof StateStoreRowWithChecksum, (Function0 & Serializable)() -> "Expected StateStoreRowWithChecksum, but got " + value.getClass().getName());
        if (this.shouldVerify()) {
            StateStoreRowWithChecksum valWithChecksum = (StateStoreRowWithChecksum)value;
            int expected = valWithChecksum.checksum();
            int computed = KeyValueChecksum$.MODULE$.create(key, (Option<UnsafeRow>)new Some((Object)valWithChecksum.unsafeRow()));
            this.verifyChecksum(expected, computed);
            return;
        }
    }

    @Override
    public void verify(byte[] keyBytes, Option<byte[]> valueBytes, int expectedChecksum) {
        if (this.shouldVerify()) {
            int computed = KeyValueChecksum$.MODULE$.create(keyBytes, valueBytes);
            this.verifyChecksum(expectedChecksum, computed);
            return;
        }
    }

    @Override
    public void verify(ArrayIndexRange<Object> keyBytes, Option<ArrayIndexRange<Object>> valueBytes, int expectedChecksum) {
        if (this.shouldVerify()) {
            int computed = KeyValueChecksum$.MODULE$.create(keyBytes, valueBytes);
            this.verifyChecksum(expectedChecksum, computed);
            return;
        }
    }

    private void verifyChecksum(int expected, int computed) {
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Verifying row checksum, expected: " + expected + ", computed: " + computed);
        if (expected != computed) {
            this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Row checksum verification failed for store ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.STATE_STORE_ID, $this.storeId)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Expected checksum: ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.CHECKSUM, BoxesRunTime.boxToInteger((int)expected))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Computed checksum: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.CHECKSUM, BoxesRunTime.boxToInteger((int)computed))})))));
            throw StateStoreErrors$.MODULE$.rowChecksumVerificationFailed(this.storeId, expected, computed);
        }
    }

    public KeyValueChecksumVerifier(String storeId, long verificationRatio) {
        this.storeId = storeId;
        this.verificationRatio = verificationRatio;
        Logging.$init$((Logging)this);
        Predef$.MODULE$.assert(verificationRatio > 0L, (Function0 & Serializable)() -> "Verification ratio must be greater than 0");
        this.numRequests = 0L;
        this.numVerified = 0L;
    }
}

