/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.ttl;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.StateTypesEncoder;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.StateTypesEncoder$;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.TransformWithStateKeyValueRowSchemaUtils$;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.ttl.OneToOneTTLState;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.ttl.StateTTL$;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.ttl.TTLState;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.ttl.ValueStateImplWithTTL$;
import org.apache.spark.sql.execution.streaming.state.NoPrefixKeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.streaming.TTLConfig;
import org.apache.spark.sql.streaming.ValueState;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005]e\u0001\u0002\r\u001a\u00019B\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u001f\"A!\f\u0001B\u0001B\u0003%1\f\u0003\u0005d\u0001\t\u0005\t\u0015!\u0003\\\u0011!!\u0007A!A!\u0002\u0013)\u0007\u0002\u00035\u0001\u0005\u0003\u0005\u000b\u0011B5\t\u00111\u0004!\u0011!Q\u0001\n5DQA\u001e\u0001\u0005\u0002]D\u0011\"!\u0001\u0001\u0005\u0004%I!a\u0001\t\u0011\u00055\u0001\u0001)A\u0005\u0003\u000bAq!a\u0004\u0001\t\u0013\t\t\u0002C\u0004\u0002\u001a\u0001!\t%a\u0007\t\u000f\u0005\r\u0002\u0001\"\u0011\u0002&!9\u0011q\u0005\u0001\u0005B\u0005%\u0002bBA\u0018\u0001\u0011\u0005\u0013\u0011\u0003\u0005\t\u0003c\u0001A\u0011A\u0013\u00024!A\u00111\b\u0001\u0005\u0002\u0015\ni\u0004\u0003\u0005\u0002H\u0001!\t!JA%\u000f%\ti%GA\u0001\u0012\u0003\tyE\u0002\u0005\u00193\u0005\u0005\t\u0012AA)\u0011\u00191H\u0003\"\u0001\u0002j!I\u00111\u000e\u000b\u0012\u0002\u0013\u0005\u0011Q\u000e\u0005\n\u0003\u000f#\u0012\u0011!C\u0005\u0003\u0013\u0013QCV1mk\u0016\u001cF/\u0019;f\u00136\u0004HnV5uQR#FJ\u0003\u0002\u001b7\u0005\u0019A\u000f\u001e7\u000b\u0005qi\u0012A\u0005;sC:\u001chm\u001c:no&$\bn\u001d;bi\u0016T!AH\u0010\u0002\u0011M$\u0018\r^3gk2T!\u0001I\u0011\u0002\u0013=\u0004XM]1u_J\u001c(B\u0001\u0012$\u0003%\u0019HO]3b[&twM\u0003\u0002%K\u0005IQ\r_3dkRLwN\u001c\u0006\u0003M\u001d\n1a]9m\u0015\tA\u0013&A\u0003ta\u0006\u00148N\u0003\u0002+W\u00051\u0011\r]1dQ\u0016T\u0011\u0001L\u0001\u0004_J<7\u0001A\u000b\u0003_m\u001a2\u0001\u0001\u00195!\t\t$'D\u0001\u001a\u0013\t\u0019\u0014D\u0001\tP]\u0016$vn\u00148f)Rc5\u000b^1uKB\u0019QgN\u001d\u000e\u0003YR!AI\u0013\n\u0005a2$A\u0003,bYV,7\u000b^1uKB\u0011!h\u000f\u0007\u0001\t\u0015a\u0004A1\u0001>\u0005\u0005\u0019\u0016C\u0001 E!\ty$)D\u0001A\u0015\u0005\t\u0015!B:dC2\f\u0017BA\"A\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aP#\n\u0005\u0019\u0003%aA!os\u0006)1\u000f^8sKB\u0011\u0011\nT\u0007\u0002\u0015*\u00111*I\u0001\u0006gR\fG/Z\u0005\u0003\u001b*\u0013!b\u0015;bi\u0016\u001cFo\u001c:f\u0003%\u0019H/\u0019;f\u001d\u0006lW\r\u0005\u0002Q/:\u0011\u0011+\u0016\t\u0003%\u0002k\u0011a\u0015\u0006\u0003)6\na\u0001\u0010:p_Rt\u0014B\u0001,A\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001,\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Y\u0003\u0015AC6fs\u0016C\bO]#oGB\u0019A,\u0019#\u000e\u0003uS!AX0\u0002\u0011\u0015t7m\u001c3feNT!\u0001Y\u0013\u0002\u0011\r\fG/\u00197zgRL!AY/\u0003#\u0015C\bO]3tg&|g.\u00128d_\u0012,'/\u0001\u0006wC2,enY8eKJ\f\u0011\u0002\u001e;m\u0007>tg-[4\u0011\u0005U2\u0017BA47\u0005%!F\u000bT\"p]\u001aLw-\u0001\tcCR\u001c\u0007\u000eV5nKN$\u0018-\u001c9NgB\u0011qH[\u0005\u0003W\u0002\u0013A\u0001T8oO\u00069Q.\u001a;sS\u000e\u001c\b\u0003\u0002)o\u001fBL!a\\-\u0003\u00075\u000b\u0007\u000f\u0005\u0002ri6\t!O\u0003\u0002tG\u00051Q.\u001a;sS\u000eL!!\u001e:\u0003\u0013M\u000bF*T3ue&\u001c\u0017A\u0002\u001fj]&$h\b\u0006\u0005ysj\\H0 @\u0000!\r\t\u0004!\u000f\u0005\u0006\u000f\"\u0001\r\u0001\u0013\u0005\u0006\u001d\"\u0001\ra\u0014\u0005\u00065\"\u0001\ra\u0017\u0005\u0006G\"\u0001\ra\u0017\u0005\u0006I\"\u0001\r!\u001a\u0005\u0006Q\"\u0001\r!\u001b\u0005\bY\"\u0001\n\u00111\u0001n\u0003E\u0019H/\u0019;f)f\u0004Xm]#oG>$WM]\u000b\u0003\u0003\u000b\u0001R!a\u0002\u0002\n\u0011k\u0011aG\u0005\u0004\u0003\u0017Y\"!E*uCR,G+\u001f9fg\u0016s7m\u001c3fe\u0006\u00112\u000f^1uKRK\b/Z:F]\u000e|G-\u001a:!\u0003)Ig.\u001b;jC2L'0\u001a\u000b\u0003\u0003'\u00012aPA\u000b\u0013\r\t9\u0002\u0011\u0002\u0005+:LG/\u0001\u0004fq&\u001cHo\u001d\u000b\u0003\u0003;\u00012aPA\u0010\u0013\r\t\t\u0003\u0011\u0002\b\u0005>|G.Z1o\u0003\r9W\r\u001e\u000b\u0002s\u00051Q\u000f\u001d3bi\u0016$B!a\u0005\u0002,!1\u0011Q\u0006\bA\u0002e\n\u0001B\\3x'R\fG/Z\u0001\u0006G2,\u0017M]\u0001\u0017O\u0016$x+\u001b;i_V$XI\u001c4pe\u000eLgn\u001a+U\u0019R\u0011\u0011Q\u0007\t\u0005\u007f\u0005]\u0012(C\u0002\u0002:\u0001\u0013aa\u00149uS>t\u0017aC4fiR#FJV1mk\u0016$\"!a\u0010\u0011\u000b}\n9$!\u0011\u0011\u000b}\n\u0019%O5\n\u0007\u0005\u0015\u0003I\u0001\u0004UkBdWMM\u0001\u0013O\u0016$h+\u00197vK&sG\u000b\u0016'Ti\u0006$X\r\u0006\u0002\u0002LA!q(a\u000ej\u0003U1\u0016\r\\;f'R\fG/Z%na2<\u0016\u000e\u001e5U)2\u0003\"!\r\u000b\u0014\u000bQ\t\u0019&!\u0017\u0011\u0007}\n)&C\u0002\u0002X\u0001\u0013a!\u00118z%\u00164\u0007\u0003BA.\u0003Kj!!!\u0018\u000b\t\u0005}\u0013\u0011M\u0001\u0003S>T!!a\u0019\u0002\t)\fg/Y\u0005\u0005\u0003O\niF\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0002P\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uI]*B!a\u001c\u0002\u0006V\u0011\u0011\u0011\u000f\u0016\u0004[\u0006M4FAA;!\u0011\t9(!!\u000e\u0005\u0005e$\u0002BA>\u0003{\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005}\u0004)\u0001\u0006b]:|G/\u0019;j_:LA!a!\u0002z\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000bq2\"\u0019A\u001f\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005-\u0005\u0003BAG\u0003'k!!a$\u000b\t\u0005E\u0015\u0011M\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u0016\u0006=%AB(cU\u0016\u001cG\u000f")
public class ValueStateImplWithTTL<S>
extends OneToOneTTLState
implements ValueState<S> {
    private final StateStore store;
    private final String stateName;
    private final ExpressionEncoder<Object> keyExprEnc;
    private final ExpressionEncoder<Object> valEncoder;
    private final TTLConfig ttlConfig;
    private final long batchTimestampMs;
    private final StateTypesEncoder<Object> stateTypesEncoder;

    public static <S> Map<String, SQLMetric> $lessinit$greater$default$7() {
        return ValueStateImplWithTTL$.MODULE$.$lessinit$greater$default$7();
    }

    private StateTypesEncoder<Object> stateTypesEncoder() {
        return this.stateTypesEncoder;
    }

    private void initialize() {
        this.store.createColFamilyIfAbsent(this.stateName, this.keyExprEnc.schema(), TransformWithStateKeyValueRowSchemaUtils$.MODULE$.getValueSchemaWithTTL(this.valEncoder.schema(), true), new NoPrefixKeyStateEncoderSpec(this.keyExprEnc.schema()), this.store.createColFamilyIfAbsent$default$5(), this.store.createColFamilyIfAbsent$default$6());
    }

    public boolean exists() {
        return this.get() != null;
    }

    public S get() {
        UnsafeRow encodedGroupingKey = this.stateTypesEncoder().encodeGroupingKey();
        UnsafeRow retRow = this.store.get(encodedGroupingKey, this.stateName);
        if (retRow != null) {
            Object resState = this.stateTypesEncoder().decodeValue(retRow);
            if (!this.stateTypesEncoder().isExpired(retRow, this.batchTimestampMs)) {
                return (S)resState;
            }
            return null;
        }
        return null;
    }

    public void update(S newState) {
        UnsafeRow encodedKey = this.stateTypesEncoder().encodeGroupingKey();
        long ttlExpirationMs = StateTTL$.MODULE$.calculateExpirationTimeForDuration(this.ttlConfig.ttlDuration(), this.batchTimestampMs);
        UnsafeRow encodedValue = this.stateTypesEncoder().encodeValue(newState, ttlExpirationMs);
        this.updatePrimaryAndSecondaryIndices(encodedKey, encodedValue, ttlExpirationMs);
    }

    public void clear() {
        UnsafeRow groupingKey = this.stateTypesEncoder().encodeGroupingKey();
        this.clearAllStateForElementKey(groupingKey);
    }

    public Option<S> getWithoutEnforcingTTL() {
        UnsafeRow encodedGroupingKey = this.stateTypesEncoder().encodeGroupingKey();
        UnsafeRow retRow = this.store.get(encodedGroupingKey, this.stateName);
        if (retRow != null) {
            Object resState = this.stateTypesEncoder().decodeValue(retRow);
            return new Some(resState);
        }
        return None$.MODULE$;
    }

    public Option<Tuple2<S, Object>> getTTLValue() {
        UnsafeRow encodedGroupingKey = this.stateTypesEncoder().encodeGroupingKey();
        UnsafeRow retRow = this.store.get(encodedGroupingKey, this.stateName);
        if (retRow != null) {
            Option<Object> ttlExpiration = this.stateTypesEncoder().decodeTtlExpirationMs(retRow);
            return ttlExpiration.map((Function1 & Serializable)expiration -> ValueStateImplWithTTL.$anonfun$getTTLValue$1(this, retRow, BoxesRunTime.unboxToLong((Object)expiration)));
        }
        return None$.MODULE$;
    }

    public Option<Object> getValueInTTLState() {
        UnsafeRow groupingKey = this.stateTypesEncoder().encodeGroupingKey();
        Seq ttlRowsForGroupingKey = this.getTTLRows().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ValueStateImplWithTTL.$anonfun$getValueInTTLState$1(groupingKey, x$1))).toSeq();
        Predef$.MODULE$.assert(ttlRowsForGroupingKey.size() <= 1, (Function0 & Serializable)() -> "Multiple TTLRows found for grouping key " + groupingKey + ". Expected at most 1. Found: " + ttlRowsForGroupingKey.mkString(", ") + ".");
        return ttlRowsForGroupingKey.headOption().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.expirationMs()));
    }

    public static final /* synthetic */ Tuple2 $anonfun$getTTLValue$1(ValueStateImplWithTTL $this, UnsafeRow retRow$1, long expiration) {
        return new Tuple2($this.stateTypesEncoder().decodeValue(retRow$1), (Object)BoxesRunTime.boxToLong((long)expiration));
    }

    public static final /* synthetic */ boolean $anonfun$getValueInTTLState$1(UnsafeRow groupingKey$1, TTLState.TTLRow x$1) {
        UnsafeRow unsafeRow = x$1.elementKey();
        UnsafeRow unsafeRow2 = groupingKey$1;
        return !(unsafeRow != null ? !unsafeRow.equals(unsafeRow2) : unsafeRow2 != null);
    }

    public ValueStateImplWithTTL(StateStore store, String stateName, ExpressionEncoder<Object> keyExprEnc, ExpressionEncoder<Object> valEncoder, TTLConfig ttlConfig, long batchTimestampMs, Map<String, SQLMetric> metrics) {
        this.store = store;
        this.stateName = stateName;
        this.keyExprEnc = keyExprEnc;
        this.valEncoder = valEncoder;
        this.ttlConfig = ttlConfig;
        this.batchTimestampMs = batchTimestampMs;
        super(stateName, store, keyExprEnc.schema(), ttlConfig, batchTimestampMs, metrics);
        this.stateTypesEncoder = StateTypesEncoder$.MODULE$.apply(keyExprEnc, valEncoder, stateName, true);
        this.initialize();
    }
}

