/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.server;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.jetty.http.DateGenerator;
import org.sparkproject.jetty.http.HttpField;
import org.sparkproject.jetty.http.HttpHeader;
import org.sparkproject.jetty.http.MimeTypes;
import org.sparkproject.jetty.io.ArrayByteBufferPool;
import org.sparkproject.jetty.io.ByteBufferPool;
import org.sparkproject.jetty.server.Connector;
import org.sparkproject.jetty.server.Context;
import org.sparkproject.jetty.server.Handler;
import org.sparkproject.jetty.server.NetworkConnector;
import org.sparkproject.jetty.server.Request;
import org.sparkproject.jetty.server.RequestLog;
import org.sparkproject.jetty.server.Response;
import org.sparkproject.jetty.server.ServerConnector;
import org.sparkproject.jetty.server.ShutdownMonitor;
import org.sparkproject.jetty.server.ShutdownService;
import org.sparkproject.jetty.server.handler.ContextHandler;
import org.sparkproject.jetty.server.handler.ErrorHandler;
import org.sparkproject.jetty.server.internal.ResponseHttpFields;
import org.sparkproject.jetty.util.Attributes;
import org.sparkproject.jetty.util.Callback;
import org.sparkproject.jetty.util.DecoratedObjectFactory;
import org.sparkproject.jetty.util.ExceptionUtil;
import org.sparkproject.jetty.util.IO;
import org.sparkproject.jetty.util.Jetty;
import org.sparkproject.jetty.util.NanoTime;
import org.sparkproject.jetty.util.VirtualThreads;
import org.sparkproject.jetty.util.annotation.ManagedAttribute;
import org.sparkproject.jetty.util.annotation.ManagedObject;
import org.sparkproject.jetty.util.annotation.Name;
import org.sparkproject.jetty.util.component.AbstractLifeCycle;
import org.sparkproject.jetty.util.component.AttributeContainerMap;
import org.sparkproject.jetty.util.component.ClassLoaderDump;
import org.sparkproject.jetty.util.component.DumpableAttributes;
import org.sparkproject.jetty.util.component.DumpableCollection;
import org.sparkproject.jetty.util.component.DumpableMap;
import org.sparkproject.jetty.util.component.Environment;
import org.sparkproject.jetty.util.component.Graceful;
import org.sparkproject.jetty.util.component.LifeCycle;
import org.sparkproject.jetty.util.resource.FileSystemPool;
import org.sparkproject.jetty.util.resource.Resource;
import org.sparkproject.jetty.util.resource.ResourceFactory;
import org.sparkproject.jetty.util.thread.AutoLock;
import org.sparkproject.jetty.util.thread.Invocable;
import org.sparkproject.jetty.util.thread.QueuedThreadPool;
import org.sparkproject.jetty.util.thread.ScheduledExecutorScheduler;
import org.sparkproject.jetty.util.thread.Scheduler;
import org.sparkproject.jetty.util.thread.ShutdownThread;
import org.sparkproject.jetty.util.thread.ThreadPool;

@ManagedObject
public class Server
extends Handler.Wrapper
implements Attributes {
    private static final Logger LOG = LoggerFactory.getLogger(Server.class);
    private static final String __serverInfo = "jetty/" + Server.getVersion();
    private final AttributeContainerMap _attributes = new AttributeContainerMap();
    private final ThreadPool _threadPool;
    private final Scheduler _scheduler;
    private final ByteBufferPool _bufferPool;
    private final List<Connector> _connectors = new CopyOnWriteArrayList<Connector>();
    private final Context _serverContext = new ServerContext();
    private final AutoLock _dateLock = new AutoLock();
    private final MimeTypes.Mutable _mimeTypes = new MimeTypes.Mutable();
    private String _serverInfo = __serverInfo;
    private ZonedDateTime _startupDateTime;
    private boolean _openEarly = true;
    private boolean _stopAtShutdown;
    private boolean _dumpAfterStart;
    private boolean _dumpBeforeStop;
    private Handler _defaultHandler;
    private Request.Handler _errorHandler;
    private RequestLog _requestLog;
    private boolean _dryRun;
    private volatile DateField _dateField;
    private long _stopTimeout;
    private Invocable.InvocationType _invocationType = Invocable.InvocationType.NON_BLOCKING;
    private File _tempDirectory;
    private String _name;

    public Server() {
        this((ThreadPool)null);
    }

    public Server(@Name(value="port") int port) {
        this((ThreadPool)null);
        ServerConnector connector = new ServerConnector(this);
        connector.setPort(port);
        this.addConnector(connector);
        this.installBean(this._attributes);
    }

    public Server(@Name(value="address") InetSocketAddress addr) {
        this((ThreadPool)null);
        ServerConnector connector = new ServerConnector(this);
        connector.setHost(addr.getHostName());
        connector.setPort(addr.getPort());
        this.addConnector(connector);
    }

    public Server(@Name(value="threadPool") ThreadPool pool) {
        this(pool, null, null);
        this.installBean(new DumpableMap("System Properties", System.getProperties()));
    }

    public Server(@Name(value="threadPool") ThreadPool threadPool, @Name(value="scheduler") Scheduler scheduler, @Name(value="bufferPool") ByteBufferPool bufferPool) {
        this._threadPool = threadPool != null ? threadPool : new QueuedThreadPool();
        this.installBean(this._threadPool);
        this._scheduler = scheduler != null ? scheduler : new ScheduledExecutorScheduler();
        this.installBean(this._scheduler);
        this._bufferPool = bufferPool != null ? bufferPool : new ArrayByteBufferPool();
        this.installBean(this._bufferPool);
        this.setServer(this);
        this.installBean(FileSystemPool.INSTANCE, false);
    }

    @ManagedAttribute(value="The name of this server")
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = Objects.requireNonNull(name);
    }

    public Handler getDefaultHandler() {
        return this._defaultHandler;
    }

    public void setDefaultHandler(Handler defaultHandler) {
        if (!this.isDynamic() && this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        if (defaultHandler != null) {
            defaultHandler.setServer(this);
        }
        Handler old = this._defaultHandler;
        this._defaultHandler = defaultHandler;
        this.updateBean(old, defaultHandler);
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        Handler next = this.getHandler();
        return next != null && next.handle(request, response, callback) || this._defaultHandler != null && this._defaultHandler.handle(request, response, callback);
    }

    @ManagedAttribute(value="The server information")
    public String getServerInfo() {
        return this._serverInfo;
    }

    public void setServerInfo(String serverInfo) {
        this._serverInfo = serverInfo;
    }

    public void setTempDirectory(String temp) {
        this.setTempDirectory(IO.asFile(temp));
    }

    public void setTempDirectory(File temp) {
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        if (temp != null && !temp.exists()) {
            throw new IllegalArgumentException("Does not exist: " + String.valueOf(temp));
        }
        if (temp != null && !temp.canWrite()) {
            throw new IllegalArgumentException("Cannot write: " + String.valueOf(temp));
        }
        this._tempDirectory = temp;
    }

    @ManagedAttribute(value="The server temporary directory", readonly=true)
    public File getTempDirectory() {
        return this._tempDirectory;
    }

    public Context getContext() {
        return this._serverContext;
    }

    public MimeTypes.Mutable getMimeTypes() {
        return this._mimeTypes;
    }

    @Override
    public Invocable.InvocationType getInvocationType() {
        if (this.isDynamic()) {
            return Invocable.InvocationType.BLOCKING;
        }
        if (this.isStarted()) {
            return this._invocationType;
        }
        Invocable.InvocationType type = Invocable.InvocationType.NON_BLOCKING;
        Handler handler = this.getHandler();
        if (handler != null) {
            type = Invocable.combine(type, handler.getInvocationType());
        }
        if ((handler = this.getDefaultHandler()) != null) {
            type = Invocable.combine(type, handler.getInvocationType());
        }
        return type;
    }

    @ManagedAttribute(value="Whether server connectors are opened before other components are started")
    public boolean isOpenEarly() {
        return this._openEarly;
    }

    public void setOpenEarly(boolean openEarly) {
        this._openEarly = openEarly;
    }

    public boolean isDryRun() {
        return this._dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this._dryRun = dryRun;
    }

    public RequestLog getRequestLog() {
        return this._requestLog;
    }

    public Request.Handler getErrorHandler() {
        return this._errorHandler;
    }

    public void setRequestLog(RequestLog requestLog) {
        this.updateBean(this._requestLog, requestLog);
        this._requestLog = requestLog;
    }

    public void setErrorHandler(Request.Handler errorHandler) {
        if (errorHandler instanceof Handler) {
            Handler handler = (Handler)errorHandler;
            handler.setServer(this);
        }
        this.updateBean(this._errorHandler, errorHandler);
        this._errorHandler = errorHandler;
    }

    @ManagedAttribute(value="The version of this server")
    public static String getVersion() {
        return Jetty.VERSION;
    }

    public void setStopTimeout(long stopTimeout) {
        this._stopTimeout = stopTimeout;
    }

    @ManagedAttribute(value="The server stop timeout")
    public long getStopTimeout() {
        return this._stopTimeout;
    }

    @ManagedAttribute(value="Whether the server is stopped when the JVM is shut down")
    public boolean getStopAtShutdown() {
        return this._stopAtShutdown;
    }

    public void setStopAtShutdown(boolean stop) {
        if (stop) {
            if (!this._stopAtShutdown && this.isStarted()) {
                ShutdownThread.register(this);
            }
        } else {
            ShutdownThread.deregister(this);
        }
        this._stopAtShutdown = stop;
    }

    @ManagedAttribute(value="connectors for this server", readonly=true)
    public Connector[] getConnectors() {
        ArrayList<Connector> connectors = new ArrayList<Connector>(this._connectors);
        return connectors.toArray(new Connector[0]);
    }

    public void addConnector(Connector connector) {
        if (connector.getServer() != this) {
            throw new IllegalArgumentException("Connector " + String.valueOf(connector) + " cannot be shared among server " + String.valueOf(connector.getServer()) + " and server " + String.valueOf(this));
        }
        this._connectors.add(connector);
        this.addBean(connector);
    }

    public void removeConnector(Connector connector) {
        if (this._connectors.remove(connector)) {
            this.removeBean(connector);
        }
    }

    public void setConnectors(Connector[] connectors) {
        if (connectors != null) {
            for (Connector connector : connectors) {
                if (connector.getServer() == this) continue;
                throw new IllegalArgumentException("Connector " + String.valueOf(connector) + " cannot be shared among server " + String.valueOf(connector.getServer()) + " and server " + String.valueOf(this));
            }
        }
        Object[] oldConnectors = this.getConnectors();
        this.updateBeans(oldConnectors, connectors);
        this._connectors.removeAll(Arrays.asList(oldConnectors));
        if (connectors != null) {
            this._connectors.addAll(Arrays.asList(connectors));
        }
    }

    public void addBeanToAllConnectors(Object bean) {
        for (Connector connector : this.getConnectors()) {
            connector.addBean(bean);
        }
    }

    @ManagedAttribute(value="The server Thread pool")
    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    @ManagedAttribute(value="The server Scheduler")
    public Scheduler getScheduler() {
        return this._scheduler;
    }

    @ManagedAttribute(value="The server ByteBuffer pool")
    public ByteBufferPool getByteBufferPool() {
        return this._bufferPool;
    }

    @ManagedAttribute(value="Whether to dump the server to stderr after start")
    public boolean isDumpAfterStart() {
        return this._dumpAfterStart;
    }

    public void setDumpAfterStart(boolean dumpAfterStart) {
        this._dumpAfterStart = dumpAfterStart;
    }

    @ManagedAttribute(value="Whether to dump the server to stderr before stop")
    public boolean isDumpBeforeStop() {
        return this._dumpBeforeStop;
    }

    public void setDumpBeforeStop(boolean dumpBeforeStop) {
        this._dumpBeforeStop = dumpBeforeStop;
    }

    public HttpField getDateField() {
        long now = System.currentTimeMillis();
        long seconds = now / 1000L;
        DateField df = this._dateField;
        if (df == null || df.seconds != seconds) {
            try (AutoLock ignore = this._dateLock.lock();){
                df = this._dateField;
                if (df == null || df.seconds != seconds) {
                    ResponseHttpFields.PersistentPreEncodedHttpField field = new ResponseHttpFields.PersistentPreEncodedHttpField(HttpHeader.DATE, DateGenerator.formatDate(now));
                    this._dateField = new DateField(seconds, field);
                    ResponseHttpFields.PersistentPreEncodedHttpField persistentPreEncodedHttpField = field;
                    return persistentPreEncodedHttpField;
                }
            }
        }
        return df.dateField;
    }

    public ZonedDateTime getStartupDateTime() {
        return this._startupDateTime;
    }

    public long getUptimeMillis() {
        return this._startupDateTime == null ? 0L : Duration.between(this._startupDateTime, ZonedDateTime.now()).toMillis();
    }

    @Override
    protected void doStart() throws Exception {
        try {
            ShutdownMonitor shutdownMonitor;
            this._startupDateTime = ZonedDateTime.now();
            if (this.getStopAtShutdown()) {
                ShutdownThread.register(this);
            }
            if ((shutdownMonitor = ShutdownMonitor.getConfiguredInstance()) != null) {
                this.addBean(shutdownMonitor);
            }
            for (ShutdownService service : this.getBeans(ShutdownService.class)) {
                service.addComponent(this);
                service.start();
            }
            if (this._errorHandler == null) {
                this.setErrorHandler(new DynamicErrorHandler());
            }
            String gitHash = Jetty.GIT_HASH;
            String timestamp = Jetty.BUILD_TIMESTAMP;
            LOG.info("jetty-{}; built: {}; git: {}; jvm {}", new Object[]{Server.getVersion(), timestamp, gitHash, System.getProperty("java.runtime.version", System.getProperty("java.version"))});
            if (!Jetty.STABLE) {
                LOG.warn("THIS IS NOT A STABLE RELEASE! DO NOT USE IN PRODUCTION!");
                LOG.warn("Download a stable release from https://jetty.org/download.html");
            }
            ExceptionUtil.MultiException multiException = new ExceptionUtil.MultiException();
            if (!this.isDryRun() && this.isOpenEarly()) {
                this._connectors.stream().filter(NetworkConnector.class::isInstance).map(NetworkConnector.class::cast).forEach(connector -> {
                    try {
                        connector.open();
                    }
                    catch (Throwable th) {
                        multiException.add(th);
                    }
                });
                multiException.ifExceptionThrow();
            }
            super.doStart();
            this._invocationType = this.getInvocationType();
            if (this._dryRun) {
                LOG.info("Started(dry run) {} @{}ms", (Object)this, (Object)this.getUptimeMillis());
                throw new AbstractLifeCycle.StopException();
            }
            for (Connector connector2 : this._connectors) {
                try {
                    connector2.start();
                }
                catch (Throwable e) {
                    multiException.add(e);
                    this._connectors.stream().filter(LifeCycle::isRunning).map(Object.class::cast).forEach(LifeCycle::stop);
                }
            }
            multiException.ifExceptionThrow();
            LOG.info("Started {} @{}ms", (Object)this, (Object)this.getUptimeMillis());
        }
        catch (Throwable th) {
            this._connectors.stream().filter(NetworkConnector.class::isInstance).map(NetworkConnector.class::cast).forEach(nc -> {
                block2: {
                    try {
                        nc.close();
                    }
                    catch (Throwable th2) {
                        if (th == th2) break block2;
                        th.addSuppressed(th2);
                    }
                }
            });
            throw th;
        }
        finally {
            if (!(!this.isDumpAfterStart() || this._dryRun && this.isDumpBeforeStop())) {
                this.dumpStdErr();
            }
        }
    }

    @Override
    protected void start(LifeCycle l) throws Exception {
        if (!(l instanceof Connector)) {
            super.start(l);
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.isDumpBeforeStop()) {
            this.dumpStdErr();
        }
        LOG.info("Stopped {}", (Object)this);
        if (LOG.isDebugEnabled()) {
            LOG.debug("doStop {}", (Object)this);
        }
        this._startupDateTime = null;
        Throwable multiException = null;
        if (this.getStopTimeout() > 0L) {
            long end = NanoTime.now() + TimeUnit.MILLISECONDS.toNanos(this.getStopTimeout());
            try {
                Graceful.shutdown(this).get(this.getStopTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (Throwable e) {
                multiException = ExceptionUtil.combine(multiException, e);
            }
            QueuedThreadPool qtp = this.getBean(QueuedThreadPool.class);
            if (qtp != null) {
                qtp.setStopTimeout(Math.max(1000L, NanoTime.millisUntil(end)));
            }
        }
        for (Connector connector : this._connectors) {
            try {
                connector.stop();
            }
            catch (Throwable e) {
                multiException = ExceptionUtil.combine(multiException, e);
            }
        }
        try {
            super.doStop();
        }
        catch (Throwable e) {
            multiException = ExceptionUtil.combine(multiException, e);
        }
        if (this.getErrorHandler() instanceof DynamicErrorHandler) {
            this.setErrorHandler(null);
        }
        if (this.getStopAtShutdown()) {
            ShutdownThread.deregister(this);
        }
        for (ShutdownService service : this.getBeans(ShutdownService.class)) {
            service.removeComponent(this);
        }
        ExceptionUtil.ifExceptionThrow(multiException);
    }

    public void join() throws InterruptedException {
        this.getThreadPool().join();
    }

    @Override
    public Object setAttribute(String name, Object attribute) {
        return this._attributes.setAttribute(name, attribute);
    }

    @Override
    public Object removeAttribute(String name) {
        return this._attributes.removeAttribute(name);
    }

    @Override
    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    @Override
    public Set<String> getAttributeNameSet() {
        return this._attributes.getAttributeNameSet();
    }

    @Override
    public void clearAttributes() {
        this._attributes.clearAttributes();
    }

    public URI getURI() {
        NetworkConnector connector = null;
        for (Connector c : this._connectors) {
            if (!(c instanceof NetworkConnector)) continue;
            connector = (NetworkConnector)c;
            break;
        }
        if (connector == null) {
            return null;
        }
        ContextHandler context = this.getDescendant(ContextHandler.class);
        try {
            String host;
            String protocol = connector.getDefaultConnectionFactory().getProtocol();
            String scheme = "http";
            if (protocol.startsWith("SSL-") || protocol.equals("SSL")) {
                scheme = "https";
            }
            if ((host = connector.getHost()) == null) {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            int port = connector.getLocalPort();
            String path = "/";
            if (context != null) {
                int at;
                Optional<String> vhost = context.getVirtualHosts().stream().filter(h -> !h.startsWith("*.") && !h.startsWith("@")).findFirst();
                if (vhost.isPresent() && (at = (host = vhost.get()).indexOf(64)) > 0) {
                    host = host.substring(0, at);
                }
                path = context.getContextPath();
            }
            return new URI(scheme, null, host, port, path, null, null);
        }
        catch (Exception e) {
            LOG.warn("Unable to build server URI", (Throwable)e);
            return null;
        }
    }

    @Override
    public Server getServer() {
        return this;
    }

    public Resource getDefaultStyleSheet() {
        return this.newResource("/org/sparkproject/jetty/server/jetty-dir.css");
    }

    public Resource getDefaultFavicon() {
        return this.newResource("/org/sparkproject/jetty/server/favicon.ico");
    }

    private Resource newResource(String name) {
        URL url = this.getClass().getResource(name);
        if (url == null) {
            throw new IllegalStateException("Missing server resource: " + name);
        }
        return ResourceFactory.root().newMemoryResource(url);
    }

    @Override
    public String toString() {
        return String.format("%s[%s,sto=%d]", super.toString(), Server.getVersion(), this.getStopTimeout());
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, new ClassLoaderDump(this.getClass().getClassLoader()), new DumpableCollection("environments", Environment.getAll()), new DumpableAttributes("attributes", this._attributes), FileSystemPool.INSTANCE);
    }

    public static void main(String ... args) {
        System.err.println(Server.getVersion());
    }

    class ServerContext
    extends Attributes.Wrapper
    implements Context {
        private final File jettyBase;
        private final File workDir;
        private final File tempDir;

        private ServerContext() {
            super(Server.this);
            this.jettyBase = IO.asFile(System.getProperty("jetty.base"));
            this.workDir = this.jettyBase != null && this.jettyBase.isDirectory() && this.jettyBase.canWrite() ? new File(this.jettyBase, "work") : null;
            this.tempDir = this.workDir != null && this.workDir.isDirectory() && this.workDir.canWrite() ? this.workDir : IO.asFile(System.getProperty("java.io.tmpdir"));
        }

        @Override
        public String getContextPath() {
            return null;
        }

        @Override
        public MimeTypes getMimeTypes() {
            return Server.this._mimeTypes;
        }

        @Override
        public ClassLoader getClassLoader() {
            return Server.class.getClassLoader();
        }

        @Override
        public Resource getBaseResource() {
            return null;
        }

        @Override
        public List<String> getVirtualHosts() {
            return Collections.emptyList();
        }

        @Override
        public void run(Runnable runnable) {
            runnable.run();
        }

        @Override
        public void run(Runnable runnable, Request request) {
            runnable.run();
        }

        @Override
        public void execute(Runnable runnable) {
            VirtualThreads.execute(Server.this.getThreadPool(), runnable);
        }

        @Override
        public Request.Handler getErrorHandler() {
            return Server.this.getErrorHandler();
        }

        @Override
        public <T> T decorate(T o) {
            DecoratedObjectFactory factory = Server.this.getBean(DecoratedObjectFactory.class);
            if (factory != null) {
                return factory.decorate(o);
            }
            return o;
        }

        @Override
        public void destroy(Object o) {
            DecoratedObjectFactory factory = Server.this.getBean(DecoratedObjectFactory.class);
            if (factory != null) {
                factory.destroy(o);
            }
        }

        @Override
        public String getPathInContext(String canonicallyEncodedPath) {
            return canonicallyEncodedPath;
        }

        @Override
        public File getTempDirectory() {
            return Objects.requireNonNullElse(Server.this.getTempDirectory(), this.tempDir);
        }

        public String toString() {
            return "ServerContext@%x".formatted(Server.this.hashCode());
        }
    }

    private record DateField(long seconds, HttpField dateField) {
    }

    private static class DynamicErrorHandler
    extends ErrorHandler {
        private DynamicErrorHandler() {
        }
    }
}

