/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URI;
import java.net.URLDecoder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00054Aa\u0002\u0005\u0005#!A!\u0005\u0001B\u0001B\u0003%1\u0005\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0011\u0015)\u0004\u0001\"\u00017\u0011\u0015Y\u0004\u0001\"\u0011=\u0011\u0015y\u0005\u0001\"\u0003Q\u0011\u0015Y\u0006\u0001\"\u0003]\u0005MAE\u000f\u001e9t%\u0016$\u0017N]3di\u001aKG\u000e^3s\u0015\tI!\"\u0001\u0002vS*\u00111\u0002D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0011\"\u0004\u0005\u0002\u001415\tAC\u0003\u0002\u0016-\u0005!A.\u00198h\u0015\u00059\u0012\u0001\u00026bm\u0006L!!\u0007\u000b\u0003\r=\u0013'.Z2u!\tY\u0002%D\u0001\u001d\u0015\tib$A\u0004tKJ4H.\u001a;\u000b\u0003}\tqA[1lCJ$\u0018-\u0003\u0002\"9\t1a)\u001b7uKJ\faa]2iK6,\u0007C\u0001\u0013.\u001d\t)3\u0006\u0005\u0002'S5\tqE\u0003\u0002)!\u00051AH]8pizR\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\na\u0001\u0015:fI\u00164\u0017B\u0001\u00180\u0005\u0019\u0019FO]5oO*\u0011A&K\u0001\u000bg\u0016\u001cWO]3Q_J$\bC\u0001\u001a4\u001b\u0005I\u0013B\u0001\u001b*\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007]J$\b\u0005\u00029\u00015\t\u0001\u0002C\u0003#\u0007\u0001\u00071\u0005C\u00031\u0007\u0001\u0007\u0011'\u0001\u0005e_\u001aKG\u000e^3s)\u0011i\u0004)\u0012&\u0011\u0005Ir\u0014BA *\u0005\u0011)f.\u001b;\t\u000b\u0005#\u0001\u0019\u0001\"\u0002\u000fI,\u0017/^3tiB\u00111dQ\u0005\u0003\tr\u0011abU3sm2,GOU3rk\u0016\u001cH\u000fC\u0003G\t\u0001\u0007q)\u0001\u0005sKN\u0004xN\\:f!\tY\u0002*\u0003\u0002J9\ty1+\u001a:wY\u0016$(+Z:q_:\u001cX\rC\u0003L\t\u0001\u0007A*A\u0003dQ\u0006Lg\u000e\u0005\u0002\u001c\u001b&\u0011a\n\b\u0002\f\r&dG/\u001a:DQ\u0006Lg.A\tde\u0016\fG/\u001a*fI&\u0014Xm\u0019;V%&#BaI)S)\")!%\u0002a\u0001G!)1+\u0002a\u0001c\u0005!\u0001o\u001c:u\u0011\u0015\tU\u00011\u0001V!\t1\u0016,D\u0001X\u0015\tAF$\u0001\u0003iiR\u0004\u0018B\u0001.X\u0005IAE\u000f\u001e9TKJ4H.\u001a;SKF,Xm\u001d;\u0002\u0013\u0011,7m\u001c3f+JcEcA\u0012^?\")aL\u0002a\u0001G\u0005\u0019QO\u001d7\t\u000b\u00014\u0001\u0019A\u0012\u0002\u0011\u0015t7m\u001c3j]\u001e\u0004")
public class HttpsRedirectFilter
implements Filter {
    private final String scheme;
    private final int securePort;

    public void init(FilterConfig x$1) throws ServletException {
        super.init(x$1);
    }

    public void destroy() {
        super.destroy();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
        if (request.isSecure()) {
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String httpsURI = this.createRedirectURI(this.scheme, this.securePort, httpRequest);
        httpResponse.setContentLength(0);
        httpResponse.sendRedirect(httpResponse.encodeRedirectURL(httpsURI));
    }

    private String createRedirectURI(String scheme, int port, HttpServletRequest request) {
        String server = request.getServerName();
        String redirectServer = server.contains(":") && !server.startsWith("[") ? "[" + server + "]" : server;
        String authority = redirectServer + ":" + port;
        String characterEncoding = request.getCharacterEncoding() != null ? request.getCharacterEncoding() : "UTF-8";
        String requestURI = this.decodeURL(request.getRequestURI(), characterEncoding);
        String queryString = this.decodeURL(request.getQueryString(), characterEncoding);
        return new URI(scheme, authority, requestURI, queryString, null).toString();
    }

    private String decodeURL(String url, String encoding) {
        if (url == null) {
            return null;
        }
        return URLDecoder.decode(url, encoding);
    }

    public HttpsRedirectFilter(String scheme, int securePort) {
        this.scheme = scheme;
        this.securePort = securePort;
    }
}

