/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.bytes;

import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LittleEndianDataOutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(LittleEndianDataOutputStream.class);
    private final OutputStream out;
    private byte[] writeBuffer = new byte[8];

    public LittleEndianDataOutputStream(OutputStream out) {
        this.out = out;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    public final void writeBoolean(boolean v) throws IOException {
        this.out.write(v ? 1 : 0);
    }

    public final void writeByte(int v) throws IOException {
        this.out.write(v);
    }

    public final void writeShort(int v) throws IOException {
        this.out.write(v >>> 0 & 0xFF);
        this.out.write(v >>> 8 & 0xFF);
    }

    public final void writeInt(int v) throws IOException {
        this.out.write(v >>> 0 & 0xFF);
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v >>> 16 & 0xFF);
        this.out.write(v >>> 24 & 0xFF);
    }

    public final void writeLong(long v) throws IOException {
        this.writeBuffer[7] = (byte)(v >>> 56);
        this.writeBuffer[6] = (byte)(v >>> 48);
        this.writeBuffer[5] = (byte)(v >>> 40);
        this.writeBuffer[4] = (byte)(v >>> 32);
        this.writeBuffer[3] = (byte)(v >>> 24);
        this.writeBuffer[2] = (byte)(v >>> 16);
        this.writeBuffer[1] = (byte)(v >>> 8);
        this.writeBuffer[0] = (byte)(v >>> 0);
        this.out.write(this.writeBuffer, 0, 8);
    }

    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void close() {
        block8: {
            try (OutputStream os = this.out;){
                os.flush();
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug("Exception in flushing arrayOut before close", (Throwable)e);
            }
        }
    }
}

