/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volcano.api.model.flow.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.volcano.api.model.flow.v1alpha1.DependsOn;
import io.fabric8.volcano.api.model.flow.v1alpha1.Probe;
import io.fabric8.volcano.api.model.flow.v1alpha1.ProbeBuilder;
import io.fabric8.volcano.api.model.flow.v1alpha1.ProbeFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class DependsOnFluent<A extends DependsOnFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ProbeBuilder probe;
    private List<String> targets = new ArrayList<String>();

    public DependsOnFluent() {
    }

    public DependsOnFluent(DependsOn instance) {
        this.copyInstance(instance);
    }

    public A addAllToTargets(Collection<String> items) {
        if (this.targets == null) {
            this.targets = new ArrayList<String>();
        }
        for (String item : items) {
            this.targets.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToTargets(String ... items) {
        if (this.targets == null) {
            this.targets = new ArrayList<String>();
        }
        for (String item : items) {
            this.targets.add(item);
        }
        return (A)((Object)this);
    }

    public A addToTargets(int index, String item) {
        if (this.targets == null) {
            this.targets = new ArrayList<String>();
        }
        this.targets.add(index, item);
        return (A)((Object)this);
    }

    public Probe buildProbe() {
        return this.probe != null ? this.probe.build() : null;
    }

    protected void copyInstance(DependsOn instance) {
        DependsOn dependsOn = instance = instance != null ? instance : new DependsOn();
        if (instance != null) {
            this.withProbe(instance.getProbe());
            this.withTargets(instance.getTargets());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ProbeNested<A> editOrNewProbe() {
        return this.withNewProbeLike(Optional.ofNullable(this.buildProbe()).orElse(new ProbeBuilder().build()));
    }

    public ProbeNested<A> editOrNewProbeLike(Probe item) {
        return this.withNewProbeLike(Optional.ofNullable(this.buildProbe()).orElse(item));
    }

    public ProbeNested<A> editProbe() {
        return this.withNewProbeLike(Optional.ofNullable(this.buildProbe()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DependsOnFluent that = (DependsOnFluent)((Object)o);
        if (!Objects.equals((Object)this.probe, (Object)that.probe)) {
            return false;
        }
        if (!Objects.equals(this.targets, that.targets)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getFirstTarget() {
        return this.targets.get(0);
    }

    public String getLastTarget() {
        return this.targets.get(this.targets.size() - 1);
    }

    public String getMatchingTarget(Predicate<String> predicate) {
        for (String item : this.targets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getTarget(int index) {
        return this.targets.get(index);
    }

    public List<String> getTargets() {
        return this.targets;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasMatchingTarget(Predicate<String> predicate) {
        for (String item : this.targets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasProbe() {
        return this.probe != null;
    }

    public boolean hasTargets() {
        return this.targets != null && !this.targets.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.probe, this.targets, this.additionalProperties});
    }

    public A removeAllFromTargets(Collection<String> items) {
        if (this.targets == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.targets.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromTargets(String ... items) {
        if (this.targets == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.targets.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToTargets(int index, String item) {
        if (this.targets == null) {
            this.targets = new ArrayList<String>();
        }
        this.targets.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.probe != null) {
            sb.append("probe:");
            sb.append((Object)this.probe);
            sb.append(",");
        }
        if (this.targets != null && !this.targets.isEmpty()) {
            sb.append("targets:");
            sb.append(this.targets);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public ProbeNested<A> withNewProbe() {
        return new ProbeNested(null);
    }

    public ProbeNested<A> withNewProbeLike(Probe item) {
        return new ProbeNested(item);
    }

    public A withProbe(Probe probe) {
        this._visitables.remove((Object)"probe");
        if (probe != null) {
            this.probe = new ProbeBuilder(probe);
            this._visitables.get((Object)"probe").add(this.probe);
        } else {
            this.probe = null;
            this._visitables.get((Object)"probe").remove((Object)this.probe);
        }
        return (A)((Object)this);
    }

    public A withTargets(List<String> targets) {
        if (targets != null) {
            this.targets = new ArrayList<String>();
            for (String item : targets) {
                this.addToTargets(item);
            }
        } else {
            this.targets = null;
        }
        return (A)((Object)this);
    }

    public A withTargets(String ... targets) {
        if (this.targets != null) {
            this.targets.clear();
            this._visitables.remove((Object)"targets");
        }
        if (targets != null) {
            for (String item : targets) {
                this.addToTargets(item);
            }
        }
        return (A)((Object)this);
    }

    public class ProbeNested<N>
    extends ProbeFluent<ProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        ProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)DependsOnFluent.this.withProbe(this.builder.build());
        }

        public N endProbe() {
            return this.and();
        }
    }
}

