/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.fpm.FPGrowth;
import org.apache.spark.mllib.fpm.FPGrowthModel;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class SimpleFPGrowth$ {
    public static final SimpleFPGrowth$ MODULE$ = new SimpleFPGrowth$();

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("SimpleFPGrowth");
        SparkContext sc = new SparkContext(conf);
        RDD data = sc.textFile("data/mllib/sample_fpgrowth.txt", sc.textFile$default$2());
        RDD transactions = data.map((Function1 & Serializable)s -> StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(s.trim()), ' '), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        FPGrowth fpg = new FPGrowth().setMinSupport(0.2).setNumPartitions(10);
        FPGrowthModel model = fpg.run(transactions, ClassTag$.MODULE$.apply(String.class));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])model.freqItemsets().collect()), (Function1 & Serializable)itemset -> {
            Predef$.MODULE$.println((Object)(Predef$.MODULE$.wrapRefArray((Object[])itemset.items()).mkString("[", ",", "]") + "," + itemset.freq()));
            return BoxedUnit.UNIT;
        });
        double minConfidence = 0.8;
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])model.generateAssociationRules(minConfidence).collect()), (Function1 & Serializable)rule -> {
            Predef$.MODULE$.println((Object)(Predef$.MODULE$.wrapRefArray((Object[])rule.antecedent()).mkString("[", ",", "]") + "=> " + Predef$.MODULE$.wrapRefArray((Object[])rule.consequent()).mkString("[", ",", "]") + "," + rule.confidence()));
            return BoxedUnit.UNIT;
        });
        sc.stop();
    }

    private SimpleFPGrowth$() {
    }
}

