/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.classification.NaiveBayes;
import org.apache.spark.ml.classification.NaiveBayesModel;
import org.apache.spark.ml.evaluation.MulticlassClassificationEvaluator;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;

public class JavaNaiveBayesExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaNaiveBayesExample").getOrCreate();
        Dataset dataFrame = spark.read().format("libsvm").load("data/mllib/sample_libsvm_data.txt");
        Dataset[] splits = dataFrame.randomSplit(new double[]{0.6, 0.4}, 1234L);
        Dataset train = splits[0];
        Dataset test = splits[1];
        NaiveBayes nb = new NaiveBayes();
        NaiveBayesModel model = (NaiveBayesModel)nb.fit(train);
        Dataset predictions = model.transform(test);
        predictions.show();
        MulticlassClassificationEvaluator evaluator = new MulticlassClassificationEvaluator().setLabelCol("label").setPredictionCol("prediction").setMetricName("accuracy");
        double accuracy = evaluator.evaluate(predictions);
        System.out.println("Test set accuracy = " + accuracy);
        spark.stop();
    }
}

