/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util.geo;

import org.apache.spark.sql.catalyst.util.geo.GeoTypeId;
import org.apache.spark.sql.catalyst.util.geo.GeometryModel;

class Point
extends GeometryModel {
    private final double[] coordinates;
    private final boolean isEmpty;

    Point(double[] coordinates, int srid, boolean hasZ, boolean hasM) {
        super(GeoTypeId.POINT, srid, hasZ, hasM);
        this.coordinates = coordinates;
        boolean empty = false;
        for (double coord : coordinates) {
            if (!Double.isNaN(coord)) continue;
            empty = true;
            break;
        }
        this.isEmpty = empty;
    }

    Point(double[] coordinates, int srid) {
        this(coordinates, srid, coordinates.length >= 3, coordinates.length >= 4);
    }

    double getX() {
        return this.coordinates.length > 0 ? this.coordinates[0] : Double.NaN;
    }

    double getY() {
        return this.coordinates.length > 1 ? this.coordinates[1] : Double.NaN;
    }

    double getZ() {
        return this.hasZ && this.coordinates.length > 2 ? this.coordinates[2] : Double.NaN;
    }

    double getM() {
        if (!this.hasM) {
            return Double.NaN;
        }
        if (this.hasZ) {
            return this.coordinates.length > 3 ? this.coordinates[3] : Double.NaN;
        }
        return this.coordinates.length > 2 ? this.coordinates[2] : Double.NaN;
    }

    double[] getCoordinates() {
        return this.coordinates;
    }

    @Override
    boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    int getDimensionCount() {
        return this.coordinates.length;
    }
}

