/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.VectorFunctionImplUtils;
import org.apache.spark.sql.catalyst.expressions.VectorNormalize$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(vector, degree) - Normalizes a float vector to unit length using the specified norm degree.\n    Degree defaults to 2.0 (Euclidean norm) if unspecified. Supported values: 1.0 (L1 norm),\n    2.0 (L2 norm), float('inf') (infinity norm).\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(3.0F, 4.0F), 2.0F);\n       [0.6,0.8]\n      > SELECT _FUNC_(array(3.0F, 4.0F), 1.0F);\n       [0.42857143,0.5714286]\n      > SELECT _FUNC_(array(3.0F, 4.0F), float('inf'));\n       [0.75,1.0]\n  ", since="4.2.0", group="vector_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005%g\u0001B\u000f\u001f\u0001.B\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005Y!Aa\n\u0001BK\u0002\u0013\u0005A\n\u0003\u0005P\u0001\tE\t\u0015!\u0003-\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u0015\u0001\u0006\u0001\"\u0001V\u0011\u00159\u0006\u0001\"\u0011Y\u0011!y\u0006\u0001#b\u0001\n\u0003b\u0005\"\u00021\u0001\t\u0003\n\u0007\"\u00026\u0001\t\u0003Z\u0007\"B8\u0001\t#\u0002\bb\u0002<\u0001\u0003\u0003%\ta\u001e\u0005\bu\u0002\t\n\u0011\"\u0001|\u0011!\ti\u0001AI\u0001\n\u0003Y\b\"CA\b\u0001\u0005\u0005I\u0011IA\t\u0011%\t\t\u0003AA\u0001\n\u0003\t\u0019\u0003C\u0005\u0002,\u0001\t\t\u0011\"\u0001\u0002.!I\u0011\u0011\b\u0001\u0002\u0002\u0013\u0005\u00131\b\u0005\n\u0003\u0013\u0002\u0011\u0011!C\u0001\u0003\u0017B\u0011\"!\u0016\u0001\u0003\u0003%\t%a\u0016\t\u0013\u0005m\u0003!!A\u0005B\u0005us!CAA=\u0005\u0005\t\u0012AAB\r!ib$!A\t\u0002\u0005\u0015\u0005B\u0002)\u0018\t\u0003\ti\nC\u0005\u0002 ^\t\t\u0011\"\u0012\u0002\"\"I\u00111U\f\u0002\u0002\u0013\u0005\u0015Q\u0015\u0005\n\u0003W;\u0012\u0011!CA\u0003[C\u0011\"a0\u0018\u0003\u0003%I!!1\u0003\u001fY+7\r^8s\u001d>\u0014X.\u00197ju\u0016T!a\b\u0011\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003C\t\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003G\u0011\n1a]9m\u0015\t)c%A\u0003ta\u0006\u00148N\u0003\u0002(Q\u00051\u0011\r]1dQ\u0016T\u0011!K\u0001\u0004_J<7\u0001A\n\u0007\u00011\u00024'O \u0011\u00055rS\"\u0001\u0010\n\u0005=r\"AC#yaJ,7o]5p]B\u0011Q&M\u0005\u0003ey\u0011!CU;oi&lWMU3qY\u0006\u001cW-\u00192mKB\u0011AgN\u0007\u0002k)\u0011aGI\u0001\u0007KJ\u0014xN]:\n\u0005a*$aD)vKJLXI\u001d:peN\u0014\u0015m]3\u0011\u0005ijT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001\t\u0013\b\u0003\u0003\u001as!AQ#\u000e\u0003\rS!\u0001\u0012\u0016\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0014BA$<\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0013&\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005\u001d[\u0014A\u0002<fGR|'/F\u0001-\u0003\u001d1Xm\u0019;pe\u0002\na\u0001Z3he\u0016,\u0017a\u00023fOJ,W\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007I\u001bF\u000b\u0005\u0002.\u0001!)1*\u0002a\u0001Y!)a*\u0002a\u0001YQ\u0011!K\u0016\u0005\u0006\u0017\u001a\u0001\r\u0001L\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u00023B\u0011!,X\u0007\u00027*\u0011A\fI\u0001\tC:\fG._:jg&\u0011al\u0017\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006Y!/\u001a9mC\u000e,W.\u001a8u\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002EB\u00111m\u001a\b\u0003I\u0016\u0004\"AQ\u001e\n\u0005\u0019\\\u0014A\u0002)sK\u0012,g-\u0003\u0002iS\n11\u000b\u001e:j]\u001eT!AZ\u001e\u0002\u0011\rD\u0017\u000e\u001c3sK:,\u0012\u0001\u001c\t\u0004\u00016d\u0013B\u00018K\u0005\r\u0019V-]\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$\"AU9\t\u000bI\\\u0001\u0019A:\u0002\u00179,wo\u00115jY\u0012\u0014XM\u001c\t\u0004\u0001Rd\u0013BA;K\u0005)Ie\u000eZ3yK\u0012\u001cV-]\u0001\u0005G>\u0004\u0018\u0010F\u0002SqfDqa\u0013\u0007\u0011\u0002\u0003\u0007A\u0006C\u0004O\u0019A\u0005\t\u0019\u0001\u0017\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\tAP\u000b\u0002-{.\na\u0010E\u0002\u0000\u0003\u0013i!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0002<\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0017\t\tAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003'\u0001B!!\u0006\u0002 5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"\u0001\u0003mC:<'BAA\u000f\u0003\u0011Q\u0017M^1\n\u0007!\f9\"\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002&A\u0019!(a\n\n\u0007\u0005%2HA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u00020\u0005U\u0002c\u0001\u001e\u00022%\u0019\u00111G\u001e\u0003\u0007\u0005s\u0017\u0010C\u0005\u00028E\t\t\u00111\u0001\u0002&\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u0010\u0011\r\u0005}\u0012QIA\u0018\u001b\t\t\tEC\u0002\u0002Dm\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9%!\u0011\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u001b\n\u0019\u0006E\u0002;\u0003\u001fJ1!!\u0015<\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\u000e\u0014\u0003\u0003\u0005\r!a\f\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003'\tI\u0006C\u0005\u00028Q\t\t\u00111\u0001\u0002&\u00051Q-];bYN$B!!\u0014\u0002`!I\u0011qG\u000b\u0002\u0002\u0003\u0007\u0011q\u0006\u0015\u0014\u0001\u0005\r\u0014\u0011NA6\u0003_\n\t(!\u001e\u0002x\u0005m\u0014Q\u0010\t\u0004[\u0005\u0015\u0014bAA4=\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA7\u0003\u0005E(\u0002\t\u0011!A}3UKT\"`QY,7\r^8sY\u0001\"Wm\u001a:fK&\u0002S\u0006\t(pe6\fG.\u001b>fg\u0002\n\u0007E\u001a7pCR\u0004c/Z2u_J\u0004Co\u001c\u0011v]&$\b\u0005\\3oORD\u0007%^:j]\u001e\u0004C\u000f[3!gB,7-\u001b4jK\u0012\u0004cn\u001c:nA\u0011,wM]3f])\u0001\u0003\u0005\t\u0011EK\u001e\u0014X-\u001a\u0011eK\u001a\fW\u000f\u001c;tAQ|\u0007E\r\u00181A!*Uo\u00197jI\u0016\fg\u000e\t8pe6L\u0003%\u001b4!k:\u001c\b/Z2jM&,GM\f\u0011TkB\u0004xN\u001d;fI\u00022\u0018\r\\;fgj\u0002\u0013G\f\u0019!Q1\u000b\u0004E\\8s[&b#\u0002\t\u0011!AIr\u0003\u0007\t\u0015Me\u0001rwN]7*Y\u00012Gn\\1uQ\u001dJgNZ\u0014*A!JgNZ5oSRL\bE\\8s[&r#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a\u001d\u0002\u0003+T\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfD3G\f\u0019GY\u0001\"d\u0006\r$*Y\u0001\u0012d\u0006\r$*w)\u0001\u0003\u0005\t\u0011!A\u0001Z\u0006G\f\u001c-a9BTL\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u001a/a\u0019c\u0003\u0005\u000e\u00181\r&b\u0003%\r\u00181\r&Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u0017\u0019/iIBTgN\u00195g1\u0002d&N\u001c2iIBd'\u0018\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u00154]A2E\u0006\t\u001b/a\u0019KC\u0006\t4m_\u0006$\bfJ5oM\u001eJ\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\a9:T\u0007L\u0019/auS\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003s\nQ\u0001\u000e\u00183]A\nQa\u001a:pkB\f#!a \u0002\u0019Y,7\r^8s?\u001a,hnY:\u0002\u001fY+7\r^8s\u001d>\u0014X.\u00197ju\u0016\u0004\"!L\f\u0014\u000b]\t9)a%\u0011\u000f\u0005%\u0015q\u0012\u0017-%6\u0011\u00111\u0012\u0006\u0004\u0003\u001b[\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003#\u000bYIA\tBEN$(/Y2u\rVt7\r^5p]J\u0002B!!&\u0002\u001c6\u0011\u0011q\u0013\u0006\u0005\u00033\u000bY\"\u0001\u0002j_&\u0019\u0011*a&\u0015\u0005\u0005\r\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005M\u0011!B1qa2LH#\u0002*\u0002(\u0006%\u0006\"B&\u001b\u0001\u0004a\u0003\"\u0002(\u001b\u0001\u0004a\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u0003_\u000bY\fE\u0003;\u0003c\u000b),C\u0002\u00024n\u0012aa\u00149uS>t\u0007#\u0002\u001e\u000282b\u0013bAA]w\t1A+\u001e9mKJB\u0001\"!0\u001c\u0003\u0003\u0005\rAU\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAAb!\u0011\t)\"!2\n\t\u0005\u001d\u0017q\u0003\u0002\u0007\u001f\nTWm\u0019;")
public class VectorNormalize
extends Expression
implements RuntimeReplaceable,
QueryErrorsBase,
Serializable {
    private Expression replacement;
    private final Expression vector;
    private final Expression degree;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(VectorNormalize x$0) {
        return VectorNormalize$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, VectorNormalize> tupled() {
        return VectorNormalize$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, VectorNormalize>> curried() {
        return VectorNormalize$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        VectorNormalize vectorNormalize = this;
        synchronized (vectorNormalize) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression vector() {
        return this.vector;
    }

    public Expression degree() {
        return this.degree;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        ArrayType arrayType;
        DataType dataType;
        DataType dataType2;
        Tuple2 tuple2 = new Tuple2((Object)this.vector().dataType(), (Object)this.degree().dataType());
        if (tuple2 != null) {
            ArrayType arrayType2;
            DataType dataType3;
            DataType dataType4 = (DataType)tuple2._1();
            DataType dataType5 = (DataType)tuple2._2();
            if (dataType4 instanceof ArrayType && FloatType$.MODULE$.equals(dataType3 = (arrayType2 = (ArrayType)dataType4).elementType()) && FloatType$.MODULE$.equals(dataType5)) {
                return TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null && (dataType2 = (DataType)tuple2._1()) instanceof ArrayType && FloatType$.MODULE$.equals(dataType = (arrayType = (ArrayType)dataType2).elementType())) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)this.ordinalNumber(1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)FloatType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.degree())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.degree().dataType()))}))));
        }
        return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)this.ordinalNumber(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)ArrayType$.MODULE$.apply((DataType)FloatType$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.vector())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.vector().dataType()))}))));
    }

    private Expression replacement$lzycompute() {
        VectorNormalize vectorNormalize = this;
        synchronized (vectorNormalize) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = new StaticInvoke(VectorFunctionImplUtils.class, (DataType)ArrayType$.MODULE$.apply((DataType)FloatType$.MODULE$), "vectorNormalize", (Seq<Expression>)new .colon.colon((Object)this.vector(), (List)new .colon.colon((Object)this.degree(), (List)new .colon.colon((Object)Literal$.MODULE$.apply(this.prettyName()), (List)Nil$.MODULE$))), (Seq<AbstractDataType>)new .colon.colon((Object)ArrayType$.MODULE$.apply((DataType)FloatType$.MODULE$), (List)new .colon.colon((Object)FloatType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$))), StaticInvoke$.MODULE$.apply$default$6(), StaticInvoke$.MODULE$.apply$default$7(), StaticInvoke$.MODULE$.apply$default$8(), StaticInvoke$.MODULE$.apply$default$9());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public String prettyName() {
        return "vector_normalize";
    }

    @Override
    public Seq<Expression> children() {
        return new .colon.colon((Object)this.vector(), (List)new .colon.colon((Object)this.degree(), (List)Nil$.MODULE$));
    }

    @Override
    public VectorNormalize withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1));
    }

    public VectorNormalize copy(Expression vector, Expression degree) {
        return new VectorNormalize(vector, degree);
    }

    public Expression copy$default$1() {
        return this.vector();
    }

    public Expression copy$default$2() {
        return this.degree();
    }

    @Override
    public String productPrefix() {
        return "VectorNormalize";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.vector();
            }
            case 1: {
                return this.degree();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof VectorNormalize;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "vector";
            }
            case 1: {
                return "degree";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof VectorNormalize)) return false;
        boolean bl = true;
        if (!bl) return false;
        VectorNormalize vectorNormalize = (VectorNormalize)x$1;
        Expression expression = this.vector();
        Expression expression2 = vectorNormalize.vector();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.degree();
        Expression expression4 = vectorNormalize.degree();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!vectorNormalize.canEqual(this)) return false;
        return true;
    }

    public VectorNormalize(Expression vector, Expression degree) {
        this.vector = vector;
        this.degree = degree;
        RuntimeReplaceable.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        Statics.releaseFence();
    }

    public VectorNormalize(Expression vector) {
        this(vector, Literal$.MODULE$.apply(BoxesRunTime.boxToFloat((float)2.0f)));
    }
}

